/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.action;

import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.bined.action.CodeAreaAction;
import org.exbin.framework.utils.ActionUtils;

@ParametersAreNonnullByDefault
public class PrintAction
extends AbstractAction
implements CodeAreaAction {
    public static final String ACTION_ID = "printAction";
    private CodeAreaCore codeArea;
    private XBApplication application;
    private ResourceBundle resourceBundle;

    public void setup(XBApplication application, ResourceBundle resourceBundle) {
        this.application = application;
        this.resourceBundle = resourceBundle;
        ActionUtils.setupAction((Action)this, (ResourceBundle)resourceBundle, (String)ACTION_ID);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, ActionUtils.getMetaMask()));
        this.putValue("dialogMode", true);
    }

    @Override
    public void updateForActiveCodeArea(@Nullable CodeAreaCore codeArea) {
        this.codeArea = codeArea;
        this.setEnabled(codeArea != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PrinterJob job = PrinterJob.getPrinterJob();
        if (job.printDialog()) {
            try {
                job.setPrintable((graphics, pageFormat, pageIndex) -> {
                    this.codeArea.print(graphics);
                    if (pageIndex == 0) {
                        return 0;
                    }
                    return 1;
                });
                job.print();
            }
            catch (PrinterException ex) {
                Logger.getLogger(PrintAction.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

