/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.action;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.exbin.bined.PositionCodeType;
import org.exbin.bined.extended.capability.PositionCodeTypeCapable;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.bined.action.CodeAreaAction;
import org.exbin.framework.utils.ActionUtils;

@ParametersAreNonnullByDefault
public class PositionCodeTypeActions
implements CodeAreaAction {
    public static final String OCTAL_POSITION_CODE_TYPE_ACTION_ID = "octalPositionCodeTypeAction";
    public static final String DECIMAL_POSITION_CODE_TYPE_ACTION_ID = "decimalPositionCodeTypeAction";
    public static final String HEXADECIMAL_POSITION_CODE_TYPE_ACTION_ID = "hexadecimalPositionCodeTypeAction";
    public static final String POSITION_CODE_TYPE_RADIO_GROUP_ID = "positionCodeTypeRadioGroup";
    private CodeAreaCore codeArea;
    private XBApplication application;
    private ResourceBundle resourceBundle;
    private Action octalPositionCodeTypeAction;
    private Action decimalPositionCodeTypeAction;
    private Action hexadecimalPositionCodeTypeAction;
    private PositionCodeType positionCodeType = PositionCodeType.HEXADECIMAL;

    public void setup(XBApplication application, ResourceBundle resourceBundle) {
        this.application = application;
        this.resourceBundle = resourceBundle;
    }

    @Override
    public void updateForActiveCodeArea(@Nullable CodeAreaCore codeArea) {
        PositionCodeType activePositionCodeType;
        this.codeArea = codeArea;
        PositionCodeType positionCodeType = activePositionCodeType = codeArea != null ? ((PositionCodeTypeCapable)codeArea).getPositionCodeType() : null;
        if (activePositionCodeType != null) {
            this.positionCodeType = activePositionCodeType;
        }
        if (this.octalPositionCodeTypeAction != null) {
            this.octalPositionCodeTypeAction.setEnabled(codeArea != null);
            if (activePositionCodeType == PositionCodeType.OCTAL) {
                this.octalPositionCodeTypeAction.putValue("SwingSelectedKey", true);
            }
        }
        if (this.decimalPositionCodeTypeAction != null) {
            this.decimalPositionCodeTypeAction.setEnabled(codeArea != null);
            if (activePositionCodeType == PositionCodeType.DECIMAL) {
                this.decimalPositionCodeTypeAction.putValue("SwingSelectedKey", true);
            }
        }
        if (this.hexadecimalPositionCodeTypeAction != null) {
            this.hexadecimalPositionCodeTypeAction.setEnabled(codeArea != null);
            if (activePositionCodeType == PositionCodeType.HEXADECIMAL) {
                this.hexadecimalPositionCodeTypeAction.putValue("SwingSelectedKey", true);
            }
        }
    }

    public void setCodeType(PositionCodeType codeType) {
        this.positionCodeType = codeType;
        ((PositionCodeTypeCapable)this.codeArea).setPositionCodeType(codeType);
    }

    @Nonnull
    public Action getOctalCodeTypeAction() {
        if (this.octalPositionCodeTypeAction == null) {
            this.octalPositionCodeTypeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PositionCodeTypeActions.this.setCodeType(PositionCodeType.OCTAL);
                }
            };
            ActionUtils.setupAction((Action)this.octalPositionCodeTypeAction, (ResourceBundle)this.resourceBundle, (String)OCTAL_POSITION_CODE_TYPE_ACTION_ID);
            this.octalPositionCodeTypeAction.putValue("type", ActionUtils.ActionType.RADIO);
            this.octalPositionCodeTypeAction.putValue("radioGroup", POSITION_CODE_TYPE_RADIO_GROUP_ID);
            this.octalPositionCodeTypeAction.putValue("SwingSelectedKey", this.positionCodeType == PositionCodeType.OCTAL);
        }
        return this.octalPositionCodeTypeAction;
    }

    @Nonnull
    public Action getDecimalCodeTypeAction() {
        if (this.decimalPositionCodeTypeAction == null) {
            this.decimalPositionCodeTypeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PositionCodeTypeActions.this.setCodeType(PositionCodeType.DECIMAL);
                }
            };
            ActionUtils.setupAction((Action)this.decimalPositionCodeTypeAction, (ResourceBundle)this.resourceBundle, (String)DECIMAL_POSITION_CODE_TYPE_ACTION_ID);
            this.decimalPositionCodeTypeAction.putValue("radioGroup", POSITION_CODE_TYPE_RADIO_GROUP_ID);
            this.decimalPositionCodeTypeAction.putValue("type", ActionUtils.ActionType.RADIO);
            this.decimalPositionCodeTypeAction.putValue("SwingSelectedKey", this.positionCodeType == PositionCodeType.DECIMAL);
        }
        return this.decimalPositionCodeTypeAction;
    }

    @Nonnull
    public Action getHexadecimalCodeTypeAction() {
        if (this.hexadecimalPositionCodeTypeAction == null) {
            this.hexadecimalPositionCodeTypeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PositionCodeTypeActions.this.setCodeType(PositionCodeType.HEXADECIMAL);
                }
            };
            ActionUtils.setupAction((Action)this.hexadecimalPositionCodeTypeAction, (ResourceBundle)this.resourceBundle, (String)HEXADECIMAL_POSITION_CODE_TYPE_ACTION_ID);
            this.hexadecimalPositionCodeTypeAction.putValue("type", ActionUtils.ActionType.RADIO);
            this.hexadecimalPositionCodeTypeAction.putValue("radioGroup", POSITION_CODE_TYPE_RADIO_GROUP_ID);
            this.hexadecimalPositionCodeTypeAction.putValue("SwingSelectedKey", this.positionCodeType == PositionCodeType.HEXADECIMAL);
        }
        return this.hexadecimalPositionCodeTypeAction;
    }
}

