/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.action;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.exbin.bined.capability.CaretCapable;
import org.exbin.bined.capability.ScrollingCapable;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.bined.action.CodeAreaAction;
import org.exbin.framework.bined.gui.GoToPositionPanel;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;

@ParametersAreNonnullByDefault
public class GoToPositionAction
extends AbstractAction
implements CodeAreaAction {
    public static final String ACTION_ID = "goToPositionAction";
    private XBApplication application;
    private ResourceBundle resourceBundle;
    private CodeAreaCore codeArea;

    public void setup(XBApplication application, ResourceBundle resourceBundle) {
        this.application = application;
        this.resourceBundle = resourceBundle;
        ActionUtils.setupAction((Action)this, (ResourceBundle)resourceBundle, (String)ACTION_ID);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(71, ActionUtils.getMetaMask()));
        this.putValue("dialogMode", true);
    }

    @Override
    public void updateForActiveCodeArea(@Nullable CodeAreaCore codeArea) {
        this.codeArea = codeArea;
        this.setEnabled(codeArea != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GoToPositionPanel goToPanel = new GoToPositionPanel();
        goToPanel.setCursorPosition(((CaretCapable)this.codeArea).getDataPosition());
        goToPanel.setMaxPosition(this.codeArea.getDataSize());
        DefaultControlPanel controlPanel = new DefaultControlPanel(goToPanel.getResourceBundle());
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((Component)this.codeArea, Dialog.ModalityType.APPLICATION_MODAL, (JPanel)goToPanel, (JPanel)controlPanel);
        WindowUtils.addHeaderPanel((Window)dialog.getWindow(), goToPanel.getClass(), (ResourceBundle)goToPanel.getResourceBundle());
        frameModule.setDialogTitle(dialog, goToPanel.getResourceBundle());
        controlPanel.setHandler(actionType -> {
            if (actionType == DefaultControlHandler.ControlActionType.OK) {
                goToPanel.acceptInput();
                ((CaretCapable)this.codeArea).setCaretPosition(goToPanel.getTargetPosition());
                ((ScrollingCapable)this.codeArea).revealCursor();
            }
            dialog.close();
            dialog.dispose();
        });
        SwingUtilities.invokeLater(goToPanel::initFocus);
        dialog.showCentered((Component)this.codeArea);
    }
}

