/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.bined.action.CodeAreaAction;
import org.exbin.framework.utils.ActionUtils;

@ParametersAreNonnullByDefault
public class ClipboardCodeActions
implements CodeAreaAction {
    public static final String COPY_AS_CODE_ACTION_ID = "copyAsCodeAction";
    public static final String PASTE_FROM_CODE_ACTION_ID = "pasteFromCodeAction";
    private CodeAreaCore codeArea;
    private XBApplication application;
    private ResourceBundle resourceBundle;
    private Action copyAsCodeAction;
    private Action pasteFromCodeAction;

    public void setup(XBApplication application, ResourceBundle resourceBundle) {
        this.application = application;
        this.resourceBundle = resourceBundle;
    }

    @Override
    public void updateForActiveCodeArea(@Nullable CodeAreaCore codeArea) {
        this.codeArea = codeArea;
        boolean hasSelection = false;
        boolean canPaste = false;
        if (codeArea != null) {
            hasSelection = codeArea.hasSelection();
            canPaste = codeArea.canPaste();
        }
        if (this.copyAsCodeAction != null) {
            this.copyAsCodeAction.setEnabled(hasSelection);
        }
        if (this.pasteFromCodeAction != null) {
            this.pasteFromCodeAction.setEnabled(canPaste);
        }
    }

    @Nonnull
    public Action getCopyAsCodeAction() {
        if (this.copyAsCodeAction == null) {
            this.copyAsCodeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClipboardCodeActions.this.codeArea.copyAsCode();
                }
            };
            ActionUtils.setupAction((Action)this.copyAsCodeAction, (ResourceBundle)this.resourceBundle, (String)COPY_AS_CODE_ACTION_ID);
        }
        return this.copyAsCodeAction;
    }

    @Nonnull
    public Action getPasteFromCodeAction() {
        if (this.pasteFromCodeAction == null) {
            this.pasteFromCodeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ClipboardCodeActions.this.codeArea.pasteFromCode();
                    }
                    catch (IllegalArgumentException ex) {
                        JOptionPane.showMessageDialog((Component)e.getSource(), ex.getMessage(), "Unable to Paste Code", 0);
                    }
                }
            };
            ActionUtils.setupAction((Action)this.pasteFromCodeAction, (ResourceBundle)this.resourceBundle, (String)PASTE_FROM_CODE_ACTION_ID);
        }
        return this.pasteFromCodeAction;
    }
}

