/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.exbin.bined.EditOperation;
import org.exbin.bined.PositionCodeType;
import org.exbin.bined.basic.BasicCodeAreaZone;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.framework.XBFrameworkUtils;
import org.exbin.framework.action.api.ActionModuleApi;
import org.exbin.framework.action.api.MenuGroup;
import org.exbin.framework.action.api.MenuPosition;
import org.exbin.framework.action.api.NextToMode;
import org.exbin.framework.action.api.PositionMode;
import org.exbin.framework.action.api.SeparationMode;
import org.exbin.framework.action.api.ToolBarGroup;
import org.exbin.framework.action.api.ToolBarPosition;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.api.XBApplicationModule;
import org.exbin.framework.api.XBModuleRepositoryUtils;
import org.exbin.framework.bined.BinEdEditorProvider;
import org.exbin.framework.bined.BinEdFileHandler;
import org.exbin.framework.bined.BinEdFileManager;
import org.exbin.framework.bined.BinaryEditorProvider;
import org.exbin.framework.bined.BinaryMultiEditorProvider;
import org.exbin.framework.bined.BinaryStatusApi;
import org.exbin.framework.bined.BinedOptionsManager;
import org.exbin.framework.bined.CodeAreaCommandHandlerProvider;
import org.exbin.framework.bined.FileHandlingMode;
import org.exbin.framework.bined.action.ClipboardCodeActions;
import org.exbin.framework.bined.action.CodeAreaAction;
import org.exbin.framework.bined.action.CodeAreaFontAction;
import org.exbin.framework.bined.action.CodeTypeActions;
import org.exbin.framework.bined.action.EditSelectionAction;
import org.exbin.framework.bined.action.GoToPositionAction;
import org.exbin.framework.bined.action.HexCharactersCaseActions;
import org.exbin.framework.bined.action.PositionCodeTypeActions;
import org.exbin.framework.bined.action.PrintAction;
import org.exbin.framework.bined.action.PropertiesAction;
import org.exbin.framework.bined.action.ReloadFileAction;
import org.exbin.framework.bined.action.RowWrappingAction;
import org.exbin.framework.bined.action.ShowHeaderAction;
import org.exbin.framework.bined.action.ShowRowPositionAction;
import org.exbin.framework.bined.action.ShowUnprintablesActions;
import org.exbin.framework.bined.action.ViewModeHandlerActions;
import org.exbin.framework.bined.gui.BinEdComponentPanel;
import org.exbin.framework.bined.gui.BinaryStatusPanel;
import org.exbin.framework.bined.handler.CodeAreaPopupMenuHandler;
import org.exbin.framework.bined.preferences.BinaryEditorPreferences;
import org.exbin.framework.bined.preferences.EditorPreferences;
import org.exbin.framework.bined.service.impl.BinaryAppearanceServiceImpl;
import org.exbin.framework.editor.api.EditorModuleApi;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.api.EditorProviderVariant;
import org.exbin.framework.editor.api.MultiEditorProvider;
import org.exbin.framework.editor.text.EncodingsHandler;
import org.exbin.framework.editor.text.preferences.TextEncodingPreferences;
import org.exbin.framework.editor.text.service.TextEncodingService;
import org.exbin.framework.file.api.FileDependentAction;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.file.api.FileModuleApi;
import org.exbin.framework.file.api.FileOperations;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.options.api.OptionsModuleApi;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.ClipboardActionsApi;
import org.exbin.framework.utils.ComponentPopupEventDispatcher;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.xbup.plugin.XBModuleHandler;

@ParametersAreNonnullByDefault
public class BinedModule
implements XBApplicationModule {
    public static final String MODULE_ID = XBModuleRepositoryUtils.getModuleIdByApi(BinedModule.class);
    public static final String EDIT_FIND_MENU_GROUP_ID = MODULE_ID + ".editFindMenuGroup";
    public static final String EDIT_OPERATION_MENU_GROUP_ID = MODULE_ID + ".editOperationMenuGroup";
    public static final String VIEW_UNPRINTABLES_MENU_GROUP_ID = MODULE_ID + ".viewUnprintablesMenuGroup";
    public static final String BINARY_POPUP_MENU_ID = MODULE_ID + ".binaryPopupMenu";
    public static final String CODE_AREA_POPUP_MENU_ID = MODULE_ID + ".codeAreaPopupMenu";
    public static final String CODE_AREA_POPUP_VIEW_GROUP_ID = MODULE_ID + ".viewPopupMenuGroup";
    public static final String CODE_AREA_POPUP_EDIT_GROUP_ID = MODULE_ID + ".editPopupMenuGroup";
    public static final String CODE_AREA_POPUP_SELECTION_GROUP_ID = MODULE_ID + ".selectionPopupMenuGroup";
    public static final String CODE_AREA_POPUP_OPERATION_GROUP_ID = MODULE_ID + ".operationPopupMenuGroup";
    public static final String CODE_AREA_POPUP_FIND_GROUP_ID = MODULE_ID + ".findPopupMenuGroup";
    public static final String CODE_AREA_POPUP_TOOLS_GROUP_ID = MODULE_ID + ".toolsPopupMenuGroup";
    public static final String VIEW_MODE_SUBMENU_ID = MODULE_ID + ".viewModeSubMenu";
    public static final String CODE_TYPE_SUBMENU_ID = MODULE_ID + ".codeTypeSubMenu";
    public static final String POSITION_CODE_TYPE_SUBMENU_ID = MODULE_ID + ".positionCodeTypeSubMenu";
    public static final String HEX_CHARACTERS_CASE_SUBMENU_ID = MODULE_ID + ".hexCharactersCaseSubMenu";
    public static final String POSITION_CODE_TYPE_POPUP_SUBMENU_ID = MODULE_ID + ".positionCodeTypePopupSubMenu";
    public static final String SHOW_POPUP_SUBMENU_ID = MODULE_ID + ".showPopupSubMenu";
    private static final String BINED_TOOL_BAR_GROUP_ID = MODULE_ID + ".binedToolBarGroup";
    public static final String BINARY_STATUS_BAR_ID = "binaryStatusBar";
    private ResourceBundle resourceBundle = null;
    private XBApplication application;
    private EditorProvider editorProvider;
    private BinEdFileManager fileManager;
    private BinedOptionsManager binedOptionsManager;
    private ShowUnprintablesActions showUnprintablesActions;
    private CodeAreaFontAction codeAreaFontAction;
    private RowWrappingAction rowWrappingAction;
    private GoToPositionAction goToPositionAction;
    private EditSelectionAction editSelectionAction;
    private PropertiesAction propertiesAction;
    private ReloadFileAction reloadFileAction;
    private PrintAction printAction;
    private ViewModeHandlerActions viewModeActions;
    private ShowRowPositionAction showRowPositionAction;
    private ShowHeaderAction showHeaderAction;
    private CodeTypeActions codeTypeActions;
    private PositionCodeTypeActions positionCodeTypeActions;
    private HexCharactersCaseActions hexCharactersCaseActions;
    private ClipboardCodeActions clipboardCodeActions;
    private EncodingsHandler encodingsHandler;
    private PopupMenuVariant popupMenuVariant = PopupMenuVariant.NORMAL;
    private BasicCodeAreaZone popupMenuPositionZone = BasicCodeAreaZone.UNKNOWN;
    private final List<CodeAreaAction> codeAreaActions = new ArrayList<CodeAreaAction>();

    public void init(XBModuleHandler application) {
        this.application = (XBApplication)application;
    }

    public void initEditorProvider(EditorProviderVariant variant) {
        this.fileManager = new BinEdFileManager();
        this.fileManager.setApplication(this.application);
        switch (variant) {
            case SINGLE: {
                this.editorProvider = this.createSingleEditorProvider();
                break;
            }
            case MULTI: {
                this.editorProvider = this.createMultiEditorProvider();
                break;
            }
            default: {
                throw XBFrameworkUtils.getInvalidTypeException((Enum)variant);
            }
        }
        this.fileManager.setEditorProvider(this.editorProvider);
    }

    public void setEditorProvider(EditorProvider editorProvider) {
        this.editorProvider = editorProvider;
        this.fileManager.setEditorProvider(editorProvider);
    }

    public void unregisterModule(String moduleId) {
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = LanguageUtils.getResourceBundleByClass(BinedModule.class);
        }
        return this.resourceBundle;
    }

    @Nonnull
    private EditorProvider createSingleEditorProvider() {
        if (this.editorProvider == null) {
            BinEdFileHandler editorFile = new BinEdFileHandler();
            this.fileManager.initFileHandler(editorFile);
            EditorPreferences editorPreferences = new EditorPreferences(this.application.getAppPreferences());
            FileHandlingMode fileHandlingMode = editorPreferences.getFileHandlingMode();
            editorFile.setNewData(fileHandlingMode);
            this.editorProvider = new BinaryEditorProvider(this.application, editorFile);
            FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
            fileModule.setFileOperations((FileOperations)this.editorProvider);
            BinEdComponentPanel componentPanel = editorFile.getComponent();
            ExtCodeArea codeArea = editorFile.getComponent().getCodeArea();
            codeArea.addSelectionChangedListener(this::updateClipboardActionStatus);
            componentPanel.setPopupMenu(this.createPopupMenu(editorFile.getId(), codeArea));
        }
        return this.editorProvider;
    }

    @Nonnull
    private EditorProvider createMultiEditorProvider() {
        if (this.editorProvider == null) {
            this.editorProvider = new BinaryMultiEditorProvider(this.application);
            EditorPreferences editorPreferences = new EditorPreferences(this.application.getAppPreferences());
            FileHandlingMode fileHandlingMode = editorPreferences.getFileHandlingMode();
            ((BinaryMultiEditorProvider)this.editorProvider).setDefaultFileHandlingMode(fileHandlingMode);
            FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
            fileModule.setFileOperations((FileOperations)this.editorProvider);
            ((BinaryMultiEditorProvider)this.editorProvider).setCodeAreaPopupMenuHandler(this.createCodeAreaPopupMenuHandler(PopupMenuVariant.EDITOR));
            ((MultiEditorProvider)this.editorProvider).addActiveFileChangeListener(e -> {
                Optional activeFile = this.editorProvider.getActiveFile();
                ExtCodeArea codeArea = activeFile.isPresent() ? ((BinEdFileHandler)activeFile.get()).getCodeArea() : null;
                this.updateActionStatus((CodeAreaCore)codeArea);
            });
            ((BinaryMultiEditorProvider)this.editorProvider).setClipboardActionsUpdateListener(() -> this.updateClipboardActionStatus());
            fileModule.setFileOperations((FileOperations)this.editorProvider);
        }
        return this.editorProvider;
    }

    public void updateActionStatus(@Nullable CodeAreaCore codeArea) {
        FileDependentAction[] fileDepActions;
        EditorModuleApi editorModule = (EditorModuleApi)this.application.getModuleRepository().getModuleByInterface(EditorModuleApi.class);
        editorModule.updateActionStatus();
        for (FileDependentAction fileDepAction : fileDepActions = new FileDependentAction[]{this.codeAreaFontAction, this.propertiesAction, this.reloadFileAction}) {
            if (fileDepAction == null) continue;
            fileDepAction.updateForActiveFile();
        }
        CodeAreaAction[] binedCodeAreaActions = new CodeAreaAction[]{this.goToPositionAction, this.editSelectionAction, this.hexCharactersCaseActions, this.codeTypeActions, this.positionCodeTypeActions, this.rowWrappingAction, this.viewModeActions, this.showHeaderAction, this.showRowPositionAction, this.showUnprintablesActions, this.clipboardCodeActions, this.printAction};
        for (CodeAreaAction codeAreaAction : binedCodeAreaActions) {
            if (codeAreaAction == null) continue;
            codeAreaAction.updateForActiveCodeArea(codeArea);
        }
        for (CodeAreaAction codeAreaAction : this.codeAreaActions) {
            if (codeAreaAction == null) continue;
            codeAreaAction.updateForActiveCodeArea(codeArea);
        }
        this.fileManager.updateActionStatus(codeArea);
        FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
        fileModule.updateForFileOperations();
    }

    public void updateClipboardActionStatus() {
        if (this.clipboardCodeActions != null) {
            FileHandler fileHandler;
            Optional activeFile = this.editorProvider.getActiveFile();
            ExtCodeArea codeArea = null;
            if (activeFile.isPresent() && (fileHandler = (FileHandler)activeFile.get()) instanceof BinEdFileHandler) {
                codeArea = ((BinEdFileHandler)fileHandler).getCodeArea();
            }
            this.clipboardCodeActions.updateForActiveCodeArea((CodeAreaCore)codeArea);
        }
    }

    @Nonnull
    public EditorProvider getEditorProvider() {
        return Objects.requireNonNull(this.editorProvider, "Editor provider was not yet initialized");
    }

    private void ensureSetup() {
        if (this.editorProvider == null) {
            this.getEditorProvider();
        }
        if (this.resourceBundle == null) {
            this.getResourceBundle();
        }
    }

    @Nonnull
    public BinedOptionsManager getMainOptionsManager() {
        if (this.binedOptionsManager == null) {
            this.binedOptionsManager = new BinedOptionsManager();
            this.binedOptionsManager.setApplication(this.application);
            this.binedOptionsManager.setEditorProvider(this.editorProvider);
        }
        return this.binedOptionsManager;
    }

    public void registerStatusBar() {
        this.fileManager.registerStatusBar();
        this.fileManager.setStatusControlHandler(new BinaryStatusPanel.StatusControlHandler(){

            @Override
            public void changeEditOperation(EditOperation editOperation) {
                Optional activeFile = BinedModule.this.editorProvider.getActiveFile();
                if (activeFile.isPresent()) {
                    ((BinEdFileHandler)activeFile.get()).getCodeArea().setEditOperation(editOperation);
                }
            }

            @Override
            public void changeCursorPosition() {
                if (BinedModule.this.goToPositionAction != null) {
                    BinedModule.this.goToPositionAction.actionPerformed(null);
                }
            }

            @Override
            public void cycleEncodings() {
                if (BinedModule.this.encodingsHandler != null) {
                    BinedModule.this.encodingsHandler.cycleEncodings();
                }
            }

            @Override
            public void encodingsPopupEncodingsMenu(MouseEvent mouseEvent) {
                if (BinedModule.this.encodingsHandler != null) {
                    BinedModule.this.encodingsHandler.popupEncodingsMenu(mouseEvent);
                }
            }

            @Override
            public void changeMemoryMode(BinaryStatusApi.MemoryMode memoryMode) {
                Optional activeFile = BinedModule.this.editorProvider.getActiveFile();
                if (activeFile.isPresent()) {
                    FileHandlingMode newHandlingMode;
                    BinEdFileHandler fileHandler = (BinEdFileHandler)activeFile.get();
                    FileHandlingMode fileHandlingMode = fileHandler.getFileHandlingMode();
                    FileHandlingMode fileHandlingMode2 = newHandlingMode = memoryMode == BinaryStatusApi.MemoryMode.DELTA_MODE ? FileHandlingMode.DELTA : FileHandlingMode.MEMORY;
                    if (newHandlingMode != fileHandlingMode) {
                        BinaryEditorPreferences preferences = new BinaryEditorPreferences(BinedModule.this.application.getAppPreferences());
                        if (BinedModule.this.editorProvider.releaseFile((FileHandler)fileHandler)) {
                            fileHandler.switchFileHandlingMode(newHandlingMode);
                            preferences.getEditorPreferences().setFileHandlingMode(newHandlingMode);
                        }
                        ((BinEdEditorProvider)BinedModule.this.editorProvider).updateStatus();
                    }
                }
            }
        });
        if (this.encodingsHandler != null) {
            this.fileManager.updateTextEncodingStatus(this.encodingsHandler);
        }
    }

    public void registerEncodings() {
        this.getEncodingsHandler();
        this.encodingsHandler.rebuildEncodings();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.VIEW_MENU_ID, MODULE_ID, this.encodingsHandler.getToolsEncodingMenu(), new MenuPosition(PositionMode.TOP_LAST));
    }

    public void registerOptionsPanels() {
        BinaryAppearanceServiceImpl binaryAppearanceService = new BinaryAppearanceServiceImpl(this, this.editorProvider);
        this.getMainOptionsManager().registerOptionsPanels(this.getEncodingsHandler(), this.fileManager, binaryAppearanceService, this.getCodeTypeActions(), this.getShowUnprintablesActions(), this.getHexCharactersCaseActions(), this.getPositionCodeTypeActions(), this.getViewModeActions());
    }

    public void registerWordWrapping() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.VIEW_MENU_ID, MODULE_ID, (Action)this.getRowWrappingAction(), new MenuPosition(PositionMode.BOTTOM));
    }

    public void registerGoToPosition() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuGroup(FrameModuleApi.EDIT_MENU_ID, new MenuGroup(EDIT_OPERATION_MENU_GROUP_ID, new MenuPosition(PositionMode.MIDDLE), SeparationMode.AROUND));
        actionModule.registerMenuGroup(FrameModuleApi.EDIT_MENU_ID, new MenuGroup(EDIT_FIND_MENU_GROUP_ID, new MenuPosition(PositionMode.MIDDLE), SeparationMode.AROUND));
        actionModule.registerMenuItem(FrameModuleApi.EDIT_MENU_ID, MODULE_ID, (Action)this.getGoToPositionAction(), new MenuPosition(EDIT_FIND_MENU_GROUP_ID));
    }

    public void registerEditSelection() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.EDIT_MENU_ID, MODULE_ID, (Action)this.getEditSelectionAction(), new MenuPosition(PositionMode.BOTTOM));
    }

    @Nullable
    public BinaryStatusPanel getBinaryStatusPanel() {
        return this.fileManager.getBinaryStatusPanel();
    }

    @Nonnull
    private AbstractAction getShowHeaderAction() {
        if (this.showHeaderAction == null) {
            this.ensureSetup();
            this.showHeaderAction = new ShowHeaderAction();
            this.showHeaderAction.setup(this.application, this.resourceBundle);
            this.showHeaderAction.putValue("menu_creation", new ActionUtils.MenuCreation(){

                public boolean shouldCreate(String menuId) {
                    boolean inShowSubmenu = SHOW_POPUP_SUBMENU_ID.equals(menuId);
                    return BinedModule.this.popupMenuVariant == PopupMenuVariant.EDITOR && (inShowSubmenu && BinedModule.this.popupMenuPositionZone == BasicCodeAreaZone.CODE_AREA || !inShowSubmenu && BinedModule.this.popupMenuPositionZone != BasicCodeAreaZone.CODE_AREA);
                }

                public void onCreate(JMenuItem menuItem, String menuId) {
                    menuItem.setSelected(Objects.requireNonNull(BinedModule.this.getActiveCodeArea().getLayoutProfile()).isShowHeader());
                }
            });
        }
        return this.showHeaderAction;
    }

    @Nonnull
    private AbstractAction getShowRowPositionAction() {
        if (this.showRowPositionAction == null) {
            this.ensureSetup();
            this.showRowPositionAction = new ShowRowPositionAction();
            this.showRowPositionAction.setup(this.application, this.resourceBundle);
            this.showRowPositionAction.putValue("menu_creation", new ActionUtils.MenuCreation(){

                public boolean shouldCreate(String menuId) {
                    boolean inShowSubmenu = SHOW_POPUP_SUBMENU_ID.equals(menuId);
                    return BinedModule.this.popupMenuVariant == PopupMenuVariant.EDITOR && (inShowSubmenu && BinedModule.this.popupMenuPositionZone == BasicCodeAreaZone.CODE_AREA || !inShowSubmenu && BinedModule.this.popupMenuPositionZone != BasicCodeAreaZone.CODE_AREA);
                }

                public void onCreate(JMenuItem menuItem, String menuId) {
                    menuItem.setSelected(Objects.requireNonNull(BinedModule.this.getActiveCodeArea().getLayoutProfile()).isShowRowPosition());
                }
            });
        }
        return this.showRowPositionAction;
    }

    @Nonnull
    private Action getOptionsAction() {
        OptionsModuleApi optionsModule = (OptionsModuleApi)this.application.getModuleRepository().getModuleByInterface(OptionsModuleApi.class);
        Action optionsAction = optionsModule.getOptionsAction();
        optionsAction.putValue("menu_creation", new ActionUtils.MenuCreation(){

            public boolean shouldCreate(String menuId) {
                return BinedModule.this.popupMenuVariant == PopupMenuVariant.EDITOR;
            }

            public void onCreate(JMenuItem menuItem, String menuId) {
            }
        });
        return optionsAction;
    }

    @Nonnull
    public RowWrappingAction getRowWrappingAction() {
        if (this.rowWrappingAction == null) {
            this.ensureSetup();
            this.rowWrappingAction = new RowWrappingAction();
            this.rowWrappingAction.setup(this.application, this.resourceBundle);
        }
        return this.rowWrappingAction;
    }

    @Nonnull
    public ShowUnprintablesActions getShowUnprintablesActions() {
        if (this.showUnprintablesActions == null) {
            this.ensureSetup();
            this.showUnprintablesActions = new ShowUnprintablesActions();
            this.showUnprintablesActions.setup(this.application, this.resourceBundle);
        }
        return this.showUnprintablesActions;
    }

    @Nonnull
    public CodeAreaFontAction getCodeAreaFontAction() {
        if (this.codeAreaFontAction == null) {
            this.ensureSetup();
            this.codeAreaFontAction = new CodeAreaFontAction();
            this.codeAreaFontAction.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.codeAreaFontAction;
    }

    @Nonnull
    public GoToPositionAction getGoToPositionAction() {
        if (this.goToPositionAction == null) {
            this.ensureSetup();
            this.goToPositionAction = new GoToPositionAction();
            this.goToPositionAction.setup(this.application, this.resourceBundle);
            this.goToPositionAction.putValue("menu_creation", new ActionUtils.MenuCreation(){

                public boolean shouldCreate(String menuId) {
                    return BinedModule.this.popupMenuVariant != PopupMenuVariant.BASIC;
                }

                public void onCreate(JMenuItem menuItem, String menuId) {
                }
            });
        }
        return this.goToPositionAction;
    }

    @Nonnull
    public EditSelectionAction getEditSelectionAction() {
        if (this.editSelectionAction == null) {
            this.ensureSetup();
            this.editSelectionAction = new EditSelectionAction();
            this.editSelectionAction.setup(this.application, this.resourceBundle);
        }
        return this.editSelectionAction;
    }

    @Nonnull
    public PropertiesAction getPropertiesAction() {
        if (this.propertiesAction == null) {
            this.ensureSetup();
            this.propertiesAction = new PropertiesAction();
            this.propertiesAction.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.propertiesAction;
    }

    @Nonnull
    public EncodingsHandler getEncodingsHandler() {
        if (this.encodingsHandler == null) {
            this.ensureSetup();
            this.encodingsHandler = new EncodingsHandler();
            this.encodingsHandler.setApplication(this.application);
            this.encodingsHandler.setParentComponent((Component)this.editorProvider.getEditorComponent());
            this.fileManager.updateTextEncodingStatus(this.encodingsHandler);
            this.encodingsHandler.init();
            this.encodingsHandler.setEncodingChangeListener(new TextEncodingService.EncodingChangeListener(){

                public void encodingListChanged() {
                    BinedModule.this.encodingsHandler.rebuildEncodings();
                }

                public void selectedEncodingChanged() {
                    Optional activeFile = BinedModule.this.editorProvider.getActiveFile();
                    if (activeFile.isPresent()) {
                        ((BinEdFileHandler)activeFile.get()).setCharset(Charset.forName(BinedModule.this.encodingsHandler.getSelectedEncoding()));
                    }
                }
            });
        }
        return this.encodingsHandler;
    }

    @Nonnull
    private ReloadFileAction getReloadFileAction() {
        if (this.reloadFileAction == null) {
            this.ensureSetup();
            this.reloadFileAction = new ReloadFileAction();
            this.reloadFileAction.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.reloadFileAction;
    }

    @Nonnull
    public PrintAction getPrintAction() {
        if (this.printAction == null) {
            this.ensureSetup();
            this.printAction = new PrintAction();
            this.printAction.setup(this.application, this.resourceBundle);
        }
        return this.printAction;
    }

    @Nonnull
    public ViewModeHandlerActions getViewModeActions() {
        if (this.viewModeActions == null) {
            this.ensureSetup();
            this.viewModeActions = new ViewModeHandlerActions();
            this.viewModeActions.setup(this.application, this.resourceBundle);
        }
        return this.viewModeActions;
    }

    @Nonnull
    public CodeTypeActions getCodeTypeActions() {
        if (this.codeTypeActions == null) {
            this.ensureSetup();
            this.codeTypeActions = new CodeTypeActions();
            this.codeTypeActions.setup(this.application, this.resourceBundle);
        }
        return this.codeTypeActions;
    }

    @Nonnull
    public PositionCodeTypeActions getPositionCodeTypeActions() {
        if (this.positionCodeTypeActions == null) {
            this.ensureSetup();
            this.positionCodeTypeActions = new PositionCodeTypeActions();
            this.positionCodeTypeActions.setup(this.application, this.resourceBundle);
        }
        return this.positionCodeTypeActions;
    }

    @Nonnull
    public HexCharactersCaseActions getHexCharactersCaseActions() {
        if (this.hexCharactersCaseActions == null) {
            this.ensureSetup();
            this.hexCharactersCaseActions = new HexCharactersCaseActions();
            this.hexCharactersCaseActions.setup(this.application, this.resourceBundle);
        }
        return this.hexCharactersCaseActions;
    }

    @Nonnull
    public ClipboardCodeActions getClipboardCodeActions() {
        if (this.clipboardCodeActions == null) {
            this.ensureSetup();
            this.clipboardCodeActions = new ClipboardCodeActions();
            this.clipboardCodeActions.setup(this.application, this.resourceBundle);
        }
        return this.clipboardCodeActions;
    }

    public void registerCodeTypeToolBarActions() {
        this.getCodeTypeActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerToolBarGroup(FrameModuleApi.MAIN_TOOL_BAR_ID, new ToolBarGroup(BINED_TOOL_BAR_GROUP_ID, new ToolBarPosition(PositionMode.MIDDLE), SeparationMode.ABOVE));
        actionModule.registerToolBarItem(FrameModuleApi.MAIN_TOOL_BAR_ID, MODULE_ID, this.codeTypeActions.getCycleCodeTypesAction(), new ToolBarPosition(BINED_TOOL_BAR_GROUP_ID));
    }

    public void registerShowUnprintablesToolBarActions() {
        this.getShowUnprintablesActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerToolBarGroup(FrameModuleApi.MAIN_TOOL_BAR_ID, new ToolBarGroup(BINED_TOOL_BAR_GROUP_ID, new ToolBarPosition(PositionMode.MIDDLE), SeparationMode.NONE));
        actionModule.registerToolBarItem(FrameModuleApi.MAIN_TOOL_BAR_ID, MODULE_ID, this.showUnprintablesActions.getViewUnprintablesToolbarAction(), new ToolBarPosition(BINED_TOOL_BAR_GROUP_ID));
    }

    public void registerViewUnprintablesMenuActions() {
        this.getShowUnprintablesActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuGroup(FrameModuleApi.VIEW_MENU_ID, new MenuGroup(VIEW_UNPRINTABLES_MENU_GROUP_ID, new MenuPosition(PositionMode.BOTTOM), SeparationMode.NONE));
        actionModule.registerMenuItem(FrameModuleApi.VIEW_MENU_ID, MODULE_ID, this.showUnprintablesActions.getViewUnprintablesAction(), new MenuPosition(VIEW_UNPRINTABLES_MENU_GROUP_ID));
    }

    public void registerToolsOptionsMenuActions() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.VIEW_MENU_ID, MODULE_ID, (Action)this.getCodeAreaFontAction(), new MenuPosition(PositionMode.BOTTOM_LAST));
    }

    public void registerClipboardCodeActions() {
        this.getClipboardCodeActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.EDIT_MENU_ID, MODULE_ID, this.clipboardCodeActions.getCopyAsCodeAction(), new MenuPosition(NextToMode.AFTER, (String)actionModule.getClipboardActions().getCopyAction().getValue("Name")));
        actionModule.registerMenuItem(FrameModuleApi.EDIT_MENU_ID, MODULE_ID, this.clipboardCodeActions.getPasteFromCodeAction(), new MenuPosition(NextToMode.AFTER, (String)actionModule.getClipboardActions().getPasteAction().getValue("Name")));
    }

    public void registerPropertiesMenu() {
        this.getPropertiesAction();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.FILE_MENU_ID, MODULE_ID, (Action)this.getPropertiesAction(), new MenuPosition(PositionMode.BOTTOM));
    }

    public void registerReloadFileMenu() {
        this.getReloadFileAction();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.FILE_MENU_ID, MODULE_ID, (Action)this.getReloadFileAction(), new MenuPosition(PositionMode.BOTTOM));
    }

    public void registerPrintMenu() {
        this.getPrintAction();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.FILE_MENU_ID, MODULE_ID, (Action)this.getPrintAction(), new MenuPosition(PositionMode.BOTTOM));
    }

    public void registerViewModeMenu() {
        this.getViewModeActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        AbstractAction viewSubMenuAction = new AbstractAction(this.resourceBundle.getString("viewModeSubMenu.text")){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        viewSubMenuAction.putValue("ShortDescription", this.resourceBundle.getString("viewModeSubMenu.shortDescription"));
        actionModule.registerMenuItem(FrameModuleApi.VIEW_MENU_ID, MODULE_ID, VIEW_MODE_SUBMENU_ID, (Action)viewSubMenuAction, new MenuPosition(PositionMode.BOTTOM));
        actionModule.registerMenu(VIEW_MODE_SUBMENU_ID, MODULE_ID);
        actionModule.registerMenuItem(VIEW_MODE_SUBMENU_ID, MODULE_ID, this.viewModeActions.getDualModeAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(VIEW_MODE_SUBMENU_ID, MODULE_ID, this.viewModeActions.getCodeMatrixModeAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(VIEW_MODE_SUBMENU_ID, MODULE_ID, this.viewModeActions.getTextPreviewModeAction(), new MenuPosition(PositionMode.TOP));
    }

    public void registerLayoutMenu() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.VIEW_MENU_ID, MODULE_ID, (Action)this.getShowHeaderAction(), new MenuPosition(PositionMode.BOTTOM));
        actionModule.registerMenuItem(FrameModuleApi.VIEW_MENU_ID, MODULE_ID, (Action)this.getShowRowPositionAction(), new MenuPosition(PositionMode.BOTTOM));
    }

    public void registerCodeTypeMenu() {
        this.getCodeTypeActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        AbstractAction codeTypeSubMenuAction = new AbstractAction(this.resourceBundle.getString("codeTypeSubMenu.text")){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        codeTypeSubMenuAction.putValue("ShortDescription", this.resourceBundle.getString("codeTypeSubMenu.shortDescription"));
        actionModule.registerMenuItem(FrameModuleApi.VIEW_MENU_ID, MODULE_ID, CODE_TYPE_SUBMENU_ID, (Action)codeTypeSubMenuAction, new MenuPosition(PositionMode.BOTTOM));
        actionModule.registerMenu(CODE_TYPE_SUBMENU_ID, MODULE_ID);
        actionModule.registerMenuItem(CODE_TYPE_SUBMENU_ID, MODULE_ID, this.codeTypeActions.getBinaryCodeTypeAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(CODE_TYPE_SUBMENU_ID, MODULE_ID, this.codeTypeActions.getOctalCodeTypeAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(CODE_TYPE_SUBMENU_ID, MODULE_ID, this.codeTypeActions.getDecimalCodeTypeAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(CODE_TYPE_SUBMENU_ID, MODULE_ID, this.codeTypeActions.getHexadecimalCodeTypeAction(), new MenuPosition(PositionMode.TOP));
    }

    public void registerPositionCodeTypeMenu() {
        this.getPositionCodeTypeActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        AbstractAction positionCodeTypeSubMenuAction = new AbstractAction(this.resourceBundle.getString("positionCodeTypeSubMenu.text")){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        positionCodeTypeSubMenuAction.putValue("ShortDescription", this.resourceBundle.getString("positionCodeTypeSubMenu.shortDescription"));
        actionModule.registerMenuItem(FrameModuleApi.VIEW_MENU_ID, MODULE_ID, POSITION_CODE_TYPE_SUBMENU_ID, (Action)positionCodeTypeSubMenuAction, new MenuPosition(PositionMode.BOTTOM));
        actionModule.registerMenu(POSITION_CODE_TYPE_SUBMENU_ID, MODULE_ID);
        actionModule.registerMenuItem(POSITION_CODE_TYPE_SUBMENU_ID, MODULE_ID, this.positionCodeTypeActions.getOctalCodeTypeAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(POSITION_CODE_TYPE_SUBMENU_ID, MODULE_ID, this.positionCodeTypeActions.getDecimalCodeTypeAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(POSITION_CODE_TYPE_SUBMENU_ID, MODULE_ID, this.positionCodeTypeActions.getHexadecimalCodeTypeAction(), new MenuPosition(PositionMode.TOP));
    }

    public void registerHexCharactersCaseHandlerMenu() {
        this.getHexCharactersCaseActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        AbstractAction hexCharsCaseSubMenuAction = new AbstractAction(this.resourceBundle.getString("hexCharsCaseSubMenu.text")){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        hexCharsCaseSubMenuAction.putValue("ShortDescription", this.resourceBundle.getString("hexCharsCaseSubMenu.shortDescription"));
        actionModule.registerMenuItem(FrameModuleApi.VIEW_MENU_ID, MODULE_ID, HEX_CHARACTERS_CASE_SUBMENU_ID, (Action)hexCharsCaseSubMenuAction, new MenuPosition(PositionMode.BOTTOM));
        actionModule.registerMenu(HEX_CHARACTERS_CASE_SUBMENU_ID, MODULE_ID);
        actionModule.registerMenuItem(HEX_CHARACTERS_CASE_SUBMENU_ID, MODULE_ID, this.hexCharactersCaseActions.getUpperHexCharsAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(HEX_CHARACTERS_CASE_SUBMENU_ID, MODULE_ID, this.hexCharactersCaseActions.getLowerHexCharsAction(), new MenuPosition(PositionMode.TOP));
    }

    public void registerEditSelectionAction() {
        this.getEditSelectionAction();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.EDIT_MENU_ID, MODULE_ID, (Action)this.getEditSelectionAction(), new MenuPosition(ActionModuleApi.CLIPBOARD_ACTIONS_MENU_GROUP_ID));
    }

    public void registerCodeAreaPopupMenu() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        ClipboardActionsApi clipboardActions = actionModule.getClipboardActions();
        actionModule.registerMenu(CODE_AREA_POPUP_MENU_ID, MODULE_ID);
        actionModule.registerMenuGroup(CODE_AREA_POPUP_MENU_ID, new MenuGroup(CODE_AREA_POPUP_VIEW_GROUP_ID, new MenuPosition(PositionMode.TOP), SeparationMode.AROUND));
        actionModule.registerMenuGroup(CODE_AREA_POPUP_MENU_ID, new MenuGroup(CODE_AREA_POPUP_EDIT_GROUP_ID, new MenuPosition(PositionMode.MIDDLE), SeparationMode.AROUND));
        actionModule.registerMenuGroup(CODE_AREA_POPUP_MENU_ID, new MenuGroup(CODE_AREA_POPUP_SELECTION_GROUP_ID, new MenuPosition(PositionMode.MIDDLE), SeparationMode.AROUND));
        actionModule.registerMenuGroup(CODE_AREA_POPUP_MENU_ID, new MenuGroup(CODE_AREA_POPUP_OPERATION_GROUP_ID, new MenuPosition(PositionMode.MIDDLE), SeparationMode.AROUND));
        actionModule.registerMenuGroup(CODE_AREA_POPUP_MENU_ID, new MenuGroup(CODE_AREA_POPUP_FIND_GROUP_ID, new MenuPosition(PositionMode.MIDDLE), SeparationMode.AROUND));
        actionModule.registerMenuGroup(CODE_AREA_POPUP_MENU_ID, new MenuGroup(CODE_AREA_POPUP_TOOLS_GROUP_ID, new MenuPosition(PositionMode.BOTTOM), SeparationMode.AROUND));
        actionModule.registerMenuItem(CODE_AREA_POPUP_MENU_ID, MODULE_ID, (Action)this.getShowHeaderAction(), new MenuPosition(CODE_AREA_POPUP_VIEW_GROUP_ID));
        actionModule.registerMenuItem(CODE_AREA_POPUP_MENU_ID, MODULE_ID, (Action)this.getShowRowPositionAction(), new MenuPosition(CODE_AREA_POPUP_VIEW_GROUP_ID));
        actionModule.registerMenu(POSITION_CODE_TYPE_POPUP_SUBMENU_ID, MODULE_ID);
        AbstractAction positionCodeTypeSubMenuAction = new AbstractAction(this.resourceBundle.getString("positionCodeTypeSubMenu.text")){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        positionCodeTypeSubMenuAction.putValue("ShortDescription", this.resourceBundle.getString("positionCodeTypeSubMenu.shortDescription"));
        actionModule.registerMenuItem(CODE_AREA_POPUP_MENU_ID, MODULE_ID, POSITION_CODE_TYPE_POPUP_SUBMENU_ID, (Action)positionCodeTypeSubMenuAction, new MenuPosition(CODE_AREA_POPUP_VIEW_GROUP_ID));
        actionModule.registerMenuItem(POSITION_CODE_TYPE_POPUP_SUBMENU_ID, MODULE_ID, this.getOctalPositionTypeAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(POSITION_CODE_TYPE_POPUP_SUBMENU_ID, MODULE_ID, this.getDecimalPositionTypeAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(POSITION_CODE_TYPE_POPUP_SUBMENU_ID, MODULE_ID, this.getHexadecimalPositionTypeAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(CODE_AREA_POPUP_MENU_ID, MODULE_ID, clipboardActions.getCutAction(), new MenuPosition(CODE_AREA_POPUP_EDIT_GROUP_ID));
        actionModule.registerMenuItem(CODE_AREA_POPUP_MENU_ID, MODULE_ID, clipboardActions.getCopyAction(), new MenuPosition(CODE_AREA_POPUP_EDIT_GROUP_ID));
        actionModule.registerMenuItem(CODE_AREA_POPUP_MENU_ID, MODULE_ID, this.getClipboardCodeActions().getCopyAsCodeAction(), new MenuPosition(CODE_AREA_POPUP_EDIT_GROUP_ID));
        actionModule.registerMenuItem(CODE_AREA_POPUP_MENU_ID, MODULE_ID, clipboardActions.getPasteAction(), new MenuPosition(CODE_AREA_POPUP_EDIT_GROUP_ID));
        actionModule.registerMenuItem(CODE_AREA_POPUP_MENU_ID, MODULE_ID, this.getClipboardCodeActions().getPasteFromCodeAction(), new MenuPosition(CODE_AREA_POPUP_EDIT_GROUP_ID));
        actionModule.registerMenuItem(CODE_AREA_POPUP_MENU_ID, MODULE_ID, clipboardActions.getDeleteAction(), new MenuPosition(CODE_AREA_POPUP_EDIT_GROUP_ID));
        actionModule.registerMenuItem(CODE_AREA_POPUP_MENU_ID, MODULE_ID, clipboardActions.getSelectAllAction(), new MenuPosition(CODE_AREA_POPUP_SELECTION_GROUP_ID));
        actionModule.registerMenuItem(CODE_AREA_POPUP_MENU_ID, MODULE_ID, (Action)this.getEditSelectionAction(), new MenuPosition(CODE_AREA_POPUP_SELECTION_GROUP_ID));
        actionModule.registerMenuItem(CODE_AREA_POPUP_MENU_ID, MODULE_ID, (Action)this.getGoToPositionAction(), new MenuPosition(CODE_AREA_POPUP_FIND_GROUP_ID));
        actionModule.registerMenu(SHOW_POPUP_SUBMENU_ID, MODULE_ID);
        AbstractAction popupShowSubMenuAction = new AbstractAction(this.resourceBundle.getString("popupShowSubMenu.text")){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        popupShowSubMenuAction.putValue("ShortDescription", this.resourceBundle.getString("popupShowSubMenu.shortDescription"));
        actionModule.registerMenuItem(CODE_AREA_POPUP_MENU_ID, MODULE_ID, SHOW_POPUP_SUBMENU_ID, (Action)popupShowSubMenuAction, new MenuPosition(CODE_AREA_POPUP_VIEW_GROUP_ID));
        actionModule.registerMenuItem(SHOW_POPUP_SUBMENU_ID, MODULE_ID, (Action)this.getShowHeaderAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(SHOW_POPUP_SUBMENU_ID, MODULE_ID, (Action)this.getShowRowPositionAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(CODE_AREA_POPUP_MENU_ID, MODULE_ID, this.getOptionsAction(), new MenuPosition(CODE_AREA_POPUP_TOOLS_GROUP_ID));
    }

    @Nonnull
    private Action getOctalPositionTypeAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BinedModule.this.getActiveCodeArea().setPositionCodeType(PositionCodeType.OCTAL);
            }
        };
        ActionUtils.setupAction((Action)action, (ResourceBundle)this.resourceBundle, (String)"octalPositionCodeTypeAction");
        action.putValue("type", ActionUtils.ActionType.RADIO);
        action.putValue("menu_creation", new ActionUtils.MenuCreation(){

            public boolean shouldCreate(String menuId) {
                return BinedModule.this.popupMenuVariant == PopupMenuVariant.EDITOR && (BinedModule.this.popupMenuPositionZone == BasicCodeAreaZone.TOP_LEFT_CORNER || BinedModule.this.popupMenuPositionZone == BasicCodeAreaZone.HEADER || BinedModule.this.popupMenuPositionZone == BasicCodeAreaZone.ROW_POSITIONS);
            }

            public void onCreate(JMenuItem menuItem, String menuId) {
                menuItem.setSelected(BinedModule.this.getActiveCodeArea().getPositionCodeType() == PositionCodeType.OCTAL);
            }
        });
        return action;
    }

    @Nonnull
    private Action getDecimalPositionTypeAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BinedModule.this.getActiveCodeArea().setPositionCodeType(PositionCodeType.DECIMAL);
            }
        };
        ActionUtils.setupAction((Action)action, (ResourceBundle)this.resourceBundle, (String)"decimalPositionCodeTypeAction");
        action.putValue("type", ActionUtils.ActionType.RADIO);
        action.putValue("menu_creation", new ActionUtils.MenuCreation(){

            public boolean shouldCreate(String menuId) {
                return BinedModule.this.popupMenuVariant == PopupMenuVariant.EDITOR && (BinedModule.this.popupMenuPositionZone == BasicCodeAreaZone.TOP_LEFT_CORNER || BinedModule.this.popupMenuPositionZone == BasicCodeAreaZone.HEADER || BinedModule.this.popupMenuPositionZone == BasicCodeAreaZone.ROW_POSITIONS);
            }

            public void onCreate(JMenuItem menuItem, String menuId) {
                menuItem.setSelected(BinedModule.this.getActiveCodeArea().getPositionCodeType() == PositionCodeType.DECIMAL);
            }
        });
        return action;
    }

    @Nonnull
    private Action getHexadecimalPositionTypeAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BinedModule.this.getActiveCodeArea().setPositionCodeType(PositionCodeType.HEXADECIMAL);
            }
        };
        ActionUtils.setupAction((Action)action, (ResourceBundle)this.resourceBundle, (String)"hexadecimalPositionCodeTypeAction");
        action.putValue("type", ActionUtils.ActionType.RADIO);
        action.putValue("menu_creation", new ActionUtils.MenuCreation(){

            public boolean shouldCreate(String menuId) {
                return BinedModule.this.popupMenuVariant == PopupMenuVariant.EDITOR && (BinedModule.this.popupMenuPositionZone == BasicCodeAreaZone.TOP_LEFT_CORNER || BinedModule.this.popupMenuPositionZone == BasicCodeAreaZone.HEADER || BinedModule.this.popupMenuPositionZone == BasicCodeAreaZone.ROW_POSITIONS);
            }

            public void onCreate(JMenuItem menuItem, String menuId) {
                menuItem.setSelected(BinedModule.this.getActiveCodeArea().getPositionCodeType() == PositionCodeType.HEXADECIMAL);
            }
        });
        return action;
    }

    public void start() {
        if (this.editorProvider instanceof MultiEditorProvider) {
            this.editorProvider.newFile();
        }
    }

    public void startWithFile(String filePath) {
        FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
        URI uri = new File(filePath).toURI();
        fileModule.loadFromFile(uri);
    }

    @Nonnull
    public BinEdFileManager getFileManager() {
        return this.fileManager;
    }

    @Nonnull
    public String getNewFileTitlePrefix() {
        return this.resourceBundle.getString("newFileTitlePrefix");
    }

    @Nonnull
    public ExtCodeArea getActiveCodeArea() {
        Optional activeFile = this.editorProvider.getActiveFile();
        if (activeFile.isPresent()) {
            return ((BinEdFileHandler)activeFile.get()).getComponent().getCodeArea();
        }
        throw new IllegalStateException("No active file");
    }

    @Nonnull
    private JPopupMenu createPopupMenu(int postfix, final ExtCodeArea codeArea) {
        final String popupMenuId = BINARY_POPUP_MENU_ID + "." + postfix;
        JPopupMenu popupMenu = new JPopupMenu(){

            @Override
            public void show(Component invoker, int x, int y) {
                int clickedX = x;
                int clickedY = y;
                if (invoker instanceof JViewport) {
                    clickedX += ((JViewport)invoker).getParent().getX();
                    clickedY += ((JViewport)invoker).getParent().getY();
                }
                final CodeAreaPopupMenuHandler codeAreaPopupMenuHandler = BinedModule.this.createCodeAreaPopupMenuHandler(PopupMenuVariant.EDITOR);
                JPopupMenu popupMenu = codeAreaPopupMenuHandler.createPopupMenu(codeArea, popupMenuId, clickedX, clickedY);
                popupMenu.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        codeAreaPopupMenuHandler.dropPopupMenu(popupMenuId);
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent e) {
                    }
                });
                popupMenu.show(invoker, x, y);
            }
        };
        return popupMenu;
    }

    @Nonnull
    private JPopupMenu createCodeAreaPopupMenu(ExtCodeArea codeArea, String menuPostfix, PopupMenuVariant variant, int x, int y) {
        this.getClipboardCodeActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenu(CODE_AREA_POPUP_MENU_ID + menuPostfix, MODULE_ID);
        this.popupMenuVariant = variant;
        this.popupMenuPositionZone = codeArea.getPainter().getPositionZone(x, y);
        JPopupMenu popupMenu = new JPopupMenu();
        actionModule.buildMenu(popupMenu, CODE_AREA_POPUP_MENU_ID);
        return popupMenu;
    }

    @Nonnull
    public PopupMenuVariant getPopupMenuVariant() {
        return this.popupMenuVariant;
    }

    @Nonnull
    public BasicCodeAreaZone getPopupMenuPositionZone() {
        return this.popupMenuPositionZone;
    }

    @Nonnull
    public JPopupMenu createBinEdComponentPopupMenu(CodeAreaPopupMenuHandler codeAreaPopupMenuHandler, BinEdComponentPanel binaryPanel, int clickedX, int clickedY) {
        return codeAreaPopupMenuHandler.createPopupMenu(binaryPanel.getCodeArea(), "", clickedX, clickedY);
    }

    public void dropBinEdComponentPopupMenu() {
        this.dropCodeAreaPopupMenu("");
    }

    private void dropCodeAreaPopupMenu(String menuPostfix) {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.unregisterMenu(CODE_AREA_POPUP_MENU_ID + menuPostfix);
    }

    public void loadFromPreferences(Preferences preferences) {
        this.encodingsHandler.loadFromPreferences(new TextEncodingPreferences(preferences));
        this.fileManager.loadFromPreferences(preferences);
    }

    @Nonnull
    public CodeAreaPopupMenuHandler createCodeAreaPopupMenuHandler(final PopupMenuVariant variant) {
        return new CodeAreaPopupMenuHandler(){

            @Override
            public JPopupMenu createPopupMenu(ExtCodeArea codeArea, String menuPostfix, int x, int y) {
                return BinedModule.this.createCodeAreaPopupMenu(codeArea, menuPostfix, variant, x, y);
            }

            @Override
            public void dropPopupMenu(String menuPostfix) {
                BinedModule.this.dropCodeAreaPopupMenu(menuPostfix);
            }
        };
    }

    public void registerCodeAreaPopupEventDispatcher() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.addComponentPopupEventDispatcher(new ComponentPopupEventDispatcher(){
            private static final String DEFAULT_MENU_POSTFIX = ".default";
            private JPopupMenu popupMenu = null;

            public boolean dispatchMouseEvent(MouseEvent mouseEvent) {
                Component component = this.getSource(mouseEvent);
                if (component instanceof ExtCodeArea && ((ExtCodeArea)component).getComponentPopupMenu() == null) {
                    int y;
                    int x;
                    Point point;
                    CodeAreaPopupMenuHandler handler = BinedModule.this.createCodeAreaPopupMenuHandler(PopupMenuVariant.NORMAL);
                    if (this.popupMenu != null) {
                        handler.dropPopupMenu(DEFAULT_MENU_POSTFIX);
                    }
                    if ((point = component.getMousePosition()) != null) {
                        x = (int)point.getX();
                        y = (int)point.getY();
                    } else {
                        x = mouseEvent.getX();
                        y = mouseEvent.getY();
                    }
                    this.popupMenu = handler.createPopupMenu((ExtCodeArea)component, DEFAULT_MENU_POSTFIX, x, y);
                    if (point != null) {
                        this.popupMenu.show(component, x, y);
                    } else {
                        this.popupMenu.show(mouseEvent.getComponent(), x, y);
                    }
                    return true;
                }
                return false;
            }

            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (component instanceof ExtCodeArea && ((ExtCodeArea)component).getComponentPopupMenu() == null) {
                    CodeAreaPopupMenuHandler handler = BinedModule.this.createCodeAreaPopupMenuHandler(PopupMenuVariant.NORMAL);
                    if (this.popupMenu != null) {
                        handler.dropPopupMenu(DEFAULT_MENU_POSTFIX);
                    }
                    Point point = new Point(component.getWidth() / 2, component.getHeight() / 2);
                    int x = (int)point.getX();
                    int y = (int)point.getY();
                    this.popupMenu = handler.createPopupMenu((ExtCodeArea)component, DEFAULT_MENU_POSTFIX, x, y);
                    this.popupMenu.show(component, x, y);
                    return true;
                }
                return false;
            }

            @Nullable
            private Component getSource(MouseEvent e) {
                return SwingUtilities.getDeepestComponentAt(e.getComponent(), e.getX(), e.getY());
            }
        });
    }

    public void registerCodeAreaCommandHandlerProvider(CodeAreaCommandHandlerProvider commandHandlerProvider) {
        this.fileManager.setCommandHandlerProvider(commandHandlerProvider);
    }

    public void addCodeAreaAction(CodeAreaAction codeAreaAction) {
        this.codeAreaActions.add(codeAreaAction);
    }

    public void removeCodeAreaAction(CodeAreaAction codeAreaAction) {
        this.codeAreaActions.remove(codeAreaAction);
    }

    public static enum PopupMenuVariant {
        BASIC,
        NORMAL,
        EDITOR;

    }
}

