/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.exbin.auxiliary.binary_data.delta.DeltaDocument;
import org.exbin.bined.CodeAreaCaretPosition;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.EditMode;
import org.exbin.bined.SelectionRange;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.framework.action.api.ActionModuleApi;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.bined.BinEdEditorProvider;
import org.exbin.framework.bined.BinEdFileHandler;
import org.exbin.framework.bined.BinEdFileManager;
import org.exbin.framework.bined.BinaryStatusApi;
import org.exbin.framework.bined.BinedModule;
import org.exbin.framework.bined.FileHandlingMode;
import org.exbin.framework.bined.handler.CodeAreaPopupMenuHandler;
import org.exbin.framework.editor.MultiEditorUndoHandler;
import org.exbin.framework.editor.action.CloseAllFileAction;
import org.exbin.framework.editor.action.CloseFileAction;
import org.exbin.framework.editor.action.CloseOtherFileAction;
import org.exbin.framework.editor.action.EditorActions;
import org.exbin.framework.editor.api.EditorModuleApi;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.api.MultiEditorPopupMenu;
import org.exbin.framework.editor.api.MultiEditorProvider;
import org.exbin.framework.editor.gui.MultiEditorPanel;
import org.exbin.framework.editor.text.TextEncodingStatusApi;
import org.exbin.framework.file.api.AllFileTypes;
import org.exbin.framework.file.api.FileActionsApi;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.file.api.FileModuleApi;
import org.exbin.framework.file.api.FileType;
import org.exbin.framework.file.api.FileTypes;
import org.exbin.framework.file.api.UsedDirectoryApi;
import org.exbin.framework.operation.undo.api.UndoFileHandler;
import org.exbin.framework.utils.ClipboardActionsUpdateListener;
import org.exbin.framework.utils.ClipboardActionsUpdater;
import org.exbin.xbup.operation.Command;
import org.exbin.xbup.operation.undo.XBUndoHandler;
import org.exbin.xbup.operation.undo.XBUndoUpdateListener;

@ParametersAreNonnullByDefault
public class BinaryMultiEditorProvider
implements MultiEditorProvider,
BinEdEditorProvider,
UndoFileHandler {
    private final XBApplication application;
    private FileTypes fileTypes;
    private final MultiEditorPanel multiEditorPanel = new MultiEditorPanel();
    private int lastIndex = 0;
    private int lastNewFileIndex = 0;
    private final Map<Integer, Integer> newFilesMap = new HashMap<Integer, Integer>();
    private FileHandlingMode defaultFileHandlingMode = FileHandlingMode.MEMORY;
    private final List<MultiEditorProvider.ActiveFileChangeListener> activeFileChangeListeners = new ArrayList<MultiEditorProvider.ActiveFileChangeListener>();
    private CodeAreaPopupMenuHandler codeAreaPopupMenuHandler;
    private JPopupMenu codeAreaPopupMenu;
    private ClipboardActionsUpdateListener clipboardActionsUpdateListener;
    private EditorProvider.EditorModificationListener editorModificationListener;
    private BinaryStatusApi binaryStatus;
    private TextEncodingStatusApi textEncodingStatusApi;
    private MultiEditorUndoHandler undoHandler = new MultiEditorUndoHandler();
    private FileHandler activeFileCache = null;
    @Nullable
    private File lastUsedDirectory;

    public BinaryMultiEditorProvider(XBApplication application) {
        this.application = application;
        this.init();
    }

    private void init() {
        this.multiEditorPanel.setController(new MultiEditorPanel.Controller(){

            public void activeIndexChanged(int index) {
                BinaryMultiEditorProvider.this.activeFileChanged();
            }

            public void showPopupMenu(int index, Component component, int positionX, int positionY) {
                if (index < 0) {
                    return;
                }
                FileHandler fileHandler = BinaryMultiEditorProvider.this.multiEditorPanel.getFileHandler(index);
                EditorModuleApi editorModule = (EditorModuleApi)BinaryMultiEditorProvider.this.application.getModuleRepository().getModuleByInterface(EditorModuleApi.class);
                EditorPopupMenu fileTabPopupMenu = new EditorPopupMenu(fileHandler);
                CloseFileAction closeFileAction = (CloseFileAction)editorModule.getCloseFileAction();
                JMenuItem closeMenuItem = new JMenuItem((Action)closeFileAction);
                fileTabPopupMenu.add(closeMenuItem);
                CloseAllFileAction closeAllFileAction = (CloseAllFileAction)editorModule.getCloseAllFileAction();
                JMenuItem closeAllMenuItem = new JMenuItem((Action)closeAllFileAction);
                fileTabPopupMenu.add(closeAllMenuItem);
                CloseOtherFileAction closeOtherFileAction = (CloseOtherFileAction)editorModule.getCloseOtherFileAction();
                JMenuItem closeOtherMenuItem = new JMenuItem((Action)closeOtherFileAction);
                fileTabPopupMenu.add(closeOtherMenuItem);
                fileTabPopupMenu.show(component, positionX, positionY);
            }
        });
        this.fileTypes = new AllFileTypes();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.addFlavorListener(e -> this.updateClipboardActionsStatus());
        this.multiEditorPanel.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent event) {
                try {
                    event.acceptDrop(1);
                    Object transferData = event.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    List droppedFiles = (List)transferData;
                    for (Object file : droppedFiles) {
                        BinaryMultiEditorProvider.this.openFile(((File)file).toURI(), null);
                    }
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    Logger.getLogger(BinaryMultiEditorProvider.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    @Nonnull
    public Optional<FileHandler> getActiveFile() {
        return Optional.ofNullable(this.activeFileCache);
    }

    @Nonnull
    public JComponent getEditorComponent() {
        return this.multiEditorPanel;
    }

    public void setModificationListener(EditorProvider.EditorModificationListener editorModificationListener) {
        this.editorModificationListener = editorModificationListener;
    }

    public void setDefaultFileHandlingMode(FileHandlingMode defaultFileHandlingMode) {
        this.defaultFileHandlingMode = defaultFileHandlingMode;
    }

    @Nonnull
    public String getWindowTitle(String parentTitle) {
        Optional activeFile = this.multiEditorPanel.getActiveFile();
        return activeFile.isPresent() ? ((BinEdFileHandler)activeFile.get()).getWindowTitle(parentTitle) : "";
    }

    public void newFile() {
        int fileIndex = ++this.lastIndex;
        this.newFilesMap.put(fileIndex, ++this.lastNewFileIndex);
        BinEdFileHandler newFile = this.createFileHandler(fileIndex);
        newFile.clearFile();
        BinedModule binedModule = (BinedModule)this.application.getModuleRepository().getModuleByInterface(BinedModule.class);
        String title = binedModule.getNewFileTitlePrefix() + " " + this.newFilesMap.get(newFile.getId());
        newFile.setTitle(title);
        this.multiEditorPanel.addFileHandler((FileHandler)newFile, title);
    }

    public void openFile(URI fileUri, FileType fileType) {
        BinEdFileHandler file = this.createFileHandler(++this.lastIndex);
        file.loadFromFile(fileUri, fileType);
        this.multiEditorPanel.addFileHandler((FileHandler)file, file.getTitle());
    }

    @Nonnull
    private BinEdFileHandler createFileHandler(int id) {
        BinEdFileHandler fileHandler = new BinEdFileHandler(id);
        BinedModule binedModule = (BinedModule)this.application.getModuleRepository().getModuleByInterface(BinedModule.class);
        BinEdFileManager fileManager = binedModule.getFileManager();
        fileManager.initFileHandler(fileHandler);
        fileHandler.setNewData(this.defaultFileHandlingMode);
        fileHandler.getUndoHandler().addUndoUpdateListener(new XBUndoUpdateListener(){

            public void undoCommandPositionChanged() {
                BinaryMultiEditorProvider.this.undoHandler.notifyUndoUpdate();
                BinaryMultiEditorProvider.this.updateCurrentDocumentSize();
            }

            public void undoCommandAdded(Command cmnd) {
                BinaryMultiEditorProvider.this.undoHandler.notifyUndoCommandAdded(cmnd);
                BinaryMultiEditorProvider.this.updateCurrentDocumentSize();
            }
        });
        fileManager.initCommandHandler(fileHandler.getComponent());
        ExtCodeArea codeArea = fileHandler.getCodeArea();
        codeArea.addDataChangedListener(() -> {
            if (fileHandler == this.activeFileCache) {
                ((BinEdFileHandler)this.activeFileCache).getComponent().notifyDataChanged();
                if (this.editorModificationListener != null) {
                    this.editorModificationListener.modified();
                }
                this.updateCurrentDocumentSize();
            }
        });
        codeArea.addSelectionChangedListener(() -> {
            if (fileHandler == this.activeFileCache) {
                this.updateCurrentSelectionRange();
                this.updateClipboardActionsStatus();
            }
        });
        codeArea.addCaretMovedListener(caretPosition -> {
            if (fileHandler == this.activeFileCache) {
                this.updateCurrentCaretPosition();
            }
        });
        codeArea.addEditModeChangedListener((mode, operation) -> {
            if (fileHandler == this.activeFileCache && this.binaryStatus != null) {
                this.binaryStatus.setEditMode(mode, operation);
            }
        });
        this.attachFilePopupMenu(fileHandler);
        return fileHandler;
    }

    public void openFile() {
        FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
        FileActionsApi fileActions = fileModule.getFileActions();
        FileActionsApi.OpenFileResult openFileResult = fileActions.showOpenFileDialog(this.fileTypes, (UsedDirectoryApi)this);
        if (openFileResult.dialogResult == 0) {
            this.openFile(((File)CodeAreaUtils.requireNonNull((Object)openFileResult.selectedFile)).toURI(), openFileResult.fileType);
        }
    }

    public void loadFromFile(String fileName) throws URISyntaxException {
        URI fileUri = new URI(fileName);
        this.openFile(fileUri, null);
    }

    public void loadFromFile(URI fileUri, FileType fileType) {
        this.openFile(fileUri, fileType);
    }

    public void saveFile() {
        Optional activeFile = this.multiEditorPanel.getActiveFile();
        if (!activeFile.isPresent()) {
            throw new IllegalStateException();
        }
        this.saveFile((FileHandler)activeFile.get());
    }

    public void saveFile(FileHandler fileHandler) {
        if (fileHandler.getFileUri().isPresent()) {
            ((BinEdFileHandler)fileHandler).saveFile();
        } else {
            this.saveAsFile(fileHandler);
        }
    }

    public void saveAsFile() {
        Optional activeFile = this.multiEditorPanel.getActiveFile();
        if (!activeFile.isPresent()) {
            throw new IllegalStateException();
        }
        this.saveAsFile((FileHandler)activeFile.get());
    }

    public void saveAsFile(FileHandler fileHandler) {
        FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
        fileModule.getFileActions().saveAsFile(fileHandler, this.fileTypes, (UsedDirectoryApi)this);
    }

    public boolean canSave() {
        Optional optActiveFile = this.multiEditorPanel.getActiveFile();
        if (!optActiveFile.isPresent()) {
            return false;
        }
        FileHandler activeFile = (FileHandler)optActiveFile.get();
        return ((BinEdFileHandler)activeFile).isSaveSupported() && ((BinEdFileHandler)activeFile).isEditable();
    }

    @Nonnull
    public Optional<File> getLastUsedDirectory() {
        return Optional.ofNullable(this.lastUsedDirectory);
    }

    public void setLastUsedDirectory(@Nullable File directory) {
        this.lastUsedDirectory = directory;
    }

    public void updateRecentFilesList(URI fileUri, FileType fileType) {
        FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
        fileModule.updateRecentFilesList(fileUri, fileType);
    }

    private void activeFileChanged() {
        FileHandler activeFile;
        this.activeFileCache = activeFile = (FileHandler)this.multiEditorPanel.getActiveFile().orElse(null);
        this.undoHandler.setActiveFile(activeFile);
        for (MultiEditorProvider.ActiveFileChangeListener listener : this.activeFileChangeListeners) {
            listener.activeFileChanged(activeFile);
        }
        if (this.clipboardActionsUpdateListener != null) {
            this.updateClipboardActionsStatus();
        }
        if (this.binaryStatus != null) {
            this.updateStatus();
        }
        if (this.textEncodingStatusApi != null) {
            this.updateCurrentEncoding();
        }
    }

    public boolean releaseAllFiles() {
        return this.releaseOtherFiles(null);
    }

    private boolean releaseOtherFiles(@Nullable FileHandler excludedFile) {
        int fileHandlersCount = this.multiEditorPanel.getFileHandlersCount();
        if (fileHandlersCount == 0) {
            return true;
        }
        if (fileHandlersCount == 1) {
            FileHandler activeFile = this.getActiveFile().get();
            return activeFile == excludedFile || this.releaseFile(activeFile);
        }
        ArrayList<FileHandler> modifiedFiles = new ArrayList<FileHandler>();
        for (int i = 0; i < fileHandlersCount; ++i) {
            FileHandler fileHandler = this.multiEditorPanel.getFileHandler(i);
            if (!fileHandler.isModified() || fileHandler == excludedFile) continue;
            modifiedFiles.add(fileHandler);
        }
        if (modifiedFiles.isEmpty()) {
            return true;
        }
        EditorModuleApi editorModule = (EditorModuleApi)this.application.getModuleRepository().getModuleByInterface(EditorModuleApi.class);
        EditorActions editorActions = (EditorActions)editorModule.getEditorActions();
        return editorActions.showAskForSaveDialog(modifiedFiles);
    }

    public List<FileHandler> getFileHandlers() {
        ArrayList<FileHandler> fileHandlers = new ArrayList<FileHandler>();
        for (int i = 0; i < this.multiEditorPanel.getFileHandlersCount(); ++i) {
            fileHandlers.add(this.multiEditorPanel.getFileHandler(i));
        }
        return fileHandlers;
    }

    public boolean releaseFile(FileHandler fileHandler) {
        if (fileHandler.isModified()) {
            FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
            return fileModule.getFileActions().showAskForSaveDialog(fileHandler, this.fileTypes, (UsedDirectoryApi)this);
        }
        return true;
    }

    @Nonnull
    public String getName(FileHandler fileHandler) {
        String name = fileHandler.getTitle();
        if (!name.isEmpty()) {
            return name;
        }
        BinedModule binedModule = (BinedModule)this.application.getModuleRepository().getModuleByInterface(BinedModule.class);
        return binedModule.getNewFileTitlePrefix() + " " + this.newFilesMap.get(fileHandler.getId());
    }

    public void closeFile() {
        if (this.activeFileCache == null) {
            throw new IllegalStateException();
        }
        this.closeFile(this.activeFileCache);
    }

    public void closeFile(FileHandler file) {
        if (this.releaseFile(file)) {
            this.multiEditorPanel.removeFileHandler(file);
            this.newFilesMap.remove(file.getId());
        }
    }

    public void closeOtherFiles(FileHandler exceptHandler) {
        if (this.releaseOtherFiles(exceptHandler)) {
            this.multiEditorPanel.removeAllFileHandlersExceptFile(exceptHandler);
            int exceptionFileId = exceptHandler.getId();
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(exceptionFileId);
            this.newFilesMap.keySet().retainAll(list);
        }
    }

    public void closeAllFiles() {
        if (this.releaseAllFiles()) {
            this.multiEditorPanel.removeAllFileHandlers();
            this.newFilesMap.clear();
        }
    }

    public void saveAllFiles() {
        int fileHandlersCount = this.multiEditorPanel.getFileHandlersCount();
        if (fileHandlersCount == 0) {
            return;
        }
        ArrayList<FileHandler> modifiedFiles = new ArrayList<FileHandler>();
        for (int i = 0; i < fileHandlersCount; ++i) {
            FileHandler fileHandler = this.multiEditorPanel.getFileHandler(i);
            if (!fileHandler.isModified()) continue;
            modifiedFiles.add(fileHandler);
        }
        if (modifiedFiles.isEmpty()) {
            return;
        }
        EditorModuleApi editorModule = (EditorModuleApi)this.application.getModuleRepository().getModuleByInterface(EditorModuleApi.class);
        EditorActions editorActions = (EditorActions)editorModule.getEditorActions();
        editorActions.showAskForSaveDialog(modifiedFiles);
    }

    @Override
    public void registerBinaryStatus(BinaryStatusApi binaryStatus) {
        this.binaryStatus = binaryStatus;
        this.updateStatus();
    }

    @Override
    public void updateStatus() {
        this.updateCurrentDocumentSize();
        this.updateCurrentCaretPosition();
        this.updateCurrentSelectionRange();
        this.updateCurrentMemoryMode();
        this.updateCurrentEditMode();
    }

    @Override
    public void registerEncodingStatus(TextEncodingStatusApi encodingStatus) {
        this.textEncodingStatusApi = encodingStatus;
        this.updateCurrentEncoding();
    }

    public void setClipboardActionsUpdateListener(ClipboardActionsUpdateListener updateListener) {
        this.clipboardActionsUpdateListener = updateListener;
        this.updateClipboardActionsStatus();
    }

    public void addActiveFileChangeListener(MultiEditorProvider.ActiveFileChangeListener listener) {
        this.activeFileChangeListeners.add(listener);
    }

    public void removeActiveFileChangeListener(MultiEditorProvider.ActiveFileChangeListener listener) {
        this.activeFileChangeListeners.remove(listener);
    }

    @Nonnull
    public XBUndoHandler getUndoHandler() {
        return this.undoHandler;
    }

    public void setCodeAreaPopupMenuHandler(CodeAreaPopupMenuHandler codeAreaPopupMenuHandler) {
        this.codeAreaPopupMenuHandler = codeAreaPopupMenuHandler;
    }

    private void attachFilePopupMenu(BinEdFileHandler newFile) {
        if (this.codeAreaPopupMenu == null) {
            final String popupMenuId = BinedModule.BINARY_POPUP_MENU_ID + ".multi";
            this.codeAreaPopupMenu = new JPopupMenu(){

                @Override
                public void show(Component invoker, int x, int y) {
                    if (BinaryMultiEditorProvider.this.codeAreaPopupMenuHandler == null || invoker == null) {
                        return;
                    }
                    int clickedX = x;
                    int clickedY = y;
                    if (invoker instanceof JViewport) {
                        clickedX += ((JViewport)invoker).getParent().getX();
                        clickedY += ((JViewport)invoker).getParent().getY();
                    }
                    ExtCodeArea codeArea = invoker instanceof ExtCodeArea ? (ExtCodeArea)invoker : (ExtCodeArea)((JViewport)invoker).getParent().getParent();
                    JPopupMenu popupMenu = BinaryMultiEditorProvider.this.codeAreaPopupMenuHandler.createPopupMenu(codeArea, popupMenuId, clickedX, clickedY);
                    popupMenu.addPopupMenuListener(new PopupMenuListener(){

                        @Override
                        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                        }

                        @Override
                        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                            BinaryMultiEditorProvider.this.codeAreaPopupMenuHandler.dropPopupMenu(popupMenuId);
                        }

                        @Override
                        public void popupMenuCanceled(PopupMenuEvent e) {
                        }
                    });
                    popupMenu.show(invoker, x, y);
                }
            };
        }
        newFile.getComponent().getCodeArea().setComponentPopupMenu(this.codeAreaPopupMenu);
    }

    private void updateClipboardActionsStatus() {
        if (this.clipboardActionsUpdateListener != null) {
            this.clipboardActionsUpdateListener.stateChanged();
        }
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        ((ClipboardActionsUpdater)actionModule.getClipboardActions()).updateClipboardActions();
    }

    private void updateCurrentDocumentSize() {
        if (this.binaryStatus == null) {
            return;
        }
        Optional<FileHandler> activeFile = this.getActiveFile();
        if (activeFile.isPresent()) {
            ExtCodeArea codeArea = ((BinEdFileHandler)activeFile.get()).getCodeArea();
            long documentOriginalSize = ((BinEdFileHandler)activeFile.get()).getDocumentOriginalSize();
            long dataSize = codeArea.getDataSize();
            this.binaryStatus.setCurrentDocumentSize(dataSize, documentOriginalSize);
        }
    }

    private void updateCurrentCaretPosition() {
        if (this.binaryStatus == null) {
            return;
        }
        Optional<FileHandler> activeFile = this.getActiveFile();
        if (activeFile.isPresent()) {
            ExtCodeArea codeArea = ((BinEdFileHandler)activeFile.get()).getCodeArea();
            CodeAreaCaretPosition caretPosition = codeArea.getCaretPosition();
            this.binaryStatus.setCursorPosition(caretPosition);
        }
    }

    private void updateCurrentSelectionRange() {
        if (this.binaryStatus == null) {
            return;
        }
        Optional<FileHandler> activeFile = this.getActiveFile();
        if (activeFile.isPresent()) {
            ExtCodeArea codeArea = ((BinEdFileHandler)activeFile.get()).getCodeArea();
            SelectionRange selectionRange = codeArea.getSelection();
            this.binaryStatus.setSelectionRange(selectionRange);
        }
    }

    private void updateCurrentMemoryMode() {
        if (this.binaryStatus == null) {
            return;
        }
        Optional<FileHandler> activeFile = this.getActiveFile();
        if (activeFile.isPresent()) {
            ExtCodeArea codeArea = ((BinEdFileHandler)activeFile.get()).getCodeArea();
            BinaryStatusApi.MemoryMode newMemoryMode = BinaryStatusApi.MemoryMode.RAM_MEMORY;
            if (codeArea.getEditMode() == EditMode.READ_ONLY) {
                newMemoryMode = BinaryStatusApi.MemoryMode.READ_ONLY;
            } else if (codeArea.getContentData() instanceof DeltaDocument) {
                newMemoryMode = BinaryStatusApi.MemoryMode.DELTA_MODE;
            }
            this.binaryStatus.setMemoryMode(newMemoryMode);
        }
    }

    private void updateCurrentEditMode() {
        if (this.binaryStatus == null) {
            return;
        }
        Optional<FileHandler> activeFile = this.getActiveFile();
        if (activeFile.isPresent()) {
            ExtCodeArea codeArea = ((BinEdFileHandler)activeFile.get()).getCodeArea();
            this.binaryStatus.setEditMode(codeArea.getEditMode(), codeArea.getActiveOperation());
        }
    }

    private void updateCurrentEncoding() {
        if (this.textEncodingStatusApi == null) {
            return;
        }
        Optional<FileHandler> activeFile = this.getActiveFile();
        if (activeFile.isPresent()) {
            this.textEncodingStatusApi.setEncoding(((BinEdFileHandler)activeFile.get()).getCharset().name());
        }
    }

    private class EditorPopupMenu
    extends JPopupMenu
    implements MultiEditorPopupMenu {
        @Nullable
        private final FileHandler selectedFile;

        public EditorPopupMenu(FileHandler selectedFile) {
            this.selectedFile = selectedFile;
        }

        @Nonnull
        public Optional<FileHandler> getSelectedFile() {
            return Optional.ofNullable(this.selectedFile);
        }
    }
}

