/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JPanel;
import org.exbin.auxiliary.binary_data.delta.SegmentsRepository;
import org.exbin.bined.operation.swing.CodeAreaOperationCommandHandler;
import org.exbin.bined.operation.undo.BinaryDataUndoHandler;
import org.exbin.bined.swing.CodeAreaCommandHandler;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.bined.BinEdCodeAreaPainter;
import org.exbin.framework.bined.BinEdEditorProvider;
import org.exbin.framework.bined.BinEdFileHandler;
import org.exbin.framework.bined.BinedModule;
import org.exbin.framework.bined.CodeAreaCommandHandlerProvider;
import org.exbin.framework.bined.gui.BinEdComponentPanel;
import org.exbin.framework.bined.gui.BinaryStatusPanel;
import org.exbin.framework.bined.options.impl.StatusOptionsImpl;
import org.exbin.framework.bined.preferences.BinaryEditorPreferences;
import org.exbin.framework.bined.preferences.CodeAreaPreferences;
import org.exbin.framework.bined.preferences.StatusPreferences;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.text.EncodingsHandler;
import org.exbin.framework.editor.text.TextEncodingStatusApi;
import org.exbin.framework.editor.text.preferences.TextFontPreferences;
import org.exbin.framework.frame.api.FrameModuleApi;

@ParametersAreNonnullByDefault
public class BinEdFileManager {
    private XBApplication application;
    private EditorProvider editorProvider;
    private BinaryStatusPanel binaryStatusPanel;
    private final SegmentsRepository segmentsRepository = new SegmentsRepository();
    private final List<BinEdFileExtension> binEdComponentExtensions = new ArrayList<BinEdFileExtension>();
    private final List<ActionStatusUpdateListener> actionStatusUpdateListeners = new ArrayList<ActionStatusUpdateListener>();
    private final List<BinEdCodeAreaPainter.PositionColorModifier> painterPositionColorModifiers = new ArrayList<BinEdCodeAreaPainter.PositionColorModifier>();
    private final List<BinEdCodeAreaPainter.PositionColorModifier> painterPriorityPositionColorModifiers = new ArrayList<BinEdCodeAreaPainter.PositionColorModifier>();
    private CodeAreaCommandHandlerProvider commandHandlerProvider = null;

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void setEditorProvider(EditorProvider editorProvider) {
        this.editorProvider = editorProvider;
    }

    public void initFileHandler(BinEdFileHandler fileHandler) {
        fileHandler.setApplication(this.application);
        fileHandler.setSegmentsRepository(this.segmentsRepository);
        BinEdComponentPanel componentPanel = fileHandler.getComponent();
        this.initComponentPanel(componentPanel);
    }

    public void initComponentPanel(BinEdComponentPanel componentPanel) {
        TextFontPreferences textFontPreferences;
        ExtCodeArea codeArea = componentPanel.getCodeArea();
        for (BinEdFileExtension binEdFileExtension : this.binEdComponentExtensions) {
            Optional<BinEdComponentPanel.BinEdComponentExtension> componentExtension = binEdFileExtension.createComponentExtension(componentPanel);
            componentExtension.ifPresent(extension -> {
                extension.setApplication(this.application);
                extension.onCreate(componentPanel);
                componentPanel.addComponentExtension((BinEdComponentPanel.BinEdComponentExtension)extension);
            });
        }
        BinEdCodeAreaPainter painter = (BinEdCodeAreaPainter)componentPanel.getCodeArea().getPainter();
        for (BinEdCodeAreaPainter.PositionColorModifier modifier : this.painterPriorityPositionColorModifiers) {
            painter.addPriorityColorModifier(modifier);
        }
        for (BinEdCodeAreaPainter.PositionColorModifier modifier : this.painterPositionColorModifiers) {
            painter.addColorModifier(modifier);
        }
        Preferences preferences = this.application.getAppPreferences();
        BinaryEditorPreferences binaryEditorPreferences = new BinaryEditorPreferences(preferences);
        componentPanel.onInitFromPreferences(binaryEditorPreferences);
        String encoding = binaryEditorPreferences.getEncodingPreferences().getSelectedEncoding();
        if (!encoding.isEmpty()) {
            codeArea.setCharset(Charset.forName(encoding));
        }
        codeArea.setCodeFont((textFontPreferences = binaryEditorPreferences.getFontPreferences()).isUseDefaultFont() ? CodeAreaPreferences.DEFAULT_FONT : textFontPreferences.getFont(CodeAreaPreferences.DEFAULT_FONT));
        if (this.binaryStatusPanel != null) {
            this.binaryStatusPanel.loadFromPreferences(binaryEditorPreferences.getStatusPreferences());
        }
    }

    public void initCommandHandler(BinEdComponentPanel componentPanel) {
        ExtCodeArea codeArea = componentPanel.getCodeArea();
        CodeAreaOperationCommandHandler commandHandler = this.commandHandlerProvider != null ? this.commandHandlerProvider.createCommandHandler((CodeAreaCore)codeArea, componentPanel.getUndoHandler().orElse(null)) : new CodeAreaOperationCommandHandler((CodeAreaCore)codeArea, (BinaryDataUndoHandler)componentPanel.getUndoHandler().orElse(null));
        codeArea.setCommandHandler((CodeAreaCommandHandler)commandHandler);
    }

    public void addPainterColorModifier(BinEdCodeAreaPainter.PositionColorModifier modifier) {
        this.painterPositionColorModifiers.add(modifier);
    }

    public void removePainterColorModifier(BinEdCodeAreaPainter.PositionColorModifier modifier) {
        this.painterPositionColorModifiers.remove(modifier);
    }

    public void addPainterPriorityColorModifier(BinEdCodeAreaPainter.PositionColorModifier modifier) {
        this.painterPriorityPositionColorModifiers.add(modifier);
    }

    public void removePainterPriorityColorModifier(BinEdCodeAreaPainter.PositionColorModifier modifier) {
        this.painterPriorityPositionColorModifiers.remove(modifier);
    }

    public void registerStatusBar() {
        this.binaryStatusPanel = new BinaryStatusPanel();
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        frameModule.registerStatusBar(BinedModule.MODULE_ID, "binaryStatusBar", (JPanel)this.binaryStatusPanel);
        frameModule.switchStatusBar("binaryStatusBar");
        ((BinEdEditorProvider)this.editorProvider).registerBinaryStatus(this.binaryStatusPanel);
        ((BinEdEditorProvider)this.editorProvider).registerEncodingStatus(this.binaryStatusPanel);
    }

    public void updateTextEncodingStatus(EncodingsHandler encodingsHandler) {
        if (this.binaryStatusPanel != null) {
            encodingsHandler.setTextEncodingStatus((TextEncodingStatusApi)this.binaryStatusPanel);
        }
    }

    public void updateActionStatus(@Nullable CodeAreaCore codeArea) {
        for (ActionStatusUpdateListener listener : this.actionStatusUpdateListeners) {
            listener.updateActionStatus(codeArea);
        }
    }

    public void applyPreferencesChanges(StatusOptionsImpl options) {
        this.binaryStatusPanel.setStatusOptions(options);
    }

    public void setStatusControlHandler(BinaryStatusPanel.StatusControlHandler statusControlHandler) {
        this.binaryStatusPanel.setStatusControlHandler(statusControlHandler);
    }

    public void setCommandHandlerProvider(CodeAreaCommandHandlerProvider commandHandlerProvider) {
        this.commandHandlerProvider = commandHandlerProvider;
    }

    public void addBinEdComponentExtension(BinEdFileExtension extension) {
        this.binEdComponentExtensions.add(extension);
    }

    public void addActionStatusUpdateListener(ActionStatusUpdateListener listener) {
        this.actionStatusUpdateListeners.add(listener);
    }

    public void loadFromPreferences(Preferences preferences) {
        this.binaryStatusPanel.loadFromPreferences(new StatusPreferences(preferences));
    }

    @Nonnull
    public Iterable<BinEdFileExtension> getBinEdComponentExtensions() {
        return this.binEdComponentExtensions;
    }

    @Nullable
    public BinaryStatusPanel getBinaryStatusPanel() {
        return this.binaryStatusPanel;
    }

    @ParametersAreNonnullByDefault
    public static interface ActionStatusUpdateListener {
        public void updateActionStatus(CodeAreaCore var1);
    }

    @ParametersAreNonnullByDefault
    public static interface BinEdFileExtension {
        @Nonnull
        public Optional<BinEdComponentPanel.BinEdComponentExtension> createComponentExtension(BinEdComponentPanel var1);
    }
}

