/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.utils.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.OkCancelListener;
import org.exbin.framework.utils.UiUtils;
import org.exbin.framework.utils.handler.OptionsControlHandler;

@ParametersAreNonnullByDefault
public class OptionsControlPanel
extends JPanel
implements OptionsControlHandler.OptionsControlService {
    private final ResourceBundle resourceBundle;
    private OptionsControlHandler handler;
    private OkCancelListener okCancelListener;
    private JButton applyOnceButton;
    private JButton cancelButton;
    private JButton saveButton;

    public OptionsControlPanel() {
        this(LanguageUtils.getResourceBundleByClass(OptionsControlPanel.class));
    }

    public OptionsControlPanel(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        this.initComponents();
        this.okCancelListener = new OkCancelListener(){

            @Override
            public void okEvent() {
                OptionsControlPanel.this.performClick(OptionsControlHandler.ControlActionType.SAVE);
            }

            @Override
            public void cancelEvent() {
                OptionsControlPanel.this.performClick(OptionsControlHandler.ControlActionType.CANCEL);
            }
        };
    }

    public void setHandler(OptionsControlHandler handler) {
        this.handler = handler;
    }

    private void initComponents() {
        this.cancelButton = new JButton();
        this.saveButton = new JButton();
        this.applyOnceButton = new JButton();
        this.cancelButton.setText(this.resourceBundle.getString("cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsControlPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        this.saveButton.setText(this.resourceBundle.getString("saveButton.text"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsControlPanel.this.saveButtonActionPerformed(evt);
            }
        });
        this.applyOnceButton.setText(this.resourceBundle.getString("applyOnceButton.text"));
        this.applyOnceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsControlPanel.this.applyOnceButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.applyOnceButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.applyOnceButton).addComponent(this.saveButton)).addContainerGap()));
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        if (this.handler != null) {
            this.handler.controlActionPerformed(OptionsControlHandler.ControlActionType.CANCEL);
        }
    }

    private void applyOnceButtonActionPerformed(ActionEvent evt) {
        if (this.handler != null) {
            this.handler.controlActionPerformed(OptionsControlHandler.ControlActionType.APPLY_ONCE);
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        if (this.handler != null) {
            this.handler.controlActionPerformed(OptionsControlHandler.ControlActionType.SAVE);
        }
    }

    @Override
    public void performClick(OptionsControlHandler.ControlActionType actionType) {
        switch (actionType) {
            case SAVE: {
                UiUtils.doButtonClick(this.saveButton);
                break;
            }
            case APPLY_ONCE: {
                UiUtils.doButtonClick(this.applyOnceButton);
                break;
            }
            case CANCEL: {
                UiUtils.doButtonClick(this.cancelButton);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal action type " + actionType.name());
            }
        }
    }

    @Override
    @Nonnull
    public JButton getDefaultButton() {
        return this.saveButton;
    }

    @Override
    @Nonnull
    public OkCancelListener getOkCancelListener() {
        return this.okCancelListener;
    }

    @Override
    @Nonnull
    public OptionsControlHandler.OptionsControlEnablementListener createEnablementListener() {
        return (actionType, enablement) -> {
            switch (actionType) {
                case APPLY_ONCE: {
                    this.applyOnceButton.setEnabled(enablement);
                    break;
                }
                case CANCEL: {
                    this.cancelButton.setEnabled(enablement);
                    break;
                }
                case SAVE: {
                    this.saveButton.setEnabled(enablement);
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal action type " + actionType.name());
                }
            }
        };
    }
}

