/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.utils.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.OkCancelListener;
import org.exbin.framework.utils.UiUtils;
import org.exbin.framework.utils.handler.DefaultControlHandler;

@ParametersAreNonnullByDefault
public class DefaultControlPanel
extends JPanel
implements DefaultControlHandler.DefaultControlService {
    private final ResourceBundle resourceBundle;
    private DefaultControlHandler handler;
    private OkCancelListener okCancelListener;
    private JButton cancelButton;
    private JButton okButton;

    public DefaultControlPanel() {
        this(LanguageUtils.getResourceBundleByClass(DefaultControlPanel.class));
    }

    public DefaultControlPanel(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        this.initComponents();
        this.okCancelListener = new OkCancelListener(){

            @Override
            public void okEvent() {
                DefaultControlPanel.this.performClick(DefaultControlHandler.ControlActionType.OK);
            }

            @Override
            public void cancelEvent() {
                DefaultControlPanel.this.performClick(DefaultControlHandler.ControlActionType.CANCEL);
            }
        };
    }

    public void setHandler(DefaultControlHandler handler) {
        this.handler = handler;
    }

    private void initComponents() {
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.okButton.setText(this.resourceBundle.getString("okButton.text"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultControlPanel.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText(this.resourceBundle.getString("cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultControlPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.handler != null) {
            this.handler.controlActionPerformed(DefaultControlHandler.ControlActionType.OK);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        if (this.handler != null) {
            this.handler.controlActionPerformed(DefaultControlHandler.ControlActionType.CANCEL);
        }
    }

    @Override
    public void performClick(DefaultControlHandler.ControlActionType actionType) {
        UiUtils.doButtonClick(actionType == DefaultControlHandler.ControlActionType.OK ? this.okButton : this.cancelButton);
    }

    @Override
    @Nonnull
    public JButton getDefaultButton() {
        return this.okButton;
    }

    @Override
    @Nonnull
    public OkCancelListener getOkCancelListener() {
        return this.okCancelListener;
    }

    @Override
    @Nonnull
    public DefaultControlHandler.DefaultControlEnablementListener createEnablementListener() {
        return (actionType, enablement) -> {
            switch (actionType) {
                case OK: {
                    this.okButton.setEnabled(enablement);
                    break;
                }
                case CANCEL: {
                    this.cancelButton.setEnabled(enablement);
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal action type " + actionType.name());
                }
            }
        };
    }
}

