/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.utils;

import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.api.Preferences;

@ParametersAreNonnullByDefault
public class WindowPosition {
    public static final String PREFERENCES_SCREEN_INDEX = "screenIndex";
    public static final String PREFERENCES_SCREEN_WIDTH = "screenWidth";
    public static final String PREFERENCES_SCREEN_HEIGHT = "screenHeight";
    public static final String PREFERENCES_POSITION_X = "positionX";
    public static final String PREFERENCES_POSITION_Y = "positionY";
    public static final String PREFERENCES_WIDTH = "width";
    public static final String PREFERENCES_HEIGHT = "height";
    public static final String PREFERENCES_MAXIMIZED = "maximized";
    private int screenIndex;
    private int screenWidth;
    private int screenHeight;
    private int relativeX;
    private int relativeY;
    private int width;
    private int height;
    private boolean maximized = false;

    public int getScreenIndex() {
        return this.screenIndex;
    }

    public void setScreenIndex(int screenIndex) {
        this.screenIndex = screenIndex;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public void setScreenWidth(int screenWidth) {
        this.screenWidth = screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public void setScreenHeight(int screenHeight) {
        this.screenHeight = screenHeight;
    }

    public int getRelativeX() {
        return this.relativeX;
    }

    public void setRelativeX(int relativeX) {
        this.relativeX = relativeX;
    }

    public int getRelativeY() {
        return this.relativeY;
    }

    public void setRelativeY(int relativeY) {
        this.relativeY = relativeY;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    public void setMaximized(boolean maximized) {
        this.maximized = maximized;
    }

    public void saveToPreferences(Preferences pref, String prefix) {
        pref.putInt(prefix + PREFERENCES_SCREEN_INDEX, this.screenIndex);
        pref.putInt(prefix + PREFERENCES_SCREEN_WIDTH, this.screenWidth);
        pref.putInt(prefix + PREFERENCES_SCREEN_HEIGHT, this.screenHeight);
        pref.putInt(prefix + PREFERENCES_POSITION_X, this.relativeX);
        pref.putInt(prefix + PREFERENCES_POSITION_Y, this.relativeY);
        pref.putInt(prefix + PREFERENCES_WIDTH, this.width);
        pref.putInt(prefix + PREFERENCES_HEIGHT, this.height);
        pref.putBoolean(prefix + PREFERENCES_MAXIMIZED, this.maximized);
    }

    public void loadFromPreferences(Preferences pref, String prefix) {
        this.screenIndex = pref.getInt(prefix + PREFERENCES_SCREEN_INDEX, 0);
        this.screenWidth = pref.getInt(prefix + PREFERENCES_SCREEN_WIDTH, 0);
        this.screenHeight = pref.getInt(prefix + PREFERENCES_SCREEN_HEIGHT, 0);
        this.relativeX = pref.getInt(prefix + PREFERENCES_POSITION_X, 0);
        this.relativeY = pref.getInt(prefix + PREFERENCES_POSITION_Y, 0);
        this.width = pref.getInt(prefix + PREFERENCES_WIDTH, 0);
        this.height = pref.getInt(prefix + PREFERENCES_HEIGHT, 0);
        this.maximized = pref.getBoolean(prefix + PREFERENCES_MAXIMIZED, false);
    }

    public boolean preferencesExists(Preferences pref, String prefix) {
        return pref.exists(prefix + PREFERENCES_SCREEN_INDEX);
    }
}

