/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.client;

import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.Persistence;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.client.api.ClientConnectionEvent;
import org.exbin.framework.client.api.ClientConnectionListener;
import org.exbin.framework.client.api.ClientModuleApi;
import org.exbin.framework.client.api.ConnectionStatus;
import org.exbin.framework.client.api.PluginRepositoryListener;
import org.exbin.framework.preferences.PreferencesWrapper;
import org.exbin.xbup.catalog.XBAECatalog;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBERoot;
import org.exbin.xbup.catalog.entity.service.XBEXDescService;
import org.exbin.xbup.catalog.entity.service.XBEXFileService;
import org.exbin.xbup.catalog.entity.service.XBEXHDocService;
import org.exbin.xbup.catalog.entity.service.XBEXIconService;
import org.exbin.xbup.catalog.entity.service.XBEXLangService;
import org.exbin.xbup.catalog.entity.service.XBEXNameService;
import org.exbin.xbup.catalog.entity.service.XBEXPlugService;
import org.exbin.xbup.catalog.entity.service.XBEXStriService;
import org.exbin.xbup.catalog.entity.service.XBEXUiService;
import org.exbin.xbup.catalog.update.XBCatalogServiceUpdateHandler;
import org.exbin.xbup.client.XBCallException;
import org.exbin.xbup.client.XBCatalogNetServiceClient;
import org.exbin.xbup.client.XBCatalogServiceClient;
import org.exbin.xbup.client.catalog.XBARCatalog;
import org.exbin.xbup.client.catalog.XBRCatalog;
import org.exbin.xbup.client.catalog.remote.service.XBRXDescService;
import org.exbin.xbup.client.catalog.remote.service.XBRXFileService;
import org.exbin.xbup.client.catalog.remote.service.XBRXHDocService;
import org.exbin.xbup.client.catalog.remote.service.XBRXIconService;
import org.exbin.xbup.client.catalog.remote.service.XBRXLangService;
import org.exbin.xbup.client.catalog.remote.service.XBRXNameService;
import org.exbin.xbup.client.catalog.remote.service.XBRXPlugService;
import org.exbin.xbup.client.catalog.remote.service.XBRXStriService;
import org.exbin.xbup.client.catalog.remote.service.XBRXUiService;
import org.exbin.xbup.client.update.XBCUpdateHandler;
import org.exbin.xbup.client.update.XBCUpdateListener;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCBase;
import org.exbin.xbup.core.catalog.base.XBCRoot;
import org.exbin.xbup.core.catalog.base.service.XBCRootService;
import org.exbin.xbup.core.catalog.base.service.XBCService;
import org.exbin.xbup.core.catalog.base.service.XBCXDescService;
import org.exbin.xbup.core.catalog.base.service.XBCXFileService;
import org.exbin.xbup.core.catalog.base.service.XBCXHDocService;
import org.exbin.xbup.core.catalog.base.service.XBCXIconService;
import org.exbin.xbup.core.catalog.base.service.XBCXLangService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.core.catalog.base.service.XBCXPlugService;
import org.exbin.xbup.core.catalog.base.service.XBCXStriService;
import org.exbin.xbup.core.catalog.base.service.XBCXUiService;
import org.exbin.xbup.plugin.XBModuleHandler;
import org.exbin.xbup.plugin.XBPluginRepository;

@ParametersAreNonnullByDefault
public class ClientModule
implements ClientModuleApi {
    private XBApplication application;
    private boolean devMode = false;
    private XBACatalog catalog;
    private XBPluginRepository pluginRepository;
    private final List<ClientConnectionListener> connectionListeners = new ArrayList<ClientConnectionListener>();
    private final List<PluginRepositoryListener> pluginRepositoryListeners = new ArrayList<PluginRepositoryListener>();

    public void init(XBModuleHandler application) {
        this.application = (XBApplication)application;
    }

    public void unregisterModule(String moduleId) {
    }

    public boolean connectToService() {
        String catalogHost;
        this.connectionStatusChanged(ConnectionStatus.DISCONNECTED);
        this.setCatalog(null);
        int defaultPort = this.devMode ? 22595 : 22594;
        String catalogConnection = "localhost:" + defaultPort;
        int catalogPort = defaultPort;
        int pos = catalogConnection.indexOf(":");
        if (pos >= 0) {
            catalogHost = catalogConnection.substring(0, pos);
            catalogPort = Integer.valueOf(catalogConnection.substring(pos + 1));
        } else {
            catalogHost = catalogConnection;
        }
        XBCatalogNetServiceClient serviceClient = new XBCatalogNetServiceClient(catalogHost, catalogPort);
        this.connectionStatusChanged(ConnectionStatus.CONNECTING);
        if (serviceClient.validate()) {
            XBARCatalog catalogHandler = new XBARCatalog((XBCatalogServiceClient)serviceClient);
            this.catalog = catalogHandler;
            this.initializePlugins(this.catalog);
            catalogHandler.addCatalogService(XBCXLangService.class, (XBCService)new XBRXLangService((XBRCatalog)catalogHandler));
            catalogHandler.addCatalogService(XBCXStriService.class, (XBCService)new XBRXStriService((XBRCatalog)catalogHandler));
            catalogHandler.addCatalogService(XBCXNameService.class, (XBCService)new XBRXNameService((XBRCatalog)catalogHandler));
            catalogHandler.addCatalogService(XBCXDescService.class, (XBCService)new XBRXDescService((XBRCatalog)catalogHandler));
            catalogHandler.addCatalogService(XBCXFileService.class, (XBCService)new XBRXFileService((XBRCatalog)catalogHandler));
            catalogHandler.addCatalogService(XBCXIconService.class, (XBCService)new XBRXIconService((XBRCatalog)catalogHandler));
            catalogHandler.addCatalogService(XBCXPlugService.class, (XBCService)new XBRXPlugService((XBRCatalog)catalogHandler));
            catalogHandler.addCatalogService(XBCXUiService.class, (XBCService)new XBRXUiService((XBRCatalog)catalogHandler));
            catalogHandler.addCatalogService(XBCXHDocService.class, (XBCService)new XBRXHDocService((XBRCatalog)catalogHandler));
            if ("localhost".equals(serviceClient.getHost()) || "127.0.0.1".equals(serviceClient.getHost())) {
                this.connectionStatusChanged(ConnectionStatus.LOCAL);
            } else {
                this.connectionStatusChanged(ConnectionStatus.NETWORK);
            }
            return true;
        }
        this.connectionStatusChanged(ConnectionStatus.FAILED);
        return false;
    }

    private void connectionStatusChanged(ConnectionStatus connectionStatus) {
        ClientConnectionEvent connectionEvent = new ClientConnectionEvent(connectionStatus);
        for (int i = 0; i < this.connectionListeners.size(); ++i) {
            ClientConnectionListener listener = this.connectionListeners.get(i);
            listener.connectionChanged(connectionEvent);
        }
    }

    public boolean runLocalCatalog() {
        this.connectionStatusChanged(ConnectionStatus.CONNECTING);
        Preferences preferences = this.application.getAppPreferences();
        try {
            String derbyHome = System.getProperty("user.home") + "/.java/.userPrefs/" + ((PreferencesWrapper)preferences).getInnerPreferences().absolutePath();
            if (this.devMode) {
                derbyHome = derbyHome + "-dev";
            }
            System.setProperty("derby.system.home", derbyHome);
            EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"XBEditorPU");
            EntityManager em = emf.createEntityManager();
            em.setFlushMode(FlushModeType.AUTO);
            XBAECatalog intCatalog = this.createInternalCatalog(em);
            if (intCatalog.isShallInit()) {
                this.connectionStatusChanged(ConnectionStatus.INITIALIZING);
                intCatalog.initCatalog();
            }
            try {
                int defaultPort = this.devMode ? 22595 : 22594;
                String mainCatalogHost = this.devMode ? "catalog-dev.exbin.org" : "catalog.exbin.org";
                XBCatalogNetServiceClient mainClient = new XBCatalogNetServiceClient(mainCatalogHost, defaultPort);
                XBCatalogServiceUpdateHandler updateHandler = new XBCatalogServiceUpdateHandler(intCatalog, mainClient);
                intCatalog.setUpdateHandler((XBCUpdateHandler)updateHandler);
                XBCRootService rootService = (XBCRootService)intCatalog.getCatalogService(XBCRootService.class);
                try {
                    Optional localLastUpdate = rootService.getMainLastUpdate();
                    Date remoteLastUpdate = updateHandler.getMainLastUpdate();
                    if (!rootService.isMainPresent() || !localLastUpdate.isPresent() || ((Date)localLastUpdate.get()).before(remoteLastUpdate)) {
                        System.out.print("Update due to: ");
                        if (!rootService.isMainPresent()) {
                            System.out.println("Missing main root");
                        } else if (!localLastUpdate.isPresent()) {
                            System.out.println("No last update date");
                        } else {
                            System.out.println("Never update available " + remoteLastUpdate.toString() + " > " + ((Date)localLastUpdate.get()).toString());
                        }
                        this.connectionStatusChanged(ConnectionStatus.UPDATING);
                        em.close();
                        EntityManagerFactory emfDrop = Persistence.createEntityManagerFactory((String)"XBEditorPU-drop");
                        EntityManager emDrop = emfDrop.createEntityManager();
                        emDrop.setFlushMode(FlushModeType.AUTO);
                        intCatalog = this.createInternalCatalog(emDrop);
                        intCatalog.setUpdateHandler((XBCUpdateHandler)new XBCatalogServiceUpdateHandler(intCatalog, mainClient));
                        intCatalog.initCatalog();
                        rootService = (XBCRootService)intCatalog.getCatalogService(XBCRootService.class);
                        this.performUpdate(intCatalog, rootService, remoteLastUpdate);
                    }
                    this.connectionStatusChanged(ConnectionStatus.INTERNET);
                }
                catch (XBCallException ex) {
                    if (!(ex.getCause() instanceof ConnectException)) {
                        Logger.getLogger(ClientModule.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.connectionStatusChanged(ConnectionStatus.FAILED);
                }
                catch (Exception ex) {
                    Logger.getLogger(ClientModule.class.getName()).log(Level.SEVERE, null, ex);
                    this.connectionStatusChanged(ConnectionStatus.FAILED);
                }
            }
            catch (Exception ex) {
                Logger.getLogger(ClientModule.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            this.catalog = intCatalog;
            this.initializePlugins(this.catalog);
            return true;
        }
        catch (Exception ex) {
            Logger.getLogger(ClientModule.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    private void performUpdate(XBAECatalog catalog, XBCRootService rootService, Date remoteLastUpdate) {
        XBCUpdateHandler updateHandler = catalog.getUpdateHandler();
        XBCUpdateListener updateListener = new XBCUpdateListener(){
            private boolean toolBarVisibleTemp;

            public void webServiceUsage(boolean status) {
            }
        };
        updateHandler.addUpdateListener(updateListener);
        updateHandler.performUpdateMain();
        EntityManager em = catalog.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        tx.begin();
        XBCRoot mainRoot = rootService.getMainRoot();
        ((XBERoot)mainRoot).setLastUpdate(remoteLastUpdate);
        rootService.persistItem((XBCBase)mainRoot);
        tx.commit();
        updateHandler.removeUpdateListener(updateListener);
    }

    public void useBuildInCatalog() {
        Preferences preferences = this.application.getAppPreferences();
        String derbyHome = System.getProperty("user.home") + "/.java/.userPrefs/" + ((PreferencesWrapper)preferences).getInnerPreferences().absolutePath();
        if (this.devMode) {
            derbyHome = derbyHome + "-dev";
        }
        System.setProperty("derby.system.home", derbyHome);
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"XBEditorPU");
        EntityManager em = emf.createEntityManager();
        em.setFlushMode(FlushModeType.AUTO);
        XBAECatalog catalogHandler = this.createInternalCatalog(em);
        if (catalogHandler.isShallInit()) {
            catalogHandler.initCatalog();
        }
        this.catalog = catalogHandler;
        this.initializePlugins(this.catalog);
    }

    private void initializePlugins(XBACatalog catalogHandler) {
        this.pluginRepository = new XBPluginRepository();
        this.pluginRepository.setCatalog(catalogHandler);
        this.pluginRepositoryListeners.forEach(listener -> listener.repositoryChanged(this.pluginRepository));
    }

    @Nonnull
    private XBAECatalog createInternalCatalog(EntityManager em) {
        XBAECatalog createdCatalog = new XBAECatalog(em);
        createdCatalog.addCatalogService(XBCXLangService.class, (XBCService)new XBEXLangService((XBECatalog)createdCatalog));
        createdCatalog.addCatalogService(XBCXStriService.class, (XBCService)new XBEXStriService((XBECatalog)createdCatalog));
        createdCatalog.addCatalogService(XBCXNameService.class, (XBCService)new XBEXNameService((XBECatalog)createdCatalog));
        createdCatalog.addCatalogService(XBCXDescService.class, (XBCService)new XBEXDescService((XBECatalog)createdCatalog));
        createdCatalog.addCatalogService(XBCXFileService.class, (XBCService)new XBEXFileService((XBECatalog)createdCatalog));
        createdCatalog.addCatalogService(XBCXIconService.class, (XBCService)new XBEXIconService((XBECatalog)createdCatalog));
        createdCatalog.addCatalogService(XBCXPlugService.class, (XBCService)new XBEXPlugService((XBECatalog)createdCatalog));
        createdCatalog.addCatalogService(XBCXUiService.class, (XBCService)new XBEXUiService((XBECatalog)createdCatalog));
        createdCatalog.addCatalogService(XBCXHDocService.class, (XBCService)new XBEXHDocService((XBECatalog)createdCatalog));
        return createdCatalog;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    @Nonnull
    public XBACatalog getCatalog() {
        return this.catalog;
    }

    @Nonnull
    public XBPluginRepository getPluginRepository() {
        return this.pluginRepository;
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public void setDevMode(boolean devMode) {
        this.devMode = devMode;
    }

    public void addClientConnectionListener(ClientConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeClientConnectionListener(ClientConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    public void addPluginRepositoryListener(PluginRepositoryListener listener) {
        this.pluginRepositoryListeners.add(listener);
    }

    public void removePluginRepositoryListener(PluginRepositoryListener listener) {
        this.pluginRepositoryListeners.remove(listener);
    }
}

