/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split.layer;

import bibliothek.gui.DockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.layer.LayerPriority;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class SideSnapDropLayer
implements DockStationDropLayer {
    private SplitDockStation station;
    private LayerPriority priority = LayerPriority.OUTSIDE_LOW;

    public SideSnapDropLayer(SplitDockStation station) {
        this.station = station;
    }

    public LayerPriority getPriority() {
        return this.priority;
    }

    public void setPriority(LayerPriority priority) {
        this.priority = priority;
    }

    public boolean canCompare(DockStationDropLayer level) {
        return false;
    }

    public int compare(DockStationDropLayer level) {
        return 0;
    }

    public Component getComponent() {
        return this.station.getComponent();
    }

    public DockStation getStation() {
        return this.station;
    }

    public DockStationDropLayer modify(DockStationDropLayer child) {
        return child;
    }

    public boolean contains(int x, int y) {
        int size;
        if (!this.station.isAllowSideSnap()) {
            return false;
        }
        Point point = new Point(x, y);
        SwingUtilities.convertPointFromScreen(point, this.getComponent());
        Rectangle bounds = this.getComponent().getBounds();
        if (bounds.contains(point)) {
            return false;
        }
        x = point.x;
        y = point.y;
        int deltaX = Math.min(Math.abs(x), Math.abs(x - bounds.width));
        if (x > 0 && x < bounds.width) {
            deltaX = 0;
        }
        int deltaY = Math.min(Math.abs(y), Math.abs(y - bounds.height));
        if (y > 0 && y < bounds.height) {
            deltaY = 0;
        }
        return deltaX <= (size = this.station.getBorderSideSnapSize()) && deltaY <= size;
    }
}

