/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.SplitDockAccess;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.station.split.SplitTreeFactory;
import bibliothek.util.Path;
import java.awt.Dimension;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Placeholder
extends SplitNode {
    public Placeholder(SplitDockAccess access, long id) {
        super(access, id);
    }

    @Override
    public void evolve(SplitDockTree.Key key, boolean checkValidity, Map<Leaf, Dockable> linksToSet) {
        this.setPlaceholders(key.getTree().getPlaceholders(key));
    }

    @Override
    public int getChildLocation(SplitNode child) {
        return -1;
    }

    @Override
    public Node getDividerNode(int x, int y) {
        return null;
    }

    @Override
    public Leaf getLeaf(Dockable dockable) {
        return null;
    }

    @Override
    public Dimension getMinimumSize() {
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        return null;
    }

    @Override
    public PutInfo getPut(int x, int y, double factorW, double factorH, Dockable drop) {
        return null;
    }

    @Override
    public boolean insert(SplitDockPlaceholderProperty property, Dockable dockable) {
        Path placeholder = property.getPlaceholder();
        if (this.hasPlaceholder(placeholder)) {
            Leaf leaf = this.create(dockable, this.getId());
            if (leaf == null) {
                return false;
            }
            this.getAccess().getPlaceholderSet().set(null, placeholder, this);
            leaf.setPlaceholders(this.getPlaceholders());
            leaf.setPlaceholderMap(this.getPlaceholderMap());
            this.replace(leaf);
            leaf.setDockable(dockable, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean insert(SplitDockPathProperty property, int depth, Dockable dockable) {
        return false;
    }

    @Override
    public boolean isInOverrideZone(int x, int y, double factorW, double factorH) {
        return false;
    }

    @Override
    public void setChild(SplitNode child, int location) {
        throw new IllegalArgumentException();
    }

    @Override
    public int getMaxChildrenCount() {
        return 0;
    }

    @Override
    public SplitNode getChild(int location) {
        return null;
    }

    @Override
    public <N> N submit(SplitTreeFactory<N> factory) {
        return factory.placeholder(this.getId(), this.getPlaceholders(), this.getPlaceholderMap());
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public SplitNode getVisible() {
        return null;
    }

    @Override
    public boolean isOfUse() {
        if (!this.getAccess().isTreeAutoCleanupEnabled()) {
            return true;
        }
        return this.hasPlaceholders();
    }

    @Override
    public void visit(SplitNodeVisitor visitor) {
        visitor.handlePlaceholder(this);
    }

    @Override
    public void toString(int tabs, StringBuilder out) {
        out.append("Placeholder: ");
        boolean first = true;
        for (Path key : this.getPlaceholders()) {
            if (first) {
                first = false;
            } else {
                out.append(", ");
            }
            out.append(key);
        }
    }
}

