/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.layer;

import bibliothek.gui.DockStation;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.layer.LayerPriority;
import bibliothek.gui.dock.util.DockUtilities;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedLayerCollection {
    private Set<DockStation> stations = new HashSet<DockStation>();

    public void add(DockStation station) {
        this.stations.add(station);
    }

    public List<DockStation> sort(int x, int y) {
        HashMap<DockStation, Node> nodes = new HashMap<DockStation, Node>();
        for (DockStation station : this.stations) {
            nodes.put(station, new Node(station));
        }
        ArrayList<Node> roots = new ArrayList<Node>();
        for (Node node : nodes.values()) {
            if (node.register(nodes)) continue;
            roots.add(node);
        }
        for (Node root : roots) {
            root.modify();
        }
        List<DockStationDropLayer> layers = new ArrayList<DockStationDropLayer>();
        for (Node root : roots) {
            root.collect(layers, x, y);
        }
        layers = this.sort(layers);
        ArrayList<DockStation> result = new ArrayList<DockStation>();
        for (DockStationDropLayer layer : layers) {
            if (nodes.remove(layer.getStation()) == null) continue;
            result.add(layer.getStation());
        }
        return result;
    }

    protected List<DockStationDropLayer> sort(List<DockStationDropLayer> layers) {
        LinkedList<DockStationDropLayer> result = new LinkedList<DockStationDropLayer>();
        for (DockStationDropLayer layer : layers) {
            DockStationDropLayer resultLayer;
            int compare;
            int index = 0;
            Iterator i$ = result.iterator();
            while (i$.hasNext() && (compare = this.compare(resultLayer = (DockStationDropLayer)i$.next(), layer)) <= 0) {
                ++index;
            }
            result.add(index, layer);
        }
        return result;
    }

    protected int compare(DockStationDropLayer a, DockStationDropLayer b) {
        DockStation sb;
        LayerPriority pb;
        LayerPriority pa;
        int priority;
        if (a == b) {
            return 0;
        }
        boolean compareA = a.canCompare(b);
        boolean compareB = b.canCompare(a);
        if (compareA && compareB) {
            int resultA = -a.compare(b);
            int resultB = b.compare(a);
            if (resultA == 0) {
                return resultB;
            }
            if (resultB == 0) {
                return resultA;
            }
            if (resultA < 0 == resultB < 0) {
                return resultA;
            }
        }
        if ((priority = (pa = a.getPriority()).compareTo(pb = b.getPriority())) != 0) {
            return priority;
        }
        int reverse = pa.isReverse() ? -1 : 1;
        DockStation sa = a.getStation();
        if (DockUtilities.isAncestor(sa, sb = b.getStation())) {
            return 1 * reverse;
        }
        if (DockUtilities.isAncestor(sb, sa)) {
            return -1 * reverse;
        }
        Component compA = a.getComponent();
        Component compB = b.getComponent();
        if (compA != null && compB != null) {
            Window windowA = SwingUtilities.getWindowAncestor(compA);
            Window windowB = SwingUtilities.getWindowAncestor(compB);
            if (windowA != null && windowB != null) {
                if (windowA == windowB) {
                    if (DockUI.isOverlapping(compA, compB)) {
                        return -1 * reverse;
                    }
                    if (DockUI.isOverlapping(compB, compA)) {
                        return 1 * reverse;
                    }
                } else {
                    boolean mouseOverB;
                    if (this.isParent(windowA, windowB)) {
                        return 1 * reverse;
                    }
                    if (this.isParent(windowB, windowA)) {
                        return -1 * reverse;
                    }
                    boolean mouseOverA = windowA.getMousePosition() != null;
                    boolean bl = mouseOverB = windowB.getMousePosition() != null;
                    if (mouseOverA && !mouseOverB) {
                        return -1 * reverse;
                    }
                    if (!mouseOverA && mouseOverB) {
                        return 1 * reverse;
                    }
                }
            }
        }
        return 0;
    }

    private boolean isParent(Window parent, Window child) {
        for (Window temp = child.getOwner(); temp != null; temp = temp.getOwner()) {
            if (temp != parent) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Node {
        private Node parent;
        private List<Node> children;
        private DockStation station;
        private DockStationDropLayer[] layers;

        public Node(DockStation station) {
            this.station = station;
            if (station.getDockableCount() > 0) {
                this.children = new ArrayList<Node>(station.getDockableCount());
            }
            this.layers = station.getLayers();
        }

        public boolean register(Map<DockStation, Node> nodes) {
            Dockable child = this.station.asDockable();
            while (child != null) {
                DockStation station = child.getDockParent();
                if (station == null) {
                    return false;
                }
                Node node = nodes.get(station);
                if (node != null) {
                    node.children.add(this);
                    this.parent = node;
                    return true;
                }
                child = station.asDockable();
            }
            return false;
        }

        public DockStationDropLayer[] getLayers() {
            return this.layers;
        }

        public void modify() {
            if (this.children != null) {
                for (Node child : this.children) {
                    child.modify();
                }
            }
            Node parent = this.parent;
            while (parent != null) {
                for (int i = 0; i < this.layers.length; ++i) {
                    for (DockStationDropLayer layer : parent.getLayers()) {
                        this.layers[i] = layer.modify(this.layers[i]);
                    }
                }
                parent = parent.parent;
            }
        }

        public void collect(List<DockStationDropLayer> layers, int x, int y) {
            if (this.children != null) {
                for (Node child : this.children) {
                    child.collect(layers, x, y);
                }
            }
            for (DockStationDropLayer layer : this.layers) {
                if (!layer.contains(x, y)) continue;
                layers.add(layer);
            }
        }
    }
}

