/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.relocator;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.control.DockRelocator;
import bibliothek.gui.dock.control.DockRelocatorMode;
import bibliothek.gui.dock.control.relocator.DockRelocatorEvent;
import bibliothek.gui.dock.control.relocator.Inserter;
import bibliothek.gui.dock.control.relocator.Merger;
import bibliothek.gui.dock.control.relocator.VetoableDockRelocatorListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractDockRelocator
implements DockRelocator {
    private List<VetoableDockRelocatorListener> vetoableListeners = new ArrayList<VetoableDockRelocatorListener>();
    private DockController controller;
    private int dragDistance = 10;
    private boolean dragOnlyTitel = false;
    private List<DockRelocatorMode> modes = new ArrayList<DockRelocatorMode>();
    private Set<DockRelocatorMode> activeModes = new HashSet<DockRelocatorMode>();
    private Merger merger = null;
    private Inserter inserter = null;

    public AbstractDockRelocator(DockController controller) {
        if (controller == null) {
            throw new IllegalArgumentException("controller must not be null");
        }
        this.controller = controller;
    }

    public DockController getController() {
        return this.controller;
    }

    public void addVetoableDockRelocatorListener(VetoableDockRelocatorListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.vetoableListeners.add(listener);
    }

    public void removeVetoableDockRelocatorListener(VetoableDockRelocatorListener listener) {
        this.vetoableListeners.remove(listener);
    }

    protected VetoableDockRelocatorListener[] vetoableListeners() {
        return this.vetoableListeners.toArray(new VetoableDockRelocatorListener[this.vetoableListeners.size()]);
    }

    protected void fireGrabbing(DockRelocatorEvent event) {
        for (VetoableDockRelocatorListener listener : this.vetoableListeners()) {
            listener.grabbing(event);
        }
    }

    protected void fireGrabbed(DockRelocatorEvent event) {
        for (VetoableDockRelocatorListener listener : this.vetoableListeners()) {
            listener.grabbed(event);
        }
    }

    protected void fireSearched(DockRelocatorEvent event) {
        for (VetoableDockRelocatorListener listener : this.vetoableListeners()) {
            listener.searched(event);
        }
    }

    protected void fireDragged(DockRelocatorEvent event) {
        for (VetoableDockRelocatorListener listener : this.vetoableListeners()) {
            listener.dragged(event);
        }
    }

    protected void fireDragging(DockRelocatorEvent event) {
        for (VetoableDockRelocatorListener listener : this.vetoableListeners()) {
            listener.dragging(event);
        }
    }

    protected void fireDropping(DockRelocatorEvent event) {
        for (VetoableDockRelocatorListener listener : this.vetoableListeners()) {
            listener.dropping(event);
        }
    }

    protected void fireDropped(DockRelocatorEvent event) {
        for (VetoableDockRelocatorListener listener : this.vetoableListeners()) {
            listener.dropped(event);
        }
    }

    protected void fireCanceled(DockRelocatorEvent event) {
        for (VetoableDockRelocatorListener listener : this.vetoableListeners()) {
            listener.canceled(event);
        }
    }

    public boolean isDragOnlyTitel() {
        return this.dragOnlyTitel;
    }

    public void setDragOnlyTitel(boolean dragOnlyTitel) {
        this.dragOnlyTitel = dragOnlyTitel;
    }

    public int getDragDistance() {
        return this.dragDistance;
    }

    public void setDragDistance(int dragDistance) {
        this.dragDistance = dragDistance;
    }

    public Merger getMerger() {
        return this.merger;
    }

    public void setMerger(Merger merger) {
        this.merger = merger;
    }

    public void setInserter(Inserter inserter) {
        this.inserter = inserter;
    }

    public Inserter getInserter() {
        return this.inserter;
    }

    public void addMode(DockRelocatorMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Mode must not be null");
        }
        this.modes.add(mode);
    }

    public void removeMode(DockRelocatorMode mode) {
        if (this.activeModes.remove(mode)) {
            mode.setActive(this.controller, false);
        }
        this.modes.remove(mode);
    }

    protected void disableAllModes() {
        for (DockRelocatorMode mode : this.activeModes) {
            mode.setActive(this.controller, false);
        }
        this.activeModes.clear();
    }

    protected void checkModes(int modifiers) {
        for (DockRelocatorMode mode : this.modes) {
            boolean active = mode.shouldBeActive(this.controller, modifiers);
            if (active) {
                if (!this.activeModes.add(mode)) continue;
                mode.setActive(this.controller, true);
                continue;
            }
            if (!this.activeModes.remove(mode)) continue;
            mode.setActive(this.controller, false);
        }
    }
}

