/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.update.action;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.update.api.VersionNumbers;
import org.exbin.framework.update.gui.CheckForUpdatePanel;
import org.exbin.framework.update.preferences.CheckForUpdatePreferences;
import org.exbin.framework.update.service.CheckForUpdateService;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.CloseControlPanel;

@ParametersAreNonnullByDefault
public class CheckForUpdateAction
extends AbstractAction {
    public static final String ACTION_ID = "checkUpdateAction";
    private XBApplication application;
    private ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CheckForUpdateAction.class);
    private URL checkUpdateUrl;
    private VersionNumbers updateVersion;
    private URL downloadUrl;
    private CheckForUpdateService checkForUpdateService;

    public CheckForUpdateAction() {
        this.init();
    }

    private void init() {
        ActionUtils.setupAction((Action)this, (ResourceBundle)this.resourceBundle, (String)ACTION_ID);
        this.putValue("dialogMode", true);
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        CheckForUpdatePanel checkForUpdatePanel = new CheckForUpdatePanel();
        CloseControlPanel controlPanel = new CloseControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)checkForUpdatePanel, (JPanel)controlPanel);
        WindowUtils.addHeaderPanel((Window)dialog.getWindow(), checkForUpdatePanel.getClass(), (ResourceBundle)checkForUpdatePanel.getResourceBundle());
        frameModule.setDialogTitle(dialog, checkForUpdatePanel.getResourceBundle());
        controlPanel.setHandler(() -> ((WindowUtils.DialogWrapper)dialog).close());
        checkForUpdatePanel.setCheckForUpdateService(this.getCheckForUpdateService());
        checkForUpdatePanel.performCheckForUpdate();
        dialog.showCentered((Component)e.getSource());
        dialog.dispose();
    }

    @Nonnull
    public VersionNumbers getCurrentVersion() {
        ResourceBundle appBundle = this.application.getAppBundle();
        String releaseString = appBundle.getString("Application.release");
        VersionNumbers versionNumbers = new VersionNumbers();
        versionNumbers.versionFromString(releaseString);
        return versionNumbers;
    }

    public void setUpdateUrl(URL updateUrl) {
        this.checkUpdateUrl = updateUrl;
    }

    @Nullable
    public URL getUpdateUrl() {
        return this.checkUpdateUrl;
    }

    public void setCheckForUpdateService(CheckForUpdateService checkForUpdateService) {
        this.checkForUpdateService = checkForUpdateService;
    }

    @Nonnull
    public CheckForUpdateService getCheckForUpdateService() {
        return this.checkForUpdateService;
    }

    public void setUpdateVersion(VersionNumbers updateVersion) {
        this.updateVersion = updateVersion;
    }

    @Nullable
    public VersionNumbers getUpdateVersion() {
        return this.updateVersion;
    }

    @Nullable
    public URL getUpdateDownloadUrl() {
        return this.downloadUrl;
    }

    public void setUpdateDownloadUrl(URL downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public void checkOnStart(Frame frame) {
        CheckForUpdatePreferences checkForUpdateParameters = new CheckForUpdatePreferences(this.application.getAppPreferences());
        boolean checkOnStart = checkForUpdateParameters.isShouldCheckForUpdate();
        if (!checkOnStart) {
            return;
        }
        this.getCheckForUpdateService();
        CheckForUpdateService.CheckForUpdateResult checkForUpdateResult = this.checkForUpdateService.checkForUpdate();
        if (checkForUpdateResult == CheckForUpdateService.CheckForUpdateResult.UPDATE_FOUND) {
            FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
            CheckForUpdatePanel checkForUpdatePanel = new CheckForUpdatePanel();
            CloseControlPanel controlPanel = new CloseControlPanel();
            WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)checkForUpdatePanel, (JPanel)controlPanel);
            WindowUtils.addHeaderPanel((Window)dialog.getWindow(), checkForUpdatePanel.getClass(), (ResourceBundle)checkForUpdatePanel.getResourceBundle());
            frameModule.setDialogTitle(dialog, checkForUpdatePanel.getResourceBundle());
            controlPanel.setHandler(() -> ((WindowUtils.DialogWrapper)dialog).close());
            checkForUpdatePanel.setCheckForUpdateService(this.checkForUpdateService);
            checkForUpdatePanel.setCheckUpdatesResult(checkForUpdateResult);
            dialog.showCentered((Component)frame);
            dialog.dispose();
        }
    }
}

