/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.about;

import com.formdev.flatlaf.extras.FlatDesktop;
import java.awt.event.ActionEvent;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import javax.swing.JComponent;
import org.exbin.framework.about.action.AboutAction;
import org.exbin.framework.about.api.AboutModuleApi;
import org.exbin.framework.action.api.ActionModuleApi;
import org.exbin.framework.action.api.MenuGroup;
import org.exbin.framework.action.api.MenuPosition;
import org.exbin.framework.action.api.PositionMode;
import org.exbin.framework.action.api.SeparationMode;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.DesktopUtils;
import org.exbin.xbup.plugin.XBModuleHandler;

@ParametersAreNonnullByDefault
public class AboutModule
implements AboutModuleApi {
    private XBApplication application;
    private AboutAction aboutAction;
    private JComponent sideComponent = null;

    public void init(XBModuleHandler application) {
        this.application = (XBApplication)application;
    }

    public void unregisterModule(String moduleId) {
    }

    @Nonnull
    public Action getAboutAction() {
        if (this.aboutAction == null) {
            this.aboutAction = new AboutAction();
            this.aboutAction.setApplication(this.application);
            this.aboutAction.setAboutDialogSideComponent(this.sideComponent);
        }
        return this.aboutAction;
    }

    public void registerDefaultMenuItem() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        boolean aboutActionRegistered = false;
        if (DesktopUtils.detectBasicOs() == DesktopUtils.DesktopOs.MAC_OS) {
            FlatDesktop.setAboutHandler(() -> this.getAboutAction().actionPerformed(new ActionEvent(frameModule.getFrame(), 0, "")));
            aboutActionRegistered = true;
        }
        actionModule.registerMenuGroup(FrameModuleApi.HELP_MENU_ID, new MenuGroup(HELP_ABOUT_MENU_GROUP_ID, new MenuPosition(PositionMode.BOTTOM_LAST), aboutActionRegistered ? SeparationMode.NONE : SeparationMode.ABOVE));
        if (!aboutActionRegistered) {
            actionModule.registerMenuItem(FrameModuleApi.HELP_MENU_ID, MODULE_ID, this.getAboutAction(), new MenuPosition(HELP_ABOUT_MENU_GROUP_ID));
        }
    }

    public void setAboutDialogSideComponent(JComponent sideComponent) {
        this.sideComponent = sideComponent;
        if (this.aboutAction != null) {
            this.aboutAction.setAboutDialogSideComponent(sideComponent);
        }
    }
}

