/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.service.gui;

import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class EditConnectionPanel
extends JPanel {
    private static final int DEFAULT_PORT = 22594;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(EditConnectionPanel.class);
    private JLabel connectionHostLabel;
    private JTextField connectionHostTextField;
    private JLabel connectionPortLabel;
    private JSpinner connectionPortSpinner;

    public EditConnectionPanel() {
        this.initComponents();
        this.connectionPortSpinner.setValue(22594);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    private void initComponents() {
        this.connectionHostLabel = new JLabel();
        this.connectionPortSpinner = new JSpinner();
        this.connectionPortLabel = new JLabel();
        this.connectionHostTextField = new JTextField();
        this.connectionHostLabel.setText(this.resourceBundle.getString("connectionHostLabel.text"));
        this.connectionPortLabel.setText(this.resourceBundle.getString("connectionPortLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.connectionHostTextField, GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.connectionPortLabel).addComponent(this.connectionPortSpinner, -2, 88, -2).addComponent(this.connectionHostLabel)).addGap(0, 217, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.connectionHostLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.connectionHostTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.connectionPortLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.connectionPortSpinner, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new EditConnectionPanel());
    }

    @Nonnull
    public String getConnection() {
        return this.connectionHostTextField.getText() + ":" + String.valueOf((Integer)this.connectionPortSpinner.getValue());
    }

    public void setConnection(String string) {
        int colonPos = string.indexOf(":");
        this.connectionHostTextField.setText(string.substring(0, colonPos));
        this.connectionPortSpinner.setValue(Integer.valueOf(string.substring(colonPos + 1)));
    }
}

