/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.preferences;

import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.api.Preferences;

@ParametersAreNonnullByDefault
public class PreferencesWrapper
implements Preferences {
    private final java.util.prefs.Preferences preferences;

    public PreferencesWrapper(java.util.prefs.Preferences preferences) {
        this.preferences = preferences;
    }

    public boolean exists(String key) {
        return this.preferences.get(key, null) != null;
    }

    @Nonnull
    public Optional<String> get(String key) {
        return Optional.ofNullable(this.preferences.get(key, null));
    }

    @Nonnull
    public String get(String key, String def) {
        return this.preferences.get(key, def);
    }

    public void remove(String key) {
        this.preferences.remove(key);
    }

    public void putInt(String key, int value) {
        this.preferences.putInt(key, value);
    }

    public int getInt(String key, int def) {
        return this.preferences.getInt(key, def);
    }

    public void putLong(String key, long value) {
        this.preferences.putLong(key, value);
    }

    public long getLong(String key, long def) {
        return this.preferences.getLong(key, def);
    }

    public void putBoolean(String key, boolean value) {
        this.preferences.putBoolean(key, value);
    }

    public boolean getBoolean(String key, boolean def) {
        return this.preferences.getBoolean(key, def);
    }

    public void putFloat(String key, float value) {
        this.preferences.putFloat(key, value);
    }

    public float getFloat(String key, float def) {
        return this.preferences.getFloat(key, def);
    }

    public void putDouble(String key, double value) {
        this.preferences.putDouble(key, value);
    }

    public double getDouble(String key, double def) {
        return this.preferences.getDouble(key, def);
    }

    public void putByteArray(String key, byte[] value) {
        this.preferences.putByteArray(key, value);
    }

    @Nonnull
    public byte[] getByteArray(String key, byte[] def) {
        return this.preferences.getByteArray(key, def);
    }

    public void put(String key, @Nullable String value) {
        if (value == null) {
            this.preferences.remove(key);
        } else {
            this.preferences.put(key, value);
        }
    }

    public void flush() {
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(PreferencesWrapper.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void sync() {
        try {
            this.preferences.sync();
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(PreferencesWrapper.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Nonnull
    public java.util.prefs.Preferences getInnerPreferences() {
        return this.preferences;
    }
}

