/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.frame;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.exbin.framework.action.api.ActionModuleApi;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.ApplicationExitHandler;
import org.exbin.framework.frame.FrameModule;
import org.exbin.framework.frame.api.ApplicationFrameHandler;
import org.exbin.framework.utils.gui.WindowHeaderPanel;

@ParametersAreNonnullByDefault
public class XBApplicationFrame
extends JFrame
implements ApplicationFrameHandler,
WindowHeaderPanel.WindowHeaderDecorationProvider {
    private XBApplication application;
    private ApplicationExitHandler exitHandler;
    private JPanel currentStatusBarPanel = null;
    private boolean captionsVisible = true;
    private WindowHeaderPanel.WindowHeaderDecorationProvider windowHeaderDecorationProvider;
    private JProgressBar busyProgressBar;
    private JPanel busyStatusPanel;
    private JPanel mainStatusPanel;
    private JMenuBar menuBar;
    private JPanel progressStatusPanel;
    private JPanel statusBar;
    private JLabel statusLabel;
    private JPanel statusPanel;
    private JProgressBar statusProgressBar;
    private JButton stopProgressButton;
    private JToolBar toolBar;

    public XBApplicationFrame() {
        this.initComponents();
        UIManager.addPropertyChangeListener(evt -> SwingUtilities.updateComponentTreeUI(this));
    }

    private void initComponents() {
        this.mainStatusPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.progressStatusPanel = new JPanel();
        this.statusProgressBar = new JProgressBar();
        this.stopProgressButton = new JButton();
        this.busyStatusPanel = new JPanel();
        this.busyProgressBar = new JProgressBar();
        this.toolBar = new JToolBar();
        this.statusBar = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusPanel = new JPanel();
        this.menuBar = new JMenuBar();
        this.mainStatusPanel.setLayout(new FlowLayout(0));
        this.mainStatusPanel.add(this.statusLabel);
        this.statusProgressBar.setIndeterminate(true);
        this.statusProgressBar.setMinimumSize(new Dimension(10, 10));
        this.statusProgressBar.setRequestFocusEnabled(false);
        this.statusProgressBar.setStringPainted(true);
        this.stopProgressButton.setText("Stop");
        this.stopProgressButton.setEnabled(false);
        this.stopProgressButton.setMinimumSize(new Dimension(67, 15));
        this.stopProgressButton.setPreferredSize(new Dimension(75, 20));
        GroupLayout progressStatusPanelLayout = new GroupLayout(this.progressStatusPanel);
        this.progressStatusPanel.setLayout(progressStatusPanelLayout);
        progressStatusPanelLayout.setHorizontalGroup(progressStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, progressStatusPanelLayout.createSequentialGroup().addComponent(this.statusProgressBar, -1, 319, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stopProgressButton, -2, 75, -2)));
        progressStatusPanelLayout.setVerticalGroup(progressStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.stopProgressButton, -1, -1, Short.MAX_VALUE).addComponent(this.statusProgressBar, -1, -1, Short.MAX_VALUE));
        this.busyStatusPanel.setLayout(new BorderLayout());
        this.busyProgressBar.setIndeterminate(true);
        this.busyProgressBar.setRequestFocusEnabled(false);
        this.busyProgressBar.setStringPainted(true);
        this.busyStatusPanel.add((Component)this.busyProgressBar, "Center");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                XBApplicationFrame.this.formWindowClosing(evt);
            }

            @Override
            public void windowClosed(WindowEvent evt) {
                XBApplicationFrame.this.formWindowClosed(evt);
            }
        });
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setFocusable(false);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.statusBar.setLayout(new BorderLayout());
        this.statusBar.add((Component)statusPanelSeparator, "North");
        this.statusPanel.setPreferredSize(new Dimension(649, 26));
        this.statusPanel.setRequestFocusEnabled(false);
        this.statusPanel.setLayout(new BorderLayout());
        this.statusBar.add((Component)this.statusPanel, "Center");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void formWindowClosed(WindowEvent evt) {
        if (this.exitHandler == null) {
            System.exit(0);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.exitHandler != null) {
            this.exitHandler.executeExit(this);
        } else {
            this.dispose();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(() -> {
            XBApplicationFrame frame = new XBApplicationFrame();
            frame.setVisible(true);
        });
    }

    @Nonnull
    public Frame getFrame() {
        return this;
    }

    public boolean isToolBarVisible() {
        return this.toolBar.isVisible();
    }

    public void setToolBarVisible(boolean toolBarVisible) {
        this.toolBar.setVisible(toolBarVisible);
    }

    public boolean isStatusBarVisible() {
        return this.statusBar.isVisible();
    }

    public void setStatusBarVisible(boolean statusBarVisible) {
        this.statusBar.setVisible(statusBarVisible);
    }

    public boolean isToolBarCaptionsVisible() {
        return this.captionsVisible;
    }

    public void setToolBarCaptionsVisible(boolean captionsVisible) {
        Component[] comps;
        this.captionsVisible = captionsVisible;
        for (Component comp : comps = this.toolBar.getComponents()) {
            if (comp instanceof JButton) {
                ((JButton)comp).setHideActionText(!captionsVisible);
                continue;
            }
            if (comp instanceof JToggleButton) {
                ((JToggleButton)comp).setHideActionText(!captionsVisible);
                continue;
            }
            if (comp instanceof JRadioButton) {
                ((JRadioButton)comp).setHideActionText(!captionsVisible);
                continue;
            }
            if (!(comp instanceof JCheckBoxMenuItem)) continue;
            ((JCheckBoxMenuItem)comp).setHideActionText(!captionsVisible);
        }
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        ResourceBundle appBundle = application.getAppBundle();
        this.setTitle(appBundle.getString("Application.name"));
        if (appBundle.containsKey("Application.icon")) {
            this.setIconImage(new ImageIcon(this.getClass().getResource(application.getAppBundle().getString("Application.icon"))).getImage());
        }
    }

    public void setMainPanel(Component component) {
        this.getContentPane().add(component, "Center");
    }

    public void loadMainMenu(XBApplication application) {
        ActionModuleApi actionModule = (ActionModuleApi)application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.buildMenu(this.menuBar, FrameModule.MAIN_MENU_ID);
    }

    public void loadMainToolBar(XBApplication application) {
        ActionModuleApi actionModule = (ActionModuleApi)application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.buildToolBar(this.toolBar, FrameModule.MAIN_TOOL_BAR_ID);
    }

    public void showFrame() {
        this.setVisible(true);
    }

    public void switchStatusBar(@Nullable JPanel panel) {
        if (this.currentStatusBarPanel != null) {
            this.statusPanel.remove(this.currentStatusBarPanel);
        }
        if (panel != null) {
            this.statusPanel.add(panel);
        }
        this.statusPanel.invalidate();
        this.currentStatusBarPanel = panel;
    }

    public void setDefaultSize(Dimension windowSize) {
        String rectangleString;
        if (this.application != null && !(rectangleString = this.application.getAppPreferences().get("frameRectangle", "")).isEmpty()) {
            String[] split = rectangleString.split("[,]");
            Rectangle rect = new Rectangle(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]));
            this.setBounds(rect);
            return;
        }
        this.setSize(windowSize);
        this.setLocationRelativeTo(null);
    }

    public void setApplicationExitHandler(ApplicationExitHandler exitHandler) {
        this.exitHandler = exitHandler;
    }

    public void setWindowHeaderDecorationProvider(WindowHeaderPanel.WindowHeaderDecorationProvider windowHeaderDecorationProvider) {
        this.windowHeaderDecorationProvider = windowHeaderDecorationProvider;
    }

    public void setHeaderDecoration(WindowHeaderPanel windowHeaderPanel) {
        if (this.windowHeaderDecorationProvider != null) {
            this.windowHeaderDecorationProvider.setHeaderDecoration(windowHeaderPanel);
        }
    }
}

