/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.audio.wave;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.auxiliary.binary_data.paged.PagedData;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.param.XBSerializationMode;
import org.exbin.xbup.core.type.XBData;
import org.exbin.xbup.core.ubnumber.UBNatural;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

public class XBWave
implements XBPSequenceSerializable {
    public static final long[] XBUP_BLOCKREV_CATALOGPATH = new long[]{1L, 5L, 0L, 0L};
    public static final long[] XBUP_FORMATREV_CATALOGPATH = new long[]{1L, 5L, 0L, 0L};
    private AudioFormat audioFormat;
    private final XBData data = new XBData(65520);

    public XBWave() {
        this.audioFormat = null;
    }

    public XBWave(AudioFormat audioFormat) {
        this.audioFormat = audioFormat;
    }

    public void loadFromFile(File soundFile) {
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(soundFile);
            this.audioFormat = audioInputStream.getFormat();
            System.out.println(this.getAudioFormat());
            if (this.audioFormat.getChannels() > 2 || this.audioFormat.getEncoding() != AudioFormat.Encoding.PCM_SIGNED && this.audioFormat.getSampleSizeInBits() != 8 || this.audioFormat.getEncoding() != AudioFormat.Encoding.PCM_SIGNED && this.audioFormat.getEncoding() != AudioFormat.Encoding.PCM_UNSIGNED && this.audioFormat.getSampleSizeInBits() == 8 || this.audioFormat.getSampleSizeInBits() != 8 && this.audioFormat.getSampleSizeInBits() != 16 && this.audioFormat.getSampleSizeInBits() != 24 && this.audioFormat.getSampleSizeInBits() != 32) {
                System.out.println("Unable to load! Currently only 44kHz SIGNED 16bit Mono/Stereo is supported.");
                return;
            }
            this.data.loadFromStream((InputStream)audioInputStream);
        }
        catch (IOException | UnsupportedAudioFileException ex) {
            Logger.getLogger(XBWave.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void saveToFile(File soundFile) {
        this.saveToFile(soundFile, AudioFileFormat.Type.WAVE);
    }

    public void saveToFile(File soundFile, AudioFileFormat.Type fileType) {
        try {
            AudioSystem.write(new AudioInputStream(this.data.getDataInputStream(), this.audioFormat, this.getLengthInTicks()), fileType, soundFile);
        }
        catch (IOException ex) {
            Logger.getLogger(XBWave.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void serializeXB(XBPSequenceSerialHandler serial) throws XBProcessingException, IOException {
        serial.begin();
        serial.matchType((XBBlockType)new XBDeclBlockType(XBUP_BLOCKREV_CATALOGPATH));
        if (serial.getSerializationMode() == XBSerializationMode.PULL) {
            UBNatural sampleRate = serial.pullAttribute().convertToNatural();
            UBNatural sampleSizeInBits = serial.pullAttribute().convertToNatural();
            UBNatural channels = serial.pullAttribute().convertToNatural();
            UBNatural signed = serial.pullAttribute().convertToNatural();
            UBNatural bigEndian = serial.pullAttribute().convertToNatural();
            this.audioFormat = new AudioFormat(sampleRate.getInt(), sampleSizeInBits.getInt(), channels.getInt(), signed.getInt() == 1, bigEndian.getInt() == 1);
        } else {
            serial.putAttribute((XBAttribute)new UBNat32((long)this.audioFormat.getSampleRate()));
            serial.putAttribute((XBAttribute)new UBNat32(this.audioFormat.getSampleSizeInBits()));
            serial.putAttribute((XBAttribute)new UBNat32(this.audioFormat.getChannels()));
            serial.putAttribute((XBAttribute)new UBNat32(this.audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED ? 1 : 0));
            serial.putAttribute((XBAttribute)new UBNat32(this.audioFormat.isBigEndian() ? 1 : 0));
        }
        serial.consist((XBSerializable)new XBPSequenceSerializable(){

            public void serializeXB(XBPSequenceSerialHandler serial) throws XBProcessingException, IOException {
                serial.begin();
                if (serial.getSerializationMode() == XBSerializationMode.PULL) {
                    XBWave.this.data.loadFromStream(serial.pullData());
                } else {
                    serial.putData(XBWave.this.data.getDataInputStream());
                }
                serial.end();
            }
        });
        serial.end();
    }

    public void performTransformReverse() {
        this.performTransformReverse(0L, this.getLengthInTicks() - 1);
    }

    public void performTransformReverse(long startPosition, long endPosition) {
        if (!this.data.isEmpty()) {
            long startDataPos = startPosition * (long)this.audioFormat.getChannels() * 2L;
            long endDataPos = endPosition * (long)this.audioFormat.getChannels() * 2L;
            int sampleSize = this.audioFormat.getSampleSizeInBits() / 8;
            byte[] buffer = new byte[sampleSize];
            int headBlockIndex = (int)(startDataPos / (long)this.data.getPageSize());
            int headPosition = (int)(startDataPos % (long)this.data.getPageSize());
            byte[] headBlock = this.data.getPage(headBlockIndex);
            int tailBlockIndex = (int)(endDataPos / (long)this.data.getPageSize());
            int tailPosition = (int)(endDataPos % (long)this.data.getPageSize());
            byte[] tailBlock = this.data.getPage(tailBlockIndex);
            for (long remaining = endPosition - startPosition; remaining > 0L; --remaining) {
                if (headPosition + sampleSize <= this.data.getPageSize()) {
                    System.arraycopy(headBlock, headPosition, buffer, 0, sampleSize);
                    headPosition += sampleSize;
                } else {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
                if (tailPosition >= sampleSize) {
                    System.arraycopy(tailBlock, tailPosition - sampleSize, headBlock, headPosition - sampleSize, sampleSize);
                    System.arraycopy(buffer, 0, tailBlock, tailPosition - sampleSize, sampleSize);
                    tailPosition -= sampleSize;
                } else {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
                if (headPosition == this.data.getPageSize()) {
                    headPosition = 0;
                    headBlock = this.data.getPage(++headBlockIndex);
                }
                if (tailPosition != 0) continue;
                tailPosition = this.data.getPageSize();
                tailBlock = this.data.getPage(--tailBlockIndex);
            }
        }
    }

    public int getPageSize() {
        return this.data.getPageSize();
    }

    public InputStream getInputStream() {
        return this.data.getDataInputStream();
    }

    public AudioInputStream getAudioInputStream() {
        return new AudioInputStream(this.data.getDataInputStream(), this.audioFormat, this.getLengthInTicks());
    }

    public long getDataSize() {
        return this.data.getDataSize();
    }

    public void getValue(EditableBinaryData targetData, int position, int channel) {
        int bytesPerSample = this.audioFormat.getSampleSizeInBits() >> 3;
        int dataPosition = (position * this.audioFormat.getChannels() + channel) * bytesPerSample;
        targetData.replace(0L, (BinaryData)this.data, (long)dataPosition, (long)bytesPerSample);
    }

    public int getRatioValue(int position, int channel, int height) {
        int bytesPerSample = this.audioFormat.getSampleSizeInBits() >> 3;
        int chunk = (position * this.audioFormat.getChannels() + channel) * bytesPerSample / this.data.getPageSize();
        int offset = (position * this.audioFormat.getChannels() + channel) * bytesPerSample % this.data.getPageSize();
        long value = this.audioFormat.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED ? (long)(this.data.getPage(chunk)[offset] & 0xFF) : (long)this.data.getPage(chunk)[offset];
        if (bytesPerSample > 1) {
            value += (long)(this.data.getPage(chunk)[offset + 1] + 127) << 8;
            if (bytesPerSample > 2) {
                value += (long)(this.data.getPage(chunk)[offset + 2] + 127) << 16;
                if (bytesPerSample > 3) {
                    value += (long)(this.data.getPage(chunk)[offset + 3] + 127) << 24;
                }
            }
        }
        return (int)(value * (long)height >> this.audioFormat.getSampleSizeInBits());
    }

    public void setValue(BinaryData sourceData, int position, int channel) {
        int bytesPerSample = this.audioFormat.getSampleSizeInBits() >> 3;
        int dataPosition = (position * this.audioFormat.getChannels() + channel) * bytesPerSample;
        this.data.replace((long)dataPosition, sourceData, 0L, (long)bytesPerSample);
    }

    public void setRatioValue(int pos, int value, int channel, int height) {
        int chunk = (pos * this.audioFormat.getChannels() + channel) * 2 / this.data.getPageSize();
        int offset = (pos * this.audioFormat.getChannels() + channel) * 2 % this.data.getPageSize();
        byte[] block = this.data.getPage(chunk);
        int pomValue = (value - height / 2 << 16) / height;
        block[offset] = (byte)(pomValue & 0xFF);
        block[offset + 1] = (byte)(pomValue >> 8 & 0xFF);
        this.data.replace((long)chunk * (long)this.data.getPageSize(), block);
    }

    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    public int getLengthInTicks() {
        int bytesPerSample = this.audioFormat.getSampleSizeInBits() >> 3;
        return (int)this.data.getDataSize() / (this.audioFormat.getChannels() * bytesPerSample);
    }

    public void setLengthInTicks(int ticks) {
        int bytesPerSample = this.audioFormat.getSampleSizeInBits() >> 3;
        this.data.setDataSize((long)(ticks * this.audioFormat.getChannels() * bytesPerSample));
    }

    public void append(byte[] data) {
    }

    public void apendTo(XBWave wave) {
        this.apendTo(wave, 0, this.getLengthInTicks());
    }

    public void apendTo(XBWave wave, int start, int length) {
    }

    public byte[] readChunk(int start, int length) {
        boolean pos = false;
        return null;
    }

    public BinaryData cutData(int startPosition, int length) {
        long startDataPos = startPosition * this.audioFormat.getChannels() * 2;
        long dataLength = length * this.audioFormat.getChannels() * 2;
        PagedData cutData = this.data.copy(startDataPos, dataLength);
        this.data.remove(startDataPos, dataLength);
        return cutData;
    }

    public void insertData(BinaryData deletedData, int startPosition) {
        long startDataPos = startPosition * this.audioFormat.getChannels() * 2;
        this.data.insert(startDataPos, deletedData);
    }

    public XBWave copy(int startPosition, int length) {
        long startDataPos = startPosition * this.audioFormat.getChannels() * 2;
        long dataLength = length * this.audioFormat.getChannels() * 2;
        XBWave waveCopy = new XBWave();
        waveCopy.audioFormat = this.audioFormat;
        waveCopy.data.insert(0L, (BinaryData)this.data, startDataPos, dataLength);
        return waveCopy;
    }

    public void insertWave(XBWave pastedWave, int startPosition) {
        this.insertData((BinaryData)pastedWave.data, startPosition);
    }
}

