/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.exbin.bined.SelectionRange;

public class CodeAreaSelection {
    private long start;
    private long end;

    public CodeAreaSelection() {
        this(0L, 0L);
    }

    public CodeAreaSelection(long start, long end) {
        this.setStart(start);
        this.setEnd(end);
    }

    public CodeAreaSelection(@Nullable SelectionRange selectionRange) {
        if (selectionRange == null) {
            this.end = 0L;
            this.start = 0L;
        } else {
            this.start = selectionRange.getStart();
            this.end = selectionRange.getEnd();
        }
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getFirst() {
        return Math.min(this.start, this.end);
    }

    public long getLast() {
        return this.start < this.end ? this.end - 1L : this.start - 1L;
    }

    public long getLength() {
        return this.start < this.end ? this.end - this.start : this.start - this.end;
    }

    public boolean isEmpty() {
        return this.start == this.end;
    }

    public boolean isInSelection(long position) {
        return this.start < this.end ? position >= this.start && position < this.end : position >= this.end && position < this.start;
    }

    @Nonnull
    public SelectionRange getRange() {
        return new SelectionRange(this.start, this.end);
    }

    public void setStart(long start) {
        if (start < 0L) {
            throw new IllegalArgumentException("Selection with negative range start (" + start + ") is not allowed");
        }
        this.start = start;
    }

    public void setEnd(long end) {
        if (this.start < 0L) {
            throw new IllegalArgumentException("Selection with negative range end (" + end + ") is not allowed");
        }
        this.end = end;
    }

    public void setSelection(@Nullable SelectionRange selectionRange) {
        if (selectionRange == null) {
            this.end = 0L;
            this.start = 0L;
        } else {
            this.setStart(selectionRange.getStart());
            this.setEnd(selectionRange.getEnd());
        }
    }

    public void setSelection(long start, long end) {
        this.setStart(start);
        this.setEnd(end);
    }

    public void clearSelection() {
        this.end = this.start;
    }

    public void setRange(SelectionRange selectionRange) {
        this.start = selectionRange.getStart();
        this.end = selectionRange.getEnd();
    }
}

