/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.audio.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.xbup.audio.swing.renderer.DotsRenderer;
import org.exbin.xbup.audio.swing.renderer.IntegralRenderer;
import org.exbin.xbup.audio.swing.renderer.LineRenderer;
import org.exbin.xbup.audio.swing.renderer.XBWavePanelRenderer;
import org.exbin.xbup.audio.wave.XBWave;
import org.exbin.xbup.core.type.XBData;

public class XBWavePanel
extends JPanel {
    private XBWave wave;
    private List<XBWave> zoomCache = new ArrayList<XBWave>();
    private int windowPosition;
    private int cursorPosition;
    private SelectionRange selection;
    private DrawMode drawMode;
    private ToolMode toolMode;
    private double scaleRatio = 1.0;
    private SelectionChangedListener selectionChangedListener = null;
    private ZoomChangedListener zoomChangedListener = null;
    private XBWavePanelRenderer renderer = new DotsRenderer();
    private Color waveColor;
    private Color waveFillColor;
    private Color selectionColor;
    private Color cursorWaveColor;
    private Color cursorColor;
    boolean mouseDown = false;
    int mousePressPosition;
    int wavePosition;

    public XBWavePanel() {
        super.setBackground(Color.WHITE);
        super.repaint();
        super.setOpaque(true);
        this.drawMode = DrawMode.DOTS_MODE;
        this.toolMode = ToolMode.SELECTION;
        this.cursorPosition = 0;
        this.selectionColor = UIManager.getColor("TextArea.selectionBackground");
        this.waveColor = UIManager.getColor("TextArea.foreground");
        this.waveFillColor = UIManager.getColor("TextArea.foreground").brighter().brighter();
        this.cursorColor = UIManager.getColor("TextArea.caretForeground");
        this.cursorWaveColor = new Color(255 - this.waveColor.getRed(), 255 - this.waveColor.getGreen(), 255 - this.waveColor.getBlue());
        if (this.selectionColor == null) {
            this.selectionColor = Color.LIGHT_GRAY;
        }
        super.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (me.getButton() == 1) {
                    if (XBWavePanel.this.toolMode == ToolMode.SELECTION) {
                        if ((me.getModifiersEx() & 0x40) > 0) {
                            XBWavePanel.this.setCursorPosition((int)((double)me.getX() / XBWavePanel.this.scaleRatio) + XBWavePanel.this.windowPosition);
                            if (XBWavePanel.this.getCursorPosition() > XBWavePanel.this.mousePressPosition) {
                                XBWavePanel.this.selection = new SelectionRange(XBWavePanel.this.mousePressPosition, XBWavePanel.this.getCursorPosition());
                            } else {
                                XBWavePanel.this.selection = new SelectionRange(XBWavePanel.this.getCursorPosition(), XBWavePanel.this.mousePressPosition);
                            }
                        } else {
                            XBWavePanel.this.clearSelection();
                            int oldPosition = XBWavePanel.this.getCursorPosition();
                            XBWavePanel.this.setCursorPosition((int)((double)me.getX() / XBWavePanel.this.scaleRatio) + XBWavePanel.this.windowPosition);
                            XBWavePanel.this.mousePressPosition = XBWavePanel.this.getCursorPosition();
                        }
                        XBWavePanel.this.repaint();
                    } else if (XBWavePanel.this.toolMode == ToolMode.PENCIL) {
                        XBWavePanel.this.wavePosition = (int)((double)me.getX() / XBWavePanel.this.scaleRatio);
                        int channel = 0;
                        if (me.getY() > XBWavePanel.this.getHeight() / 2) {
                            channel = 1;
                        }
                        XBWavePanel.this.wave.setRatioValue(XBWavePanel.this.wavePosition + XBWavePanel.this.windowPosition, me.getY() - XBWavePanel.this.getHeight() / 2 * channel, channel, XBWavePanel.this.getHeight() / 2);
                        XBWavePanel.this.repaint();
                        XBWavePanel.this.mousePressPosition = XBWavePanel.this.getCursorPosition();
                    }
                }
                XBWavePanel.this.mouseDown = true;
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                XBWavePanel.this.mouseDown = false;
            }
        });
        super.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent me) {
                if (XBWavePanel.this.mouseDown) {
                    if (XBWavePanel.this.toolMode == ToolMode.SELECTION) {
                        XBWavePanel.this.setCursorPosition((int)((double)me.getX() / XBWavePanel.this.scaleRatio) + XBWavePanel.this.windowPosition);
                        if (XBWavePanel.this.selection != null || XBWavePanel.this.getCursorPosition() > XBWavePanel.this.mousePressPosition + 3 || XBWavePanel.this.getCursorPosition() < XBWavePanel.this.mousePressPosition - 3) {
                            if (XBWavePanel.this.getCursorPosition() > XBWavePanel.this.mousePressPosition) {
                                XBWavePanel.this.selection = new SelectionRange(XBWavePanel.this.mousePressPosition, XBWavePanel.this.getCursorPosition());
                            } else {
                                XBWavePanel.this.selection = new SelectionRange(XBWavePanel.this.getCursorPosition(), XBWavePanel.this.mousePressPosition);
                            }
                            if (XBWavePanel.this.selectionChangedListener != null) {
                                XBWavePanel.this.selectionChangedListener.selectionChanged();
                            }
                            XBWavePanel.this.repaint();
                        }
                    } else if (XBWavePanel.this.toolMode == ToolMode.PENCIL) {
                        int endPosition;
                        int startPosition = (int)((double)me.getX() / XBWavePanel.this.scaleRatio) + XBWavePanel.this.windowPosition;
                        if (XBWavePanel.this.wavePosition < startPosition) {
                            endPosition = startPosition;
                            startPosition = XBWavePanel.this.wavePosition;
                        } else {
                            endPosition = XBWavePanel.this.wavePosition;
                        }
                        int channel = 0;
                        if (me.getY() >= XBWavePanel.this.getHeight() / 2) {
                            channel = 1;
                        }
                        for (int drawPosition = startPosition; drawPosition <= endPosition; ++drawPosition) {
                            XBWavePanel.this.wave.setRatioValue(drawPosition, me.getY() - XBWavePanel.this.getHeight() / 2 * channel, channel, XBWavePanel.this.getHeight() / 2);
                        }
                        XBWavePanel.this.repaint();
                        XBWavePanel.this.wavePosition = (int)((double)me.getX() / XBWavePanel.this.scaleRatio) + XBWavePanel.this.windowPosition;
                    }
                }
            }
        });
        super.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int position = XBWavePanel.this.windowPosition + (int)((double)e.getPoint().x / XBWavePanel.this.scaleRatio);
                if (e.getWheelRotation() == 1) {
                    XBWavePanel.this.setScaleRatio(XBWavePanel.this.scaleRatio * 2.0);
                    position -= (int)((double)e.getPoint().x / XBWavePanel.this.scaleRatio);
                } else if (e.getWheelRotation() == -1) {
                    XBWavePanel.this.setScaleRatio(XBWavePanel.this.scaleRatio / 2.0);
                    position -= (int)((double)e.getPoint().x / XBWavePanel.this.scaleRatio);
                }
                if (position < 0) {
                    position = 0;
                }
                if (XBWavePanel.this.zoomChangedListener != null) {
                    XBWavePanel.this.zoomChangedListener.zoomChanged();
                }
                XBWavePanel.this.setWindowPosition(position);
                XBWavePanel.this.repaint();
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle clipBounds = g.getClipBounds();
        int begin = clipBounds.x;
        int end = clipBounds.x + clipBounds.width;
        int selectionBegin = this.selection == null ? -1 : (int)((double)(this.selection.begin - this.windowPosition) * this.scaleRatio);
        int selectionEnd = this.selection == null ? -1 : (int)Math.ceil((double)(this.selection.end - this.windowPosition) * this.scaleRatio);
        int cursorAdjusted = (int)((double)(this.cursorPosition - this.windowPosition) * this.scaleRatio);
        int cursorBegin = cursorAdjusted - 1;
        int cursorEnd = cursorAdjusted + 1;
        while (begin <= end) {
            int section = end;
            if (selectionBegin > begin && selectionBegin <= section) {
                section = selectionBegin - 1;
            }
            if (selectionEnd >= begin && selectionEnd < section) {
                section = selectionEnd;
            }
            if (cursorBegin > begin && cursorBegin <= section) {
                section = cursorBegin - 1;
            }
            if (cursorEnd >= begin && cursorEnd < section) {
                section = cursorEnd;
            }
            XBWavePanelRenderer.RenderType rendererType = begin >= cursorBegin && begin <= cursorEnd ? XBWavePanelRenderer.RenderType.CURSOR : (begin >= selectionBegin && begin <= selectionEnd ? XBWavePanelRenderer.RenderType.SELECTION : XBWavePanelRenderer.RenderType.NORMAL);
            this.renderer.paint(g, this, begin, section + 1, rendererType);
            begin = section + 1;
        }
    }

    public XBWave getWave() {
        return this.wave;
    }

    public List<XBWave> getZoomCache() {
        return this.zoomCache;
    }

    public SelectionRange getSelection() {
        return this.selection;
    }

    public void setWave(XBWave wave) {
        this.wave = wave;
        this.rebuildZoomCache();
        this.repaint();
    }

    public DrawMode getDrawMode() {
        return this.drawMode;
    }

    public void setDrawMode(DrawMode drawMode) {
        this.drawMode = drawMode;
        switch (drawMode) {
            case DOTS_MODE: {
                this.renderer = new DotsRenderer();
                break;
            }
            case LINE_MODE: {
                this.renderer = new LineRenderer();
                break;
            }
            case INTEGRAL_MODE: {
                this.renderer = new IntegralRenderer();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.repaint();
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(int position) {
        this.cursorPosition = position;
    }

    public int getWaveWidth() {
        return this.wave == null ? 0 : (int)((double)this.wave.getLengthInTicks() * this.scaleRatio);
    }

    public int getWaveLength() {
        return this.wave == null ? 0 : this.wave.getLengthInTicks();
    }

    public ToolMode getToolMode() {
        return this.toolMode;
    }

    public void setToolMode(ToolMode toolMode) {
        this.toolMode = toolMode;
    }

    public Color getWaveColor() {
        return this.waveColor;
    }

    public void setWaveColor(Color waveColor) {
        this.waveColor = waveColor;
    }

    public Color getWaveFillColor() {
        return this.waveFillColor;
    }

    public void setWaveFillColor(Color waveFillColor) {
        this.waveFillColor = waveFillColor;
    }

    public Color getCursorColor() {
        return this.cursorColor;
    }

    public void setCursorColor(Color cursorColor) {
        this.cursorColor = cursorColor;
    }

    public Color getCursorWaveColor() {
        return this.cursorWaveColor;
    }

    public void setCursorWaveColor(Color cursorWaveColor) {
        this.cursorWaveColor = cursorWaveColor;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color selectionColor) {
        this.selectionColor = selectionColor;
    }

    public double getScaleRatio() {
        return this.scaleRatio;
    }

    public void setScaleRatio(double scaleRatio) {
        this.scaleRatio = scaleRatio;
    }

    public int getWindowPosition() {
        return this.windowPosition;
    }

    public void setWindowPosition(int windowPosition) {
        this.windowPosition = windowPosition;
    }

    public void rebuildZoomCache() {
        int level;
        this.zoomCache.clear();
        int numberOflevels = 2;
        if (this.wave == null) {
            return;
        }
        int lengthInTicks = this.wave.getLengthInTicks();
        ZoomLevelRecord[] levelRecords = new ZoomLevelRecord[numberOflevels];
        for (level = 0; level < numberOflevels; ++level) {
            levelRecords[level] = new ZoomLevelRecord(this.wave, lengthInTicks, level + 1);
        }
        for (int channel = 0; channel < this.wave.getAudioFormat().getChannels(); ++channel) {
            int zoomWavePosition;
            ZoomLevelRecord levelRecord;
            int level2;
            int position;
            for (position = 0; position < lengthInTicks; ++position) {
                for (level2 = 0; level2 < numberOflevels; ++level2) {
                    levelRecord = levelRecords[level2];
                    if (position % levelRecord.levelRatio == 0) {
                        if (position > 0) {
                            zoomWavePosition = (position >> 4 * level2 + 4) * 2 - 1;
                            levelRecord.zoomWave.setValue((BinaryData)levelRecord.minValue, zoomWavePosition, channel);
                            levelRecord.zoomWave.setValue((BinaryData)levelRecord.maxValue, zoomWavePosition + 1, channel);
                        }
                        this.wave.getValue((EditableBinaryData)levelRecord.maxValue, position, channel);
                        this.wave.getValue((EditableBinaryData)levelRecord.minValue, position, channel);
                        continue;
                    }
                    this.wave.getValue((EditableBinaryData)levelRecord.value, position, channel);
                    if (!XBWavePanel.dataIsGreaterOrEqual((BinaryData)levelRecord.minValue, (BinaryData)levelRecord.value, levelRecord.bytesPerSample)) {
                        levelRecord.minValue.replace(0L, (BinaryData)levelRecord.value, 0L, (long)levelRecord.bytesPerSample);
                    }
                    if (!XBWavePanel.dataIsGreater((BinaryData)levelRecord.value, (BinaryData)levelRecord.maxValue, levelRecord.bytesPerSample)) continue;
                    levelRecord.maxValue.replace(0L, (BinaryData)levelRecord.value, 0L, (long)levelRecord.bytesPerSample);
                }
            }
            if (position <= 0) continue;
            for (level2 = 0; level2 < numberOflevels; ++level2) {
                levelRecord = levelRecords[level2];
                zoomWavePosition = (position >> 4 * level2 + 4) * 2 - 1;
                levelRecord.zoomWave.setValue((BinaryData)levelRecord.minValue, zoomWavePosition, channel);
                levelRecord.zoomWave.setValue((BinaryData)levelRecord.maxValue, zoomWavePosition + 1, channel);
            }
        }
        for (level = 0; level < numberOflevels; ++level) {
            this.zoomCache.add(levelRecords[level].zoomWave);
        }
    }

    public boolean inSelection(int pos) {
        if (this.selection == null) {
            return false;
        }
        return pos >= this.selection.getBegin() && pos <= this.selection.getEnd();
    }

    public void selectAll() {
        if (this.wave != null) {
            this.selection = new SelectionRange(0, this.wave.getLengthInTicks());
            if (this.selectionChangedListener != null) {
                this.selectionChangedListener.selectionChanged();
            }
            this.repaint();
        }
    }

    public void clearSelection() {
        this.selection = null;
        if (this.selectionChangedListener != null) {
            this.selectionChangedListener.selectionChanged();
        }
        this.repaint();
    }

    public boolean hasSelection() {
        return this.selection != null;
    }

    public void setSelectionChangedListener(SelectionChangedListener selectionChangedListener) {
        this.selectionChangedListener = selectionChangedListener;
    }

    public void setZoomChangedListener(ZoomChangedListener zoomChangedListener) {
        this.zoomChangedListener = zoomChangedListener;
    }

    private static boolean dataIsGreater(BinaryData data, BinaryData comparedData, int bytesCount) {
        for (int i = 0; i < bytesCount; ++i) {
            if (data.getByte((long)i) > comparedData.getByte((long)i)) {
                return true;
            }
            if (data.getByte((long)i) >= comparedData.getByte((long)i)) continue;
            return false;
        }
        return false;
    }

    private static boolean dataIsGreaterOrEqual(BinaryData data, BinaryData comparedData, int bytesCount) {
        for (int i = 0; i < bytesCount; ++i) {
            if (data.getByte((long)i) > comparedData.getByte((long)i)) {
                return true;
            }
            if (data.getByte((long)i) >= comparedData.getByte((long)i)) continue;
            return false;
        }
        return true;
    }

    public static interface ZoomChangedListener {
        public void zoomChanged();
    }

    public static interface SelectionChangedListener {
        public void selectionChanged();
    }

    public static class SelectionRange {
        private int begin;
        private int end;

        public SelectionRange() {
            this.begin = 0;
            this.end = 0;
        }

        public SelectionRange(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        public int getBegin() {
            return this.begin;
        }

        public void setBegin(int begin) {
            this.begin = begin;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }
    }

    public static enum ToolMode {
        SELECTION,
        PENCIL;

    }

    public static enum DrawMode {
        DOTS_MODE,
        LINE_MODE,
        INTEGRAL_MODE;

    }

    private class ZoomLevelRecord {
        final XBWave zoomWave;
        final int bytesPerSample;
        final int levelRatio;
        final XBData value;
        final XBData maxValue;
        final XBData minValue;

        public ZoomLevelRecord(XBWave wave, int lengthInTicks, int level) {
            this.levelRatio = 1 << level * 4;
            this.zoomWave = new XBWave(wave.getAudioFormat());
            this.zoomWave.setLengthInTicks((int)Math.ceil(lengthInTicks * 2 / (16 * level)) + 1);
            this.bytesPerSample = wave.getAudioFormat().getSampleSizeInBits() >> 3;
            this.value = new XBData();
            this.value.setDataSize((long)this.bytesPerSample);
            this.maxValue = new XBData();
            this.maxValue.setDataSize((long)this.bytesPerSample);
            this.minValue = new XBData();
            this.minValue.setDataSize((long)this.bytesPerSample);
        }
    }
}

