/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.data.stub;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.exbin.framework.data.TableDataRow;
import org.exbin.framework.data.TableDataSource;
import org.exbin.framework.data.stub.RemoteTableDataSource;
import org.exbin.xbup.client.XBCatalogServiceClient;

public class DataStub {
    private final XBCatalogServiceClient client;

    public DataStub(XBCatalogServiceClient client) {
        this.client = client;
        String derbyPath = this.getClass().getPackage().getName().replace(".", "/");
        String derbyHome = System.getProperty("user.home") + "/.java/.userPrefs/" + derbyPath + "-dev";
        System.out.println("Derby home: " + derbyHome);
        System.setProperty("derby.system.home", derbyHome);
        Connection connection = this.getConnection();
        try {
            Statement stmt = connection.createStatement();
            stmt.execute("CREATE TABLE data_test (ID INT NOT NULL GENERATED ALWAYS AS IDENTITY, TEST1 VARCHAR(20), TEST2 VARCHAR(20))");
            stmt.execute("INSERT INTO data_test (TEST1, TEST2) VALUES ('Test 1', 'Test 2')");
            ResultSet rs = stmt.executeQuery("SELECT * FROM data_test");
            int rows = 0;
            while (rs.next()) {
                ++rows;
            }
            System.out.println("Rows : " + rows);
        }
        catch (SQLException ex) {
            Logger.getLogger(DataStub.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public TableDataSource getTableDataSource(String tableSourceId) {
        return new RemoteTableDataSource(this, tableSourceId);
    }

    public List<TableDataSource.ColumnDefinition> getColumDefinition(String tableSourceId) {
        ArrayList<TableDataSource.ColumnDefinition> columns = new ArrayList<TableDataSource.ColumnDefinition>();
        TableDataSource.ColumnDefinition testColumn = new TableDataSource.ColumnDefinition(){

            @Override
            public String getName() {
                return "Test";
            }

            @Override
            public Class<?> getValueClass() {
                return String.class;
            }
        };
        columns.add(testColumn);
        TableDataSource.ColumnDefinition testColumn2 = new TableDataSource.ColumnDefinition(){

            @Override
            public String getName() {
                return "Test2";
            }

            @Override
            public Class<?> getValueClass() {
                return String.class;
            }
        };
        columns.add(testColumn2);
        return columns;
    }

    public int getTableRowCount(String tableSourceId) {
        return 20;
    }

    public List<TableDataRow> getTableRows(String tableSourceId, int startRow, int rowCount) {
        int rowsToLoad = rowCount;
        if (startRow > 20) {
            rowsToLoad = 0;
        } else if (startRow + rowCount > 20) {
            rowsToLoad = 20 - startRow;
        }
        ArrayList<TableDataRow> rows = new ArrayList<TableDataRow>();
        for (int i = 0; i < rowsToLoad; ++i) {
            final int rowIndex = startRow + i;
            TableDataRow data = new TableDataRow(){

                @Override
                public Object[] getRowData() {
                    return new String[]{"Cell " + rowIndex + ", 0", "Cell " + rowIndex + ", 1"};
                }
            };
            rows.add(data);
        }
        return rows;
    }

    public Connection getConnection() {
        Connection conn = null;
        try {
            Properties connectionProps = new Properties();
            connectionProps.put("user", "app");
            connectionProps.put("password", "app");
            conn = DriverManager.getConnection("jdbc:derby:testdb;create=true", connectionProps);
        }
        catch (SQLException ex) {
            Logger.getLogger(DataStub.class.getName()).log(Level.SEVERE, null, ex);
        }
        return conn;
    }
}

