/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.data.model;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.exbin.framework.data.TableDataSource;
import org.exbin.framework.data.stub.DataStub;
import org.exbin.xbup.client.XBCatalogServiceClient;
import org.exbin.xbup.core.remote.XBServiceClient;

@ParametersAreNonnullByDefault
public class TableModelSource
implements TableModel {
    private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private final TableDataSource dataSource;
    private final String tableSourceId;
    private final XBServiceClient service;

    public TableModelSource(String tableSourceId, XBServiceClient service) {
        this.service = service;
        this.tableSourceId = tableSourceId;
        DataStub dataStub = new DataStub((XBCatalogServiceClient)service);
        this.dataSource = dataStub.getTableDataSource(tableSourceId);
    }

    @Override
    public int getRowCount() {
        return this.dataSource.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.dataSource.getColumns().size();
    }

    @Override
    @Nonnull
    public String getColumnName(int columnIndex) {
        return this.dataSource.getColumns().get(columnIndex).getName();
    }

    @Override
    @Nonnull
    public Class<?> getColumnClass(int columnIndex) {
        return this.dataSource.getColumns().get(columnIndex).getValueClass();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.dataSource.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        this.dataSource.setValueAt(value, rowIndex, columnIndex);
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        this.listeners.remove(listener);
    }
}

