/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.data.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public enum CatalogDefOperationType {
    CONSIST(0, "Consist"),
    JOIN(1, "Join"),
    ANY(2, "Any"),
    ATTRIBUTE(3, "Attribute"),
    CONSIST_LIST(4, "Consist[]"),
    JOIN_LIST(5, "Join[]"),
    ANY_LIST(6, "Any[]"),
    ATTRIBUTE_LIST(7, "Attribute[]");

    final int rowIndex;
    private final String caption;
    private static final Map<Integer, CatalogDefOperationType> map;

    private CatalogDefOperationType(int rowIndex, String caption) {
        this.rowIndex = rowIndex;
        this.caption = caption;
    }

    public static CatalogDefOperationType valueOf(int rowIndex) {
        return map.get(rowIndex);
    }

    @Nonnull
    public static String[] getAsArray() {
        return CatalogDefOperationType.getAsArray(map.size());
    }

    @Nonnull
    public static String[] getAsArray(int rowsCount) {
        String[] rows = new String[rowsCount];
        for (int rowIndex = 0; rowIndex < rows.length; ++rowIndex) {
            rows[rowIndex] = CatalogDefOperationType.valueOf((int)rowIndex).caption;
        }
        return rows;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    @Nonnull
    public String getCaption() {
        return this.caption;
    }

    static {
        map = new HashMap<Integer, CatalogDefOperationType>();
        for (CatalogDefOperationType operationType : CatalogDefOperationType.values()) {
            map.put(operationType.rowIndex, operationType);
        }
    }
}

