/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.preferences;

import java.io.File;
import java.util.prefs.Preferences;
import java.util.prefs.PreferencesFactory;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.preferences.FilePreferences;

@ParametersAreNonnullByDefault
public class FilePreferencesFactory
implements PreferencesFactory {
    public static String preferenceFilename = "prefs.xml";
    public static String preferencesPath = null;
    private static final String PREFERENCES_FACTORY_PROPERTY = "java.util.prefs.PreferencesFactory";
    private static final String PREFERENCES_FACTORY_CLASS = "org.exbin.framework.preferences.FilePreferencesFactory";
    private Preferences userPreferences;
    private Preferences systemPreferences;

    @Override
    @Nonnull
    public Preferences systemRoot() {
        if (this.systemPreferences == null) {
            this.systemPreferences = new FilePreferences(null, "");
        }
        return this.systemPreferences;
    }

    @Override
    @Nonnull
    public Preferences userRoot() {
        if (this.userPreferences == null) {
            this.userPreferences = new FilePreferences(null, "");
        }
        return this.userPreferences;
    }

    @Nonnull
    public static File getPreferencesFile(String absolutePath) {
        if (preferencesPath == null) {
            preferencesPath = System.getProperty("user.home") + File.separator + ".java" + File.separator + ".userPrefs";
        }
        return new File(preferencesPath + absolutePath.replace('/', File.separatorChar) + File.separator + preferenceFilename);
    }

    @Nonnull
    public FilePreferences userNodeForPackage(Class clazz) {
        String[] packageComponents;
        System.setProperty(PREFERENCES_FACTORY_PROPERTY, PREFERENCES_FACTORY_CLASS);
        FilePreferences preferences = (FilePreferences)this.userRoot();
        for (String packageComponent : packageComponents = clazz.getPackage().getName().split(Pattern.quote("."))) {
            preferences = (FilePreferences)preferences.childSpi(packageComponent);
        }
        return preferences;
    }
}

