/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class XBFrameworkUtils {
    public static final String NULL_FIELD_ERROR = "Field cannot be null";

    private XBFrameworkUtils() {
    }

    @Nonnull
    public static <T> T requireNonNull(@Nullable T object) {
        return Objects.requireNonNull(object, NULL_FIELD_ERROR);
    }

    @Nonnull
    public static <T> T requireNonNull(@Nullable T object, String message) {
        return Objects.requireNonNull(object, message);
    }

    public static void requireNonNull(Object ... objects) {
        for (Object object : objects) {
            Objects.requireNonNull(object, NULL_FIELD_ERROR);
        }
    }

    public static void throwInvalidTypeException(Enum<?> enumObject) {
        throw XBFrameworkUtils.getInvalidTypeException(enumObject);
    }

    @Nonnull
    public static IllegalStateException getInvalidTypeException(Enum<?> enumObject) {
        return new IllegalStateException("Unexpected " + enumObject.getDeclaringClass().getName() + " value " + enumObject.name());
    }
}

