/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.update.options.gui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModifiedListener;
import org.exbin.framework.update.options.CheckForUpdateOptions;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class ApplicationUpdateOptionsPanel
extends JPanel
implements OptionsComponent<CheckForUpdateOptions> {
    private OptionsModifiedListener optionsModifiedListener;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ApplicationUpdateOptionsPanel.class);
    private JCheckBox checkForUpdatesOnStartCheckBox;

    public ApplicationUpdateOptionsPanel() {
        this.initComponents();
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void loadFromOptions(CheckForUpdateOptions options) {
        this.checkForUpdatesOnStartCheckBox.setSelected(options.isCheckForUpdate());
    }

    public void saveToOptions(CheckForUpdateOptions options) {
        options.setCheckForUpdate(this.checkForUpdatesOnStartCheckBox.isSelected());
    }

    private void initComponents() {
        this.checkForUpdatesOnStartCheckBox = new JCheckBox();
        this.setName("Form");
        this.checkForUpdatesOnStartCheckBox.setSelected(true);
        this.checkForUpdatesOnStartCheckBox.setText(this.resourceBundle.getString("checkForUpdatesOnStartCheckBox.text"));
        this.checkForUpdatesOnStartCheckBox.setName("checkForUpdatesOnStartCheckBox");
        this.checkForUpdatesOnStartCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ApplicationUpdateOptionsPanel.this.checkForUpdatesOnStartCheckBoxjCheckBoxItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkForUpdatesOnStartCheckBox, -1, 378, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkForUpdatesOnStartCheckBox)));
    }

    private void checkForUpdatesOnStartCheckBoxjCheckBoxItemStateChanged(ItemEvent evt) {
        this.setModified(true);
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new ApplicationUpdateOptionsPanel());
    }

    private void setModified(boolean b) {
        if (this.optionsModifiedListener != null) {
            this.optionsModifiedListener.wasModified();
        }
    }

    public void setOptionsModifiedListener(OptionsModifiedListener listener) {
        this.optionsModifiedListener = listener;
    }
}

