/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.update.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.exbin.framework.update.api.VersionNumbers;
import org.exbin.framework.update.service.CheckForUpdateService;
import org.exbin.framework.utils.DesktopUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class CheckForUpdatePanel
extends JPanel
implements HyperlinkListener {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CheckForUpdatePanel.class);
    private CheckForUpdateService checkForUpdateService;
    private Controller controller;
    private JLabel availableVersionLabel;
    private JTextField availableVersionTextField;
    private JLabel currentVersionLabel;
    private JTextField currentVersionTextField;
    private JButton downloadButton;
    private JButton recheckButton;
    private JLabel statusIconLabel;
    private JPanel statusPanel;
    private JLabel statusTextLabel;

    public CheckForUpdatePanel() {
        this.initComponents();
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setController(Controller control) {
        this.controller = control;
    }

    public void setCheckForUpdateService(CheckForUpdateService checkForUpdateService) {
        this.checkForUpdateService = checkForUpdateService;
        URL downloadUrl = checkForUpdateService.getDownloadUrl();
        this.downloadButton.setEnabled(downloadUrl != null);
        this.recheckButton.setEnabled(true);
        this.setVersionNumbers(checkForUpdateService.getCurrentVersion());
        VersionNumbers updateVersion = checkForUpdateService.getUpdateVersion();
        if (updateVersion != null) {
            this.setUpdateVersionNumbers(updateVersion);
        }
    }

    public void performCheckForUpdate() {
        this.recheckButton.setEnabled(false);
        this.statusTextLabel.setText(this.resourceBundle.getString("status.checking.text"));
        this.statusIconLabel.setIcon(new ImageIcon(this.getClass().getResource(this.resourceBundle.getString("status.checking.icon"))));
        this.checkForUpdateService.performCheckForUpdates((result, updateVersion) -> {
            if (updateVersion == null) {
                this.availableVersionTextField.setText(this.resourceBundle.getString("unknown"));
            } else {
                this.setUpdateVersionNumbers(updateVersion);
            }
            this.setCheckUpdatesResult(result);
            this.recheckButton.setEnabled(true);
        });
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            DesktopUtils.openDesktopURL((String)event.getURL().toExternalForm());
        }
    }

    private void initComponents() {
        this.statusPanel = new JPanel();
        this.statusIconLabel = new JLabel();
        this.statusTextLabel = new JLabel();
        this.currentVersionLabel = new JLabel();
        this.currentVersionTextField = new JTextField();
        this.availableVersionLabel = new JLabel();
        this.availableVersionTextField = new JTextField();
        this.recheckButton = new JButton();
        this.downloadButton = new JButton();
        this.statusPanel.setBorder(BorderFactory.createEtchedBorder());
        this.statusPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 60));
        this.statusPanel.setMinimumSize(new Dimension(100, 60));
        this.statusIconLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/update/resources/icons/open_icon_library/icons/png/48x48/apps/internet-web-browser-7.png")));
        this.statusTextLabel.setText(this.resourceBundle.getString("statusTextLabel.text"));
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusIconLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.statusTextLabel, -1, 308, Short.MAX_VALUE).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusIconLabel).addComponent(this.statusTextLabel, -2, 48, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.currentVersionLabel.setText(this.resourceBundle.getString("currentVersionLabel.text"));
        this.currentVersionTextField.setEditable(false);
        this.currentVersionTextField.setText("unknown");
        this.availableVersionLabel.setText(this.resourceBundle.getString("availableVersionLabel.text"));
        this.availableVersionTextField.setEditable(false);
        this.availableVersionTextField.setText("unknown");
        this.recheckButton.setText(this.resourceBundle.getString("recheckButton.text"));
        this.recheckButton.setEnabled(false);
        this.recheckButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheckForUpdatePanel.this.recheckButtonActionPerformed(evt);
            }
        });
        this.downloadButton.setText(this.resourceBundle.getString("downloadButton.text"));
        this.downloadButton.setEnabled(false);
        this.downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheckForUpdatePanel.this.downloadButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.currentVersionTextField).addComponent(this.availableVersionTextField).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.currentVersionLabel).addComponent(this.availableVersionLabel).addGroup(layout.createSequentialGroup().addComponent(this.downloadButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.recheckButton))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.statusPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.currentVersionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.currentVersionTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.availableVersionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.availableVersionTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.recheckButton).addComponent(this.downloadButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void recheckButtonActionPerformed(ActionEvent evt) {
        this.performCheckForUpdate();
    }

    private void downloadButtonActionPerformed(ActionEvent evt) {
        DesktopUtils.openDesktopURL((URL)this.checkForUpdateService.getDownloadUrl());
    }

    private void setVersionNumbers(VersionNumbers versionNumbers) {
        this.currentVersionTextField.setText(versionNumbers.versionAsString());
    }

    private void setUpdateVersionNumbers(VersionNumbers versionNumbers) {
        this.availableVersionTextField.setText(versionNumbers.versionAsString());
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CheckForUpdatePanel());
    }

    public void setCheckUpdatesResult(CheckForUpdateService.CheckForUpdateResult result) {
        if (result == null) {
            return;
        }
        switch (result) {
            case UPDATE_URL_NOT_SET: {
                this.statusTextLabel.setText(this.resourceBundle.getString("status.updateUrlNotSet.text"));
                this.statusIconLabel.setIcon(new ImageIcon(this.getClass().getResource(this.resourceBundle.getString("status.updateUrlNotSet.icon"))));
                break;
            }
            case NO_CONNECTION: {
                this.statusTextLabel.setText(this.resourceBundle.getString("status.noConnection.text"));
                this.statusIconLabel.setIcon(new ImageIcon(this.getClass().getResource(this.resourceBundle.getString("status.noConnection.icon"))));
                break;
            }
            case CONNECTION_ISSUE: {
                this.statusTextLabel.setText(this.resourceBundle.getString("status.connectionIssue.text"));
                this.statusIconLabel.setIcon(new ImageIcon(this.getClass().getResource(this.resourceBundle.getString("status.connectionIssue.icon"))));
                break;
            }
            case NOT_FOUND: {
                this.statusTextLabel.setText(this.resourceBundle.getString("status.notFound.text"));
                this.statusIconLabel.setIcon(new ImageIcon(this.getClass().getResource(this.resourceBundle.getString("status.notFound.icon"))));
                break;
            }
            case NO_UPDATE_AVAILABLE: {
                this.statusTextLabel.setText(this.resourceBundle.getString("status.noUpdateAvailable.text"));
                this.statusIconLabel.setIcon(new ImageIcon(this.getClass().getResource(this.resourceBundle.getString("status.noUpdateAvailable.icon"))));
                break;
            }
            case UPDATE_FOUND: {
                this.statusTextLabel.setText(this.resourceBundle.getString("status.updateFound.text"));
                this.statusIconLabel.setIcon(new ImageIcon(this.getClass().getResource(this.resourceBundle.getString("status.updateFound.icon"))));
                break;
            }
            default: {
                this.statusTextLabel.setText("Unexpected result state " + result.name() + "!");
                this.statusIconLabel.setIcon(new ImageIcon(this.getClass().getResource(this.resourceBundle.getString("status.misc.icon"))));
            }
        }
    }

    public static interface Controller {
        public void checkForUpdate();
    }
}

