/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.update;

import java.awt.Frame;
import java.net.URL;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import org.exbin.framework.action.api.ActionModuleApi;
import org.exbin.framework.action.api.MenuPosition;
import org.exbin.framework.action.api.PositionMode;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.options.api.DefaultOptionsPage;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModuleApi;
import org.exbin.framework.options.api.OptionsPage;
import org.exbin.framework.update.action.CheckForUpdateAction;
import org.exbin.framework.update.api.UpdateModuleApi;
import org.exbin.framework.update.api.VersionNumbers;
import org.exbin.framework.update.options.CheckForUpdateOptions;
import org.exbin.framework.update.options.gui.ApplicationUpdateOptionsPanel;
import org.exbin.framework.update.preferences.CheckForUpdatePreferences;
import org.exbin.framework.update.service.CheckForUpdateService;
import org.exbin.framework.update.service.impl.CheckForUpdateServiceImpl;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.xbup.plugin.XBModuleHandler;

@ParametersAreNonnullByDefault
public class UpdateModule
implements UpdateModuleApi {
    private XBApplication application;
    private CheckForUpdateAction checkUpdateAction;
    private URL checkUpdateUrl;
    private VersionNumbers updateVersion;
    private URL downloadUrl;
    private CheckForUpdateService checkForUpdateService;

    public void init(XBModuleHandler application) {
        this.application = (XBApplication)application;
    }

    public void unregisterModule(String moduleId) {
    }

    @Nonnull
    public Action getCheckUpdateAction() {
        if (this.checkUpdateAction == null) {
            this.checkUpdateAction = new CheckForUpdateAction();
            this.checkUpdateAction.setCheckForUpdateService(this.getCheckForUpdateService());
            this.checkUpdateAction.setApplication(this.application);
            this.checkUpdateAction.setUpdateUrl(this.checkUpdateUrl);
            this.checkUpdateAction.setUpdateVersion(this.updateVersion);
            this.checkUpdateAction.setUpdateDownloadUrl(this.downloadUrl);
        }
        return this.checkUpdateAction;
    }

    public void registerDefaultMenuItem() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.HELP_MENU_ID, MODULE_ID, this.getCheckUpdateAction(), new MenuPosition(PositionMode.MIDDLE_LAST));
    }

    public void registerOptionsPanels() {
        OptionsModuleApi optionsModule = (OptionsModuleApi)this.application.getModuleRepository().getModuleByInterface(OptionsModuleApi.class);
        optionsModule.addOptionsPage((OptionsPage)new DefaultOptionsPage<CheckForUpdateOptions>(){

            public OptionsComponent<CheckForUpdateOptions> createPanel() {
                return new ApplicationUpdateOptionsPanel();
            }

            @Nonnull
            public ResourceBundle getResourceBundle() {
                return LanguageUtils.getResourceBundleByClass(ApplicationUpdateOptionsPanel.class);
            }

            @Nonnull
            public CheckForUpdateOptions createOptions() {
                return new CheckForUpdateOptions();
            }

            public void loadFromPreferences(Preferences preferences, CheckForUpdateOptions options) {
                options.loadFromPreferences(new CheckForUpdatePreferences(preferences));
            }

            public void saveToPreferences(Preferences preferences, CheckForUpdateOptions options) {
                options.saveToPreferences(new CheckForUpdatePreferences(preferences));
            }

            public void applyPreferencesChanges(CheckForUpdateOptions options) {
            }
        });
    }

    @Nonnull
    public VersionNumbers getCurrentVersion() {
        ResourceBundle appBundle = this.application.getAppBundle();
        String releaseString = appBundle.getString("Application.release");
        VersionNumbers versionNumbers = new VersionNumbers();
        versionNumbers.versionFromString(releaseString);
        return versionNumbers;
    }

    public void setUpdateUrl(URL updateUrl) {
        this.checkUpdateUrl = updateUrl;
        if (this.checkUpdateAction != null) {
            this.checkUpdateAction.setUpdateUrl(updateUrl);
        }
    }

    @Nullable
    public URL getUpdateUrl() {
        return this.checkUpdateUrl;
    }

    @Nonnull
    public CheckForUpdateService getCheckForUpdateService() {
        if (this.checkForUpdateService == null) {
            this.checkForUpdateService = new CheckForUpdateServiceImpl(this);
        }
        return this.checkForUpdateService;
    }

    public void setUpdateVersion(VersionNumbers updateVersion) {
        this.updateVersion = updateVersion;
        if (this.checkUpdateAction != null) {
            this.checkUpdateAction.setUpdateVersion(updateVersion);
        }
    }

    @Nullable
    public VersionNumbers getUpdateVersion() {
        return this.updateVersion;
    }

    @Nullable
    public URL getUpdateDownloadUrl() {
        return this.downloadUrl;
    }

    public void setUpdateDownloadUrl(URL downloadUrl) {
        this.downloadUrl = downloadUrl;
        if (this.checkUpdateAction != null) {
            this.checkUpdateAction.setUpdateDownloadUrl(downloadUrl);
        }
    }

    public void checkOnStart(Frame frame) {
        this.checkUpdateAction.checkOnStart(frame);
    }
}

