/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.basic;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Timer;
import org.exbin.bined.CodeAreaCaret;
import org.exbin.bined.CodeAreaCaretPosition;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.DefaultCodeAreaCaretPosition;
import org.exbin.bined.basic.BasicCodeAreaSection;

@ParametersAreNonnullByDefault
public class DefaultCodeAreaCaret
implements CodeAreaCaret {
    private static final int DOUBLE_CURSOR_WIDTH = 2;
    private static final int DEFAULT_BLINK_RATE = 450;
    @Nonnull
    private final CaretChangeListener changeListener;
    private final DefaultCodeAreaCaretPosition caretPosition = new DefaultCodeAreaCaretPosition();
    private int blinkRate = 0;
    private Timer blinkTimer = null;
    private boolean cursorVisible = true;
    @Nonnull
    private CursorRenderingMode renderingMode = CursorRenderingMode.NEGATIVE;

    public DefaultCodeAreaCaret(CaretChangeListener changeListener) {
        CodeAreaUtils.requireNonNull((Object)changeListener, (String)"Change listener cannot be null");
        this.changeListener = changeListener;
        this.privateSetBlinkRate(450);
    }

    public static int getCursorThickness(CursorShape cursorShape, int characterWidth, int lineHeight) {
        switch (cursorShape) {
            case INSERT: {
                return 2;
            }
            case OVERWRITE: 
            case MIRROR: {
                return characterWidth;
            }
        }
        return -1;
    }

    @Nonnull
    public CodeAreaCaretPosition getCaretPosition() {
        return this.caretPosition;
    }

    public void resetBlink() {
        if (this.blinkTimer != null) {
            this.cursorVisible = true;
            this.blinkTimer.restart();
        }
    }

    private void notifyCaredChanged() {
        this.changeListener.notifyCaretChanged();
    }

    public void setCaretPosition(@Nullable CodeAreaCaretPosition caretPosition) {
        if (caretPosition != null) {
            this.caretPosition.setPosition(caretPosition);
        } else {
            this.caretPosition.reset();
        }
        this.resetBlink();
    }

    public void setCaretPosition(long dataPosition) {
        this.caretPosition.setDataPosition(dataPosition);
        this.caretPosition.setCodeOffset(0);
        this.resetBlink();
    }

    public void setCaretPosition(long dataPosition, int codeOffset) {
        this.caretPosition.setDataPosition(dataPosition);
        this.caretPosition.setCodeOffset(codeOffset);
        this.resetBlink();
    }

    public void setCaretPosition(long dataPosition, int codeOffset, CodeAreaSection section) {
        this.caretPosition.setDataPosition(dataPosition);
        this.caretPosition.setCodeOffset(codeOffset);
        this.caretPosition.setSection(section);
        this.resetBlink();
    }

    public long getDataPosition() {
        return this.caretPosition.getDataPosition();
    }

    public void setDataPosition(long dataPosition) {
        this.caretPosition.setDataPosition(dataPosition);
        this.resetBlink();
    }

    public int getCodeOffset() {
        return this.caretPosition.getCodeOffset();
    }

    public void setCodeOffset(int codeOffset) {
        this.caretPosition.setCodeOffset(codeOffset);
        this.resetBlink();
    }

    @Nonnull
    public CodeAreaSection getSection() {
        return (CodeAreaSection)this.caretPosition.getSection().orElse(BasicCodeAreaSection.CODE_MATRIX);
    }

    public void setSection(CodeAreaSection section) {
        this.caretPosition.setSection(section);
        this.resetBlink();
    }

    public int getBlinkRate() {
        return this.blinkRate;
    }

    public void setBlinkRate(int blinkRate) {
        this.privateSetBlinkRate(blinkRate);
    }

    public boolean isCursorVisible() {
        return this.cursorVisible;
    }

    @Nonnull
    public CursorRenderingMode getRenderingMode() {
        return this.renderingMode;
    }

    public void setRenderingMode(CursorRenderingMode renderingMode) {
        CodeAreaUtils.requireNonNull((Object)((Object)renderingMode));
        this.renderingMode = renderingMode;
        this.notifyCaredChanged();
    }

    private void privateSetBlinkRate(int blinkRate) {
        if (blinkRate < 0) {
            throw new IllegalArgumentException("Blink rate cannot be negative");
        }
        this.blinkRate = blinkRate;
        if (this.blinkTimer != null) {
            if (blinkRate == 0) {
                this.blinkTimer.stop();
                this.blinkTimer = null;
                this.cursorVisible = true;
                this.notifyCaredChanged();
            } else {
                this.blinkTimer.setDelay(blinkRate);
                this.blinkTimer.setInitialDelay(blinkRate);
            }
        } else if (blinkRate > 0) {
            this.blinkTimer = new Timer(blinkRate, new Blink());
            this.blinkTimer.setRepeats(true);
            this.blinkTimer.start();
        }
    }

    public static interface CaretChangeListener {
        public void notifyCaretChanged();
    }

    public static enum CursorRenderingMode {
        PAINT,
        XOR,
        NEGATIVE;

    }

    public static enum CursorShape {
        INSERT,
        OVERWRITE,
        MIRROR;

    }

    @ParametersAreNonnullByDefault
    private class Blink
    implements ActionListener {
        private Blink() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultCodeAreaCaret.this.cursorVisible = !DefaultCodeAreaCaret.this.cursorVisible;
            DefaultCodeAreaCaret.this.notifyCaredChanged();
        }
    }
}

