/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.EmptyBinaryData;
import org.exbin.bined.CodeAreaControl;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.DataChangedListener;
import org.exbin.bined.capability.SelectionCapable;
import org.exbin.bined.swing.CodeAreaCommandHandler;

@ParametersAreNonnullByDefault
public abstract class CodeAreaCore
extends JComponent
implements CodeAreaControl,
Accessible {
    @Nonnull
    private BinaryData contentData = EmptyBinaryData.INSTANCE;
    @Nonnull
    private CodeAreaCommandHandler commandHandler;
    private final List<DataChangedListener> dataChangedListeners = new ArrayList<DataChangedListener>();

    public CodeAreaCore(CodeAreaCommandHandler.CodeAreaCommandHandlerFactory commandHandlerFactory) {
        this.commandHandler = this.createCommandHandler((CodeAreaCommandHandler.CodeAreaCommandHandlerFactory)CodeAreaUtils.requireNonNull((Object)commandHandlerFactory));
        this.init();
    }

    private void init() {
        this.enableEvents(8L);
        this.setName("CodeArea");
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.registerControlListeners();
    }

    @Nonnull
    private CodeAreaCommandHandler createCommandHandler(CodeAreaCommandHandler.CodeAreaCommandHandlerFactory commandHandlerFactory) {
        return commandHandlerFactory.createCommandHandler(this);
    }

    private void registerControlListeners() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@Nonnull ComponentEvent event) {
                CodeAreaCore.this.updateLayout();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(@Nonnull KeyEvent keyEvent) {
                CodeAreaCore.this.commandHandler.keyTyped(keyEvent);
            }

            @Override
            public void keyPressed(@Nonnull KeyEvent keyEvent) {
                CodeAreaCore.this.commandHandler.keyPressed(keyEvent);
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(@Nonnull FocusEvent e) {
                CodeAreaCore.this.repaint();
            }

            @Override
            public void focusLost(@Nonnull FocusEvent e) {
                CodeAreaCore.this.repaint();
            }
        });
    }

    @Nonnull
    public CodeAreaCommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public void setCommandHandler(CodeAreaCommandHandler commandHandler) {
        this.commandHandler = commandHandler;
    }

    public void copy() {
        this.commandHandler.copy();
    }

    public void copyAsCode() {
        this.commandHandler.copyAsCode();
    }

    public void cut() {
        this.commandHandler.cut();
    }

    public void paste() {
        this.commandHandler.paste();
    }

    public void pasteFromCode() {
        this.commandHandler.pasteFromCode();
    }

    public void delete() {
        this.commandHandler.delete();
    }

    public void selectAll() {
        this.commandHandler.selectAll();
    }

    public void clearSelection() {
        this.commandHandler.clearSelection();
    }

    public boolean canPaste() {
        return this.commandHandler.canPaste();
    }

    public boolean hasSelection() {
        if (this instanceof SelectionCapable) {
            return ((SelectionCapable)this).hasSelection();
        }
        return false;
    }

    public boolean isEditable() {
        return false;
    }

    @Nonnull
    public BinaryData getContentData() {
        return this.contentData;
    }

    public void setContentData(@Nullable BinaryData contentData) {
        this.contentData = contentData == null ? EmptyBinaryData.INSTANCE : contentData;
        this.notifyDataChanged();
        this.repaint();
    }

    public long getDataSize() {
        return this.contentData.getDataSize();
    }

    @Override
    @Nonnull
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleComponent();
        }
        return this.accessibleContext;
    }

    public void notifyDataChanged() {
        this.dataChangedListeners.forEach(DataChangedListener::dataChanged);
    }

    public void addDataChangedListener(DataChangedListener dataChangedListener) {
        this.dataChangedListeners.add(dataChangedListener);
    }

    public void removeDataChangedListener(DataChangedListener dataChangedListener) {
        this.dataChangedListeners.remove(dataChangedListener);
    }

    public abstract void resetPainter();

    public abstract void updateLayout();

    @ParametersAreNonnullByDefault
    public class AccessibleComponent
    extends JComponent.AccessibleJComponent {
        public AccessibleComponent() {
            super(CodeAreaCore.this);
        }

        @Override
        @Nonnull
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            states.add(AccessibleState.MULTI_LINE);
            if (CodeAreaCore.this.isEditable()) {
                states.add(AccessibleState.EDITABLE);
            }
            return states;
        }
    }
}

