/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.service.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.EntityManagerFactory;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.exbin.framework.action.api.MenuManagement;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.xbup.catalog.CatalogEditor;
import org.exbin.framework.xbup.catalog.gui.CatalogAvailabilityPanel;
import org.exbin.framework.xbup.catalog.gui.CatalogBrowserPanel;
import org.exbin.framework.xbup.catalog.gui.CatalogManagementAware;
import org.exbin.framework.xbup.catalog.gui.CatalogStatusPanel;
import org.exbin.framework.xbup.catalog.gui.CatalogUpdateManagerPanel;
import org.exbin.framework.xbup.catalog.item.gui.CatalogSearchPanel;
import org.exbin.framework.xbup.service.XBDbServiceClient;
import org.exbin.framework.xbup.service.gui.ServiceControlPanel;
import org.exbin.framework.xbup.service.gui.ServiceInfoPanel;
import org.exbin.framework.xbup.service.gui.ServiceStartupPanel;
import org.exbin.framework.xbup.service.gui.TransformationPluginsManagerPanel;
import org.exbin.xbup.catalog.XBAECatalog;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.service.XBEXDescService;
import org.exbin.xbup.catalog.entity.service.XBEXFileService;
import org.exbin.xbup.catalog.entity.service.XBEXHDocService;
import org.exbin.xbup.catalog.entity.service.XBEXIconService;
import org.exbin.xbup.catalog.entity.service.XBEXLangService;
import org.exbin.xbup.catalog.entity.service.XBEXNameService;
import org.exbin.xbup.catalog.entity.service.XBEXPlugService;
import org.exbin.xbup.catalog.entity.service.XBEXStriService;
import org.exbin.xbup.catalog.entity.service.XBEXUiService;
import org.exbin.xbup.client.XBCatalogServiceClient;
import org.exbin.xbup.client.catalog.XBARCatalog;
import org.exbin.xbup.client.catalog.XBRCatalog;
import org.exbin.xbup.client.catalog.remote.service.XBRXDescService;
import org.exbin.xbup.client.catalog.remote.service.XBRXFileService;
import org.exbin.xbup.client.catalog.remote.service.XBRXHDocService;
import org.exbin.xbup.client.catalog.remote.service.XBRXIconService;
import org.exbin.xbup.client.catalog.remote.service.XBRXLangService;
import org.exbin.xbup.client.catalog.remote.service.XBRXNameService;
import org.exbin.xbup.client.catalog.remote.service.XBRXPlugService;
import org.exbin.xbup.client.catalog.remote.service.XBRXStriService;
import org.exbin.xbup.client.catalog.remote.service.XBRXUiService;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.service.XBCService;
import org.exbin.xbup.core.catalog.base.service.XBCXDescService;
import org.exbin.xbup.core.catalog.base.service.XBCXFileService;
import org.exbin.xbup.core.catalog.base.service.XBCXHDocService;
import org.exbin.xbup.core.catalog.base.service.XBCXIconService;
import org.exbin.xbup.core.catalog.base.service.XBCXLangService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.core.catalog.base.service.XBCXPlugService;
import org.exbin.xbup.core.catalog.base.service.XBCXStriService;
import org.exbin.xbup.core.catalog.base.service.XBCXUiService;

@ParametersAreNonnullByDefault
public class ServiceManagerPanel
extends JPanel {
    private XBApplication application;
    private XBCatalogServiceClient service;
    private final CatalogStatusPanel catalogStatusPanel;
    private final CatalogAvailabilityPanel catalogAvailabilityPanel;
    private final CatalogBrowserPanel catalogBrowserPanel;
    private final CatalogEditor catalogEditor;
    private final CatalogSearchPanel catalogSearchPanel;
    private String currentPanelCode;
    private final ServiceInfoPanel serviceInfoPanel;
    private final ServiceStartupPanel serviceStartupPanel;
    private final ServiceControlPanel serviceControlPanel;
    private final Map<String, Component> panelMap = new HashMap<String, Component>();
    private XBACatalog catalog = null;
    private MenuManagement menuManagement;
    private JPanel emptyPanel;
    private JSplitPane mainSplitPane;
    private JTree managerTree;
    private JScrollPane managerTreeScrollPane;
    private JScrollPane serviceInfoScrollPane;

    public ServiceManagerPanel() {
        this.initComponents();
        this.serviceInfoPanel = new ServiceInfoPanel();
        this.serviceStartupPanel = new ServiceStartupPanel();
        this.serviceControlPanel = new ServiceControlPanel();
        this.serviceInfoScrollPane.setViewportView(this.serviceInfoPanel);
        this.panelMap.put("info", this.serviceInfoPanel);
        this.panelMap.put("startup", this.serviceStartupPanel);
        this.panelMap.put("empty", this.emptyPanel);
        this.panelMap.put("control", this.serviceControlPanel);
        this.catalogStatusPanel = new CatalogStatusPanel();
        this.catalogAvailabilityPanel = new CatalogAvailabilityPanel();
        this.catalogBrowserPanel = new CatalogBrowserPanel();
        this.catalogEditor = new CatalogEditor();
        this.catalogSearchPanel = new CatalogSearchPanel();
        this.panelMap.put("catalog", (Component)this.catalogStatusPanel);
        this.panelMap.put("catalog_availability", (Component)this.catalogAvailabilityPanel);
        this.panelMap.put("catalog_browse", (Component)this.catalogBrowserPanel);
        this.panelMap.put("catalog_editor", (Component)this.catalogEditor.getCatalogEditorPanel());
        this.panelMap.put("catalog_search", (Component)this.catalogSearchPanel);
        this.panelMap.put("update", (Component)new CatalogUpdateManagerPanel());
        this.panelMap.put("transplug", new TransformationPluginsManagerPanel());
        this.managerTree.getSelectionModel().setSelectionMode(1);
        MutableTreeNode top = new MutableTreeNode("Root", "");
        this.createNodes(top);
        this.managerTree.setModel(new DefaultTreeModel(top, true));
        this.managerTree.getSelectionModel().addTreeSelectionListener(new MySelectionListener());
        this.managerTree.setSelectionRow(0);
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        this.catalogBrowserPanel.setApplication(application);
        this.catalogEditor.setApplication(application);
        this.catalogSearchPanel.setApplication(application);
    }

    private void createNodes(DefaultMutableTreeNode top) {
        MutableTreeNode item = new MutableTreeNode("Server Information", "info");
        top.add(item);
        item = new MutableTreeNode("Service Control", "control");
        top.add(item);
        item = new MutableTreeNode("Service Startup", "startup");
        top.add(item);
        item = new MutableTreeNode("Catalog", "catalog");
        item.add(new MutableTreeNode("Browse", "catalog_browse"));
        item.add(new MutableTreeNode("Editor", "catalog_editor"));
        item.add(new MutableTreeNode("Search", "catalog_search"));
        item.add(new MutableTreeNode("Update Service", "update"));
        top.add(item);
        item = new MutableTreeNode("Plugin", "empty");
        item.add(new MutableTreeNode("Transformations", "transplug"));
        top.add(item);
    }

    public XBCatalogServiceClient getService() {
        return this.service;
    }

    public void setService(XBCatalogServiceClient service) {
        this.service = service;
        if (service == null) {
            this.serviceInfoPanel.setService(service);
            return;
        }
        XBAECatalog connectedCatalog = null;
        if (service instanceof XBDbServiceClient) {
            this.serviceInfoPanel.setService(service);
            EntityManagerFactory emf = ((XBDbServiceClient)service).getEntityManagerFactory();
            try {
                connectedCatalog = new XBAECatalog(emf.createEntityManager());
                if (connectedCatalog.isShallInit()) {
                    connectedCatalog.initCatalog();
                }
                connectedCatalog.addCatalogService(XBCXLangService.class, (XBCService)new XBEXLangService((XBECatalog)connectedCatalog));
                connectedCatalog.addCatalogService(XBCXStriService.class, (XBCService)new XBEXStriService((XBECatalog)connectedCatalog));
                connectedCatalog.addCatalogService(XBCXNameService.class, (XBCService)new XBEXNameService((XBECatalog)connectedCatalog));
                connectedCatalog.addCatalogService(XBCXDescService.class, (XBCService)new XBEXDescService((XBECatalog)connectedCatalog));
                connectedCatalog.addCatalogService(XBCXFileService.class, (XBCService)new XBEXFileService((XBECatalog)connectedCatalog));
                connectedCatalog.addCatalogService(XBCXIconService.class, (XBCService)new XBEXIconService((XBECatalog)connectedCatalog));
                connectedCatalog.addCatalogService(XBCXPlugService.class, (XBCService)new XBEXPlugService((XBECatalog)connectedCatalog));
                connectedCatalog.addCatalogService(XBCXUiService.class, (XBCService)new XBEXUiService((XBECatalog)connectedCatalog));
                connectedCatalog.addCatalogService(XBCXHDocService.class, (XBCService)new XBEXHDocService((XBECatalog)connectedCatalog));
            }
            catch (Exception ex) {
                Logger.getLogger(ServiceManagerPanel.class.getName()).log(Level.SEVERE, null, ex);
                connectedCatalog = null;
            }
        } else if (service.validate()) {
            this.serviceInfoPanel.setService(service);
            this.serviceControlPanel.setStopButtonEnabled(true);
            connectedCatalog = new XBARCatalog(service);
            ((XBARCatalog)connectedCatalog).addCatalogService(XBCXLangService.class, (XBCService)new XBRXLangService((XBRCatalog)((XBARCatalog)connectedCatalog)));
            ((XBARCatalog)connectedCatalog).addCatalogService(XBCXStriService.class, (XBCService)new XBRXStriService((XBRCatalog)((XBARCatalog)connectedCatalog)));
            ((XBARCatalog)connectedCatalog).addCatalogService(XBCXNameService.class, (XBCService)new XBRXNameService((XBRCatalog)((XBARCatalog)connectedCatalog)));
            ((XBARCatalog)connectedCatalog).addCatalogService(XBCXDescService.class, (XBCService)new XBRXDescService((XBRCatalog)((XBARCatalog)connectedCatalog)));
            ((XBARCatalog)connectedCatalog).addCatalogService(XBCXFileService.class, (XBCService)new XBRXFileService((XBRCatalog)((XBARCatalog)connectedCatalog)));
            ((XBARCatalog)connectedCatalog).addCatalogService(XBCXIconService.class, (XBCService)new XBRXIconService((XBRCatalog)((XBARCatalog)connectedCatalog)));
            ((XBARCatalog)connectedCatalog).addCatalogService(XBCXPlugService.class, (XBCService)new XBRXPlugService((XBRCatalog)((XBARCatalog)connectedCatalog)));
            ((XBARCatalog)connectedCatalog).addCatalogService(XBCXUiService.class, (XBCService)new XBRXUiService((XBRCatalog)((XBARCatalog)connectedCatalog)));
            ((XBARCatalog)connectedCatalog).addCatalogService(XBCXHDocService.class, (XBCService)new XBRXHDocService((XBRCatalog)((XBARCatalog)connectedCatalog)));
        }
        this.setCatalog((XBACatalog)connectedCatalog);
    }

    public void setMenuManagement(MenuManagement menuManagement) {
        this.menuManagement = menuManagement;
        this.catalogBrowserPanel.setMenuManagement(menuManagement);
        this.catalogSearchPanel.setMenuManagement(menuManagement);
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalogAvailabilityPanel.setCatalog(catalog);
        this.catalogStatusPanel.setCatalog(catalog);
        this.catalogBrowserPanel.setCatalog(catalog);
        this.catalogEditor.setCatalog(catalog);
        this.catalogSearchPanel.setCatalog(catalog);
        if (this.catalog == null && catalog != null) {
            Component panel = this.panelMap.get(this.currentPanelCode);
            this.serviceInfoScrollPane.setViewportView(panel);
            panel.revalidate();
        }
        this.catalog = catalog;
    }

    private void initComponents() {
        this.emptyPanel = new JPanel();
        this.mainSplitPane = new JSplitPane();
        this.managerTreeScrollPane = new JScrollPane();
        this.managerTree = new JTree();
        this.serviceInfoScrollPane = new JScrollPane();
        this.emptyPanel.setEnabled(false);
        this.emptyPanel.setName("emptyPanel");
        this.emptyPanel.setLayout(new BorderLayout());
        this.mainSplitPane.setDividerLocation(150);
        this.mainSplitPane.setName("mainSplitPane");
        this.managerTreeScrollPane.setName("managerTreeScrollPane");
        this.managerTree.setName("managerTree");
        this.managerTree.setRootVisible(false);
        this.managerTreeScrollPane.setViewportView(this.managerTree);
        this.mainSplitPane.setLeftComponent(this.managerTreeScrollPane);
        this.serviceInfoScrollPane.setName("serviceInfoScrollPane");
        this.mainSplitPane.setRightComponent(this.serviceInfoScrollPane);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 314, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainSplitPane, -1, 314, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 148, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainSplitPane, -1, 148, Short.MAX_VALUE)));
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new ServiceManagerPanel());
    }

    private class MySelectionListener
    implements TreeSelectionListener {
        private TreePath lastPath = null;

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath itemPath = e.getPath();
            if (this.lastPath != null && !this.lastPath.equals(itemPath) && itemPath.getPathCount() <= this.lastPath.getPathCount()) {
                int i;
                ArrayList<Object> collapsePath = new ArrayList<Object>();
                for (i = 0; i < itemPath.getPathCount() && itemPath.getPathComponent(i).equals(this.lastPath.getPathComponent(i)); ++i) {
                    collapsePath.add(itemPath.getPathComponent(i));
                }
                if (i <= itemPath.getPathCount()) {
                    collapsePath.add(this.lastPath.getPathComponent(i));
                    ServiceManagerPanel.this.managerTree.collapsePath(new TreePath(collapsePath.toArray()));
                }
            }
            if (itemPath != null) {
                this.lastPath = itemPath;
                ServiceManagerPanel.this.managerTree.expandPath(itemPath);
                String panelStringCode = ((MutableTreeNode)ServiceManagerPanel.this.managerTree.getLastSelectedPathComponent()).getCaption();
                if (panelStringCode != null) {
                    ServiceManagerPanel.this.currentPanelCode = panelStringCode;
                    Component panel = (Component)ServiceManagerPanel.this.panelMap.get(panelStringCode);
                    if (panel instanceof CatalogManagementAware && ServiceManagerPanel.this.catalog == null) {
                        panel = (Component)ServiceManagerPanel.this.panelMap.get("catalog_availability");
                    }
                    ServiceManagerPanel.this.serviceInfoScrollPane.setViewportView(panel);
                    panel.revalidate();
                } else {
                    ServiceManagerPanel.this.serviceInfoScrollPane.setViewportView((Component)ServiceManagerPanel.this.panelMap.get("empty"));
                }
                ServiceManagerPanel.this.serviceInfoScrollPane.revalidate();
            }
        }
    }

    private class MutableTreeNode
    extends DefaultMutableTreeNode {
        private final String caption;

        public MutableTreeNode(Object userObject, String caption) {
            super(userObject);
            this.caption = caption;
        }

        public String getCaption() {
            return this.caption;
        }
    }
}

