/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.service.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.xbup.service.gui.EditConnectionPanel;

public class ConnectionsManagerPanel
extends JPanel {
    private XBApplication application;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ConnectionsManagerPanel.class);
    private JButton addButton;
    private JPanel connectionsControlPanel;
    private JList connectionsList;
    private JScrollPane connectionsScrollPane;
    private JButton downButton;
    private JButton modifyButton;
    private JButton removeButton;
    private JButton selectAllButton;
    private JButton upButton;

    public ConnectionsManagerPanel() {
        this.initComponents();
        this.connectionsList.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                ConnectionsManagerPanel.this.selectAllButton.setEnabled(ConnectionsManagerPanel.this.connectionsList.getModel().getSize() > 0);
            }
        });
        this.connectionsList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                boolean emptySelection = this.connectionsList.isSelectionEmpty();
                this.removeButton.setEnabled(!emptySelection);
                this.modifyButton.setEnabled(!emptySelection && this.connectionsList.getSelectionModel().getMinSelectionIndex() == this.connectionsList.getSelectionModel().getMaxSelectionIndex());
                this.selectAllButton.setEnabled(this.connectionsList.getModel().getSize() > 0);
                if (!emptySelection) {
                    int[] indices = this.connectionsList.getSelectedIndices();
                    this.upButton.setEnabled(this.connectionsList.getMaxSelectionIndex() >= indices.length);
                    this.downButton.setEnabled(this.connectionsList.getMinSelectionIndex() + indices.length < this.connectionsList.getModel().getSize());
                } else {
                    this.upButton.setEnabled(false);
                    this.downButton.setEnabled(false);
                }
            }
        });
        ((ConnectionsListModel)this.connectionsList.getModel()).setConnections(new ArrayList<String>());
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    private void initComponents() {
        this.connectionsScrollPane = new JScrollPane();
        this.connectionsList = new JList();
        this.connectionsControlPanel = new JPanel();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.selectAllButton = new JButton();
        this.modifyButton = new JButton();
        this.setName("Form");
        this.connectionsScrollPane.setName("connectionsScrollPane");
        this.connectionsList.setModel(new ConnectionsListModel());
        this.connectionsList.setName("connectionsList");
        this.connectionsScrollPane.setViewportView(this.connectionsList);
        this.connectionsControlPanel.setName("connectionsControlPanel");
        this.upButton.setText(this.resourceBundle.getString("upButton.text"));
        this.upButton.setEnabled(false);
        this.upButton.setName("upButton");
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectionsManagerPanel.this.upButtonActionPerformed(evt);
            }
        });
        this.downButton.setText(this.resourceBundle.getString("downButton.text"));
        this.downButton.setEnabled(false);
        this.downButton.setName("downButton");
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectionsManagerPanel.this.downButtonActionPerformed(evt);
            }
        });
        this.addButton.setText(this.resourceBundle.getString("addButton.text") + "...");
        this.addButton.setName("addButton");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectionsManagerPanel.this.addButtonActionPerformed(evt);
            }
        });
        this.removeButton.setText(this.resourceBundle.getString("removeButton.text"));
        this.removeButton.setEnabled(false);
        this.removeButton.setName("removeButton");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectionsManagerPanel.this.removeButtonActionPerformed(evt);
            }
        });
        this.selectAllButton.setText(this.resourceBundle.getString("selectAllButton.text"));
        this.selectAllButton.setEnabled(false);
        this.selectAllButton.setName("selectAllButton");
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectionsManagerPanel.this.selectAllButtonActionPerformed(evt);
            }
        });
        this.modifyButton.setText(this.resourceBundle.getString("modifyButton.text") + "...");
        this.modifyButton.setEnabled(false);
        this.modifyButton.setName("modifyButton");
        this.modifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectionsManagerPanel.this.modifyButtonActionPerformed(evt);
            }
        });
        GroupLayout connectionsControlPanelLayout = new GroupLayout(this.connectionsControlPanel);
        this.connectionsControlPanel.setLayout(connectionsControlPanelLayout);
        connectionsControlPanelLayout.setHorizontalGroup(connectionsControlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(connectionsControlPanelLayout.createSequentialGroup().addContainerGap().addGroup(connectionsControlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modifyButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.addButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.removeButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.selectAllButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.downButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.upButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        connectionsControlPanelLayout.setVerticalGroup(connectionsControlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(connectionsControlPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.upButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modifyButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.connectionsScrollPane, -1, 304, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.connectionsControlPanel, -2, -1, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.connectionsControlPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.connectionsScrollPane, -1, 457, Short.MAX_VALUE).addGap(12, 12, 12)));
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        EditConnectionPanel panel = new EditConnectionPanel();
        DefaultControlPanel controlPanel = new DefaultControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)panel, (JPanel)controlPanel);
        frameModule.setDialogTitle(dialog, panel.getResourceBundle());
        controlPanel.setHandler(actionType -> {
            switch (actionType) {
                case OK: {
                    ((ConnectionsListModel)this.connectionsList.getModel()).add(this.connectionsList.isSelectionEmpty() ? -1 : this.connectionsList.getSelectedIndex(), panel.getConnection());
                    break;
                }
                case CANCEL: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected action type " + actionType.name());
                }
            }
            dialog.close();
        });
        dialog.showCentered((Component)this);
        dialog.dispose();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        ((ConnectionsListModel)this.connectionsList.getModel()).removeIndices(this.connectionsList.getSelectedIndices());
        this.connectionsList.clearSelection();
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        int[] indices = this.connectionsList.getSelectedIndices();
        int last = 0;
        for (int i = 0; i < indices.length; ++i) {
            int next = indices[i];
            if (last != next) {
                ConnectionsListModel model = (ConnectionsListModel)this.connectionsList.getModel();
                String item = (String)model.getElementAt(next);
                model.add(next - 1, item);
                this.connectionsList.getSelectionModel().addSelectionInterval(next - 1, next - 1);
                model.remove(next + 1);
                continue;
            }
            ++last;
        }
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        int[] indices = this.connectionsList.getSelectedIndices();
        int last = this.connectionsList.getModel().getSize() - 1;
        for (int i = indices.length; i > 0; --i) {
            int next = indices[i - 1];
            if (last != next) {
                ConnectionsListModel model = (ConnectionsListModel)this.connectionsList.getModel();
                String item = (String)model.getElementAt(next);
                model.add(next + 2, item);
                this.connectionsList.getSelectionModel().addSelectionInterval(next + 2, next + 2);
                model.remove(next);
                continue;
            }
            --last;
        }
    }

    private void selectAllButtonActionPerformed(ActionEvent evt) {
        if (this.connectionsList.getSelectedIndices().length < this.connectionsList.getModel().getSize()) {
            this.connectionsList.setSelectionInterval(0, this.connectionsList.getModel().getSize() - 1);
        } else {
            this.connectionsList.clearSelection();
        }
    }

    private void modifyButtonActionPerformed(ActionEvent evt) {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        EditConnectionPanel panel = new EditConnectionPanel();
        panel.setConnection((String)this.connectionsList.getSelectedValue());
        DefaultControlPanel controlPanel = new DefaultControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)panel, (JPanel)controlPanel);
        frameModule.setDialogTitle(dialog, panel.getResourceBundle());
        controlPanel.setHandler(actionType -> {
            switch (actionType) {
                case OK: {
                    int modifiedRowIndex = this.connectionsList.getSelectedIndex();
                    ((ConnectionsListModel)this.connectionsList.getModel()).remove(modifiedRowIndex);
                    ((ConnectionsListModel)this.connectionsList.getModel()).add(modifiedRowIndex, panel.getConnection());
                    this.connectionsList.setSelectedIndex(modifiedRowIndex);
                    break;
                }
                case CANCEL: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected action type " + actionType.name());
                }
            }
            dialog.close();
        });
        dialog.showCentered((Component)this);
        dialog.dispose();
    }

    public void setConnectionList(List<String> list) {
        ((ConnectionsListModel)this.connectionsList.getModel()).setConnections(list);
    }

    public List<String> getConnectionList() {
        return ((ConnectionsListModel)this.connectionsList.getModel()).getConnections();
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new ConnectionsManagerPanel());
    }

    private class ConnectionsListModel
    extends AbstractListModel {
        private List<String> connections = null;

        private ConnectionsListModel() {
        }

        @Override
        public int getSize() {
            if (this.connections == null) {
                return 0;
            }
            return this.connections.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.connections.get(index);
        }

        public List<String> getConnections() {
            return this.connections;
        }

        public void setConnections(List<String> charsets) {
            this.connections = charsets;
            this.fireContentsChanged(this, 0, charsets.size());
        }

        public void addAll(List<String> list, int pos) {
            if (pos >= 0) {
                this.connections.addAll(pos, list);
                this.fireIntervalAdded(this, pos, list.size() + pos);
            } else {
                this.connections.addAll(list);
                this.fireIntervalAdded(this, this.connections.size() - list.size(), this.connections.size());
            }
        }

        public void removeIndices(int[] indices) {
            if (indices.length == 0) {
                return;
            }
            Arrays.sort(indices);
            for (int i = indices.length - 1; i >= 0; --i) {
                this.connections.remove(indices[i]);
                this.fireIntervalRemoved(this, indices[i], indices[i]);
            }
        }

        public void remove(int index) {
            this.connections.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }

        public void add(int index, String item) {
            if (index >= 0) {
                this.connections.add(index, item);
                this.fireIntervalAdded(this, index, index);
            } else {
                this.connections.add(item);
                this.fireIntervalAdded(this, this.connections.size() - 1, this.connections.size());
            }
        }
    }
}

