/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.viewer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.exbin.framework.XBFrameworkUtils;
import org.exbin.framework.editor.xbup.viewer.DocumentItemSelectionListener;
import org.exbin.framework.editor.xbup.viewer.XbupTreeDocument;
import org.exbin.framework.editor.xbup.viewer.gui.XBBlockTablePanel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.core.block.XBTBlock;

@ParametersAreNonnullByDefault
public class XBBlockListPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(XBBlockListPanel.class);
    private Mode mode = Mode.TABLE;
    private XBBlockTablePanel blockTablePanel = new XBBlockTablePanel();
    private final List<DocumentItemSelectionListener> itemSelectionListeners = new ArrayList<DocumentItemSelectionListener>();
    private XbupTreeDocument treeDocument;
    private JToggleButton iconMatrixToggleButton;
    private ButtonGroup modeButtonGroup;
    private JToggleButton namesListToggleButton;
    private JToggleButton tableToggleButton;
    private JToolBar toolBar;

    public XBBlockListPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.toolBar.setFloatable(false);
        this.add((Component)this.blockTablePanel, "Center");
        this.blockTablePanel.addItemSelectionListener(item -> {
            if (this.mode == Mode.TABLE) {
                this.notifyItemSelectionChanged(item);
            }
        });
    }

    public void setTreeDocument(XbupTreeDocument treeDocument) {
        this.treeDocument = treeDocument;
        this.blockTablePanel.setTreeDocument(treeDocument);
    }

    public void setBlock(@Nullable XBTBlock block) {
        this.blockTablePanel.setBlock(block);
    }

    @Nonnull
    public Optional<XBTBlock> getSelectedItem() {
        switch (this.mode) {
            case ICON_MATRIX: {
                return Optional.empty();
            }
            case NAMES_LIST: {
                return Optional.empty();
            }
            case TABLE: {
                return this.blockTablePanel.getSelectedItem();
            }
        }
        throw XBFrameworkUtils.getInvalidTypeException((Enum)this.mode);
    }

    public void addItemSelectionListener(DocumentItemSelectionListener listener) {
        this.itemSelectionListeners.add(listener);
    }

    public void removeItemSelectionListener(DocumentItemSelectionListener listener) {
        this.itemSelectionListeners.remove(listener);
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.blockTablePanel.setPopupMenu(popupMenu);
    }

    private void notifyItemSelectionChanged(@Nullable XBTBlock item) {
        for (DocumentItemSelectionListener listener : this.itemSelectionListeners) {
            listener.itemSelected(item);
        }
    }

    private void initComponents() {
        this.modeButtonGroup = new ButtonGroup();
        this.toolBar = new JToolBar();
        this.iconMatrixToggleButton = new JToggleButton();
        this.namesListToggleButton = new JToggleButton();
        this.tableToggleButton = new JToggleButton();
        this.setLayout(new BorderLayout());
        this.modeButtonGroup.add(this.iconMatrixToggleButton);
        this.iconMatrixToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/xbup/resources/icons/open_icon_library-standard/icons/png/16x16/actions/view-list-icon-4.png")));
        this.iconMatrixToggleButton.setEnabled(false);
        this.iconMatrixToggleButton.setFocusable(false);
        this.iconMatrixToggleButton.setHorizontalTextPosition(0);
        this.iconMatrixToggleButton.setVerticalTextPosition(3);
        this.iconMatrixToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XBBlockListPanel.this.iconMatrixToggleButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.iconMatrixToggleButton);
        this.modeButtonGroup.add(this.namesListToggleButton);
        this.namesListToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/xbup/resources/icons/open_icon_library-standard/icons/png/16x16/actions/view-list-details-6.png")));
        this.namesListToggleButton.setEnabled(false);
        this.namesListToggleButton.setFocusable(false);
        this.namesListToggleButton.setHorizontalTextPosition(0);
        this.namesListToggleButton.setVerticalTextPosition(3);
        this.namesListToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XBBlockListPanel.this.namesListToggleButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.namesListToggleButton);
        this.modeButtonGroup.add(this.tableToggleButton);
        this.tableToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/xbup/resources/icons/open_icon_library-standard/icons/png/16x16/actions/table.png")));
        this.tableToggleButton.setSelected(true);
        this.tableToggleButton.setEnabled(false);
        this.tableToggleButton.setFocusable(false);
        this.tableToggleButton.setHorizontalTextPosition(0);
        this.tableToggleButton.setVerticalTextPosition(3);
        this.tableToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XBBlockListPanel.this.tableToggleButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.tableToggleButton);
        this.add((Component)this.toolBar, "North");
    }

    private void iconMatrixToggleButtonActionPerformed(ActionEvent evt) {
        this.setMode(Mode.ICON_MATRIX);
    }

    private void namesListToggleButtonActionPerformed(ActionEvent evt) {
        this.setMode(Mode.NAMES_LIST);
    }

    private void tableToggleButtonActionPerformed(ActionEvent evt) {
        this.setMode(Mode.TABLE);
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new XBBlockListPanel());
    }

    @Nonnull
    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        if (this.mode == mode) {
            return;
        }
        this.mode = mode;
    }

    public static enum Mode {
        ICON_MATRIX,
        NAMES_LIST,
        TABLE;

    }
}

