/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.options.impl;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.editor.xbup.options.ServiceConnectionOptions;
import org.exbin.framework.editor.xbup.preferences.ServiceConnectionPreferences;
import org.exbin.framework.options.api.OptionsData;

@ParametersAreNonnullByDefault
public class ServiceConnectionOptionsImpl
implements OptionsData,
ServiceConnectionOptions {
    private boolean serviceConnectionAllowed;
    private String serviceConnectionUrl;
    private boolean catalogUpdateAllowed;
    private String catalogUpdateUrl;

    @Override
    public boolean isServiceConnectionAllowed() {
        return this.serviceConnectionAllowed;
    }

    @Override
    public void setServiceConnectionAllowed(boolean serviceConnectionAllowed) {
        this.serviceConnectionAllowed = serviceConnectionAllowed;
    }

    @Override
    @Nonnull
    public Optional<String> getServiceConnectionUrl() {
        return Optional.ofNullable(this.serviceConnectionUrl);
    }

    @Override
    public void setServiceConnectionUrl(@Nullable String serviceConnectionUrl) {
        this.serviceConnectionUrl = serviceConnectionUrl;
    }

    @Override
    public boolean isCatalogUpdateAllowed() {
        return this.catalogUpdateAllowed;
    }

    @Override
    public void setCatalogUpdateAllowed(boolean catalogUpdateAllowed) {
        this.catalogUpdateAllowed = catalogUpdateAllowed;
    }

    @Override
    @Nonnull
    public Optional<String> getCatalogUpdateUrl() {
        return Optional.ofNullable(this.catalogUpdateUrl);
    }

    @Override
    public void setCatalogUpdateUrl(@Nullable String catalogUpdateUrl) {
        this.catalogUpdateUrl = catalogUpdateUrl;
    }

    public void loadFromPreferences(ServiceConnectionPreferences preferences) {
        this.serviceConnectionAllowed = preferences.isServiceConnectionAllowed();
        this.serviceConnectionUrl = preferences.getServiceConnectionUrl().orElse(null);
        this.catalogUpdateAllowed = preferences.isCatalogUpdateAllowed();
        this.catalogUpdateUrl = preferences.getCatalogUpdateUrl().orElse(null);
    }

    public void saveToPreferences(ServiceConnectionPreferences preferences) {
        preferences.setServiceConnectionAllowed(this.serviceConnectionAllowed);
        preferences.setServiceConnectionUrl(this.serviceConnectionUrl);
        preferences.setCatalogUpdateAllowed(this.catalogUpdateAllowed);
        preferences.setCatalogUpdateUrl(this.catalogUpdateUrl);
    }
}

