/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.gui;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.definition.XBParamType;
import org.exbin.xbup.core.catalog.base.XBCSpecDef;
import org.exbin.xbup.plugin.XBRowEditor;

@ParametersAreNonnullByDefault
public class XBPropertyTableItem {
    private XBCSpecDef specDef;
    private String valueName;
    private String typeName;
    private XBRowEditor rowEditor;

    public XBPropertyTableItem(XBCSpecDef specDef, String valueName, String typeName, @Nullable XBRowEditor rowEditor) {
        this.specDef = specDef;
        this.valueName = valueName;
        this.typeName = typeName;
        this.rowEditor = rowEditor;
    }

    public XBPropertyTableItem(XBCSpecDef specDef, String name, String type) {
        this(specDef, name, type, null);
    }

    @Nonnull
    public XBCSpecDef getSpecDef() {
        return this.specDef;
    }

    public void setSpecDef(XBCSpecDef specDef) {
        this.specDef = specDef;
    }

    @Nonnull
    public String getValueName() {
        return this.valueName;
    }

    public void setValueName(String valueName) {
        this.valueName = valueName;
    }

    @Nonnull
    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Nullable
    public XBRowEditor getRowEditor() {
        return this.rowEditor;
    }

    public void setRowEditor(@Nullable XBRowEditor rowEditor) {
        this.rowEditor = rowEditor;
    }

    @Nonnull
    public String getDefTypeName() {
        String defTypeName = "";
        if (!this.specDef.getTargetRev().isPresent()) {
            switch (this.specDef.getType()) {
                case CONSIST: 
                case LIST_CONSIST: {
                    defTypeName = "Any";
                    break;
                }
                case JOIN: 
                case LIST_JOIN: {
                    defTypeName = "Attribute";
                }
            }
        } else {
            defTypeName = this.typeName;
        }
        if (this.specDef.getType() == XBParamType.LIST_CONSIST || this.specDef.getType() == XBParamType.LIST_JOIN) {
            defTypeName = defTypeName + "[]";
        }
        return defTypeName;
    }
}

