/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.gui;

import java.awt.Color;
import java.awt.Component;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.exbin.framework.editor.xbup.viewer.XbupTreeDocument;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.parser_tree.XBTTreeNode;

@ParametersAreNonnullByDefault
public class XBDocTreeCellRenderer
extends DefaultTreeCellRenderer {
    private XbupTreeDocument treeDocument;
    private final ImageIcon dataBlockIcon = new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/xbup/resources/icons/data-block-16x16.png"));

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof XBTTreeNode) {
            XBTTreeNode node = (XBTTreeNode)value;
            ImageIcon icon = null;
            String caption = null;
            if (node.getDataMode() == XBBlockDataMode.DATA_BLOCK) {
                caption = node.getDataSize() == 0L ? "Empty Block" : "Data Block";
                icon = this.dataBlockIcon;
            } else {
                if (this.treeDocument != null) {
                    caption = this.treeDocument.getBlockCaption(node.getBlockDecl());
                }
                if (this.treeDocument != null) {
                    icon = this.treeDocument.getBlockIcon(node.getBlockDecl());
                }
            }
            if (caption != null) {
                this.setText(caption);
            } else {
                this.setText("Undefined");
                this.setForeground(Color.RED);
            }
            if (icon != null) {
                this.setIcon(icon);
            }
        }
        return this;
    }

    public void setTreeDocument(XbupTreeDocument treeDocument) {
        this.treeDocument = treeDocument;
    }
}

