/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.xbup.gui.GeneralBlockPropertiesPanel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.xbup.catalog.item.gui.CatalogItemInfoPanel;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.declaration.XBBlockDecl;
import org.exbin.xbup.core.block.declaration.catalog.XBCBlockDecl;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.parser_tree.XBTTreeNode;

@ParametersAreNonnullByDefault
public class BlockPropertiesPanel
extends JPanel {
    private XBTBlock block;
    private XBACatalog catalog;
    private final GeneralBlockPropertiesPanel generalPanel = new GeneralBlockPropertiesPanel();
    private final CatalogItemInfoPanel catalogItemPanel;
    private boolean devMode = false;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(BlockPropertiesPanel.class);
    private XBApplication application;
    private JTabbedPane tabbedPane;

    public BlockPropertiesPanel() {
        this.catalogItemPanel = new CatalogItemInfoPanel();
        this.catalogItemPanel.setMode(CatalogItemInfoPanel.Mode.FULL);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tabbedPane.addTab(this.resourceBundle.getString("generalPanel.tabTitle"), this.generalPanel);
        this.tabbedPane.addTab(this.resourceBundle.getString("typePanel.tabTitle"), (Component)this.catalogItemPanel);
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new BlockPropertiesPanel());
    }

    public void setBlock(XBTBlock block) {
        XBBlockDecl decl;
        this.block = block;
        this.generalPanel.setBlock(block);
        XBBlockDecl xBBlockDecl = decl = block instanceof XBTTreeNode ? ((XBTTreeNode)block).getBlockDecl() : null;
        if (decl instanceof XBCBlockDecl) {
            XBCBlockSpec spec = ((XBCBlockDecl)decl).getBlockSpecRev().getParent();
            this.catalogItemPanel.setItem((XBCItem)spec);
        } else {
            this.catalogItemPanel.setItem(null);
        }
    }

    @Nullable
    public XBACatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(@Nullable XBACatalog catalog) {
        this.catalog = catalog;
        this.generalPanel.setCatalog(catalog);
        this.catalogItemPanel.setCatalog(catalog);
    }

    public void setDevMode(boolean devMode) {
        this.devMode = devMode;
        this.generalPanel.setDevMode(devMode);
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        this.generalPanel.setApplication(application);
    }
}

