/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.def.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.component.api.ActionsProvider;
import org.exbin.framework.component.api.toolbar.EditItemActionsUpdateListener;
import org.exbin.framework.component.gui.ToolBarSidePanel;
import org.exbin.framework.editor.xbup.def.model.AttributesTableModel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.parser.token.XBAttribute;

@ParametersAreNonnullByDefault
public class AttributesPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(AttributesPanel.class);
    private AttributesTableModel attributesTableModel = new AttributesTableModel();
    private XBApplication application;
    private final ToolBarSidePanel toolBarPanel = new ToolBarSidePanel();
    private JScrollPane attributesScrollPane;
    private JTable attributesTable;

    public AttributesPanel() {
        this.initComponents();
        this.toolBarPanel.setToolBarPosition(ToolBarSidePanel.ToolBarPosition.RIGHT);
        this.add((Component)this.toolBarPanel, "East");
    }

    public void setAttributesTableModel(AttributesTableModel attributesTableModel) {
        this.attributesTableModel = attributesTableModel;
        this.attributesTable.setModel(attributesTableModel);
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    @Nonnull
    public JTable getAttributesTable() {
        return this.attributesTable;
    }

    private void initComponents() {
        this.attributesScrollPane = new JScrollPane();
        this.attributesTable = new JTable(this.attributesTableModel){

            @Override
            public boolean editCellAt(int row, int column, EventObject e) {
                boolean result = super.editCellAt(row, column, e);
                final Component editor = this.getEditorComponent();
                if (editor == null || !(editor instanceof JTextComponent)) {
                    return result;
                }
                if (e instanceof MouseEvent) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((JTextComponent)editor).selectAll();
                        }
                    });
                } else {
                    ((JTextComponent)editor).selectAll();
                }
                return result;
            }
        };
        this.setLayout(new BorderLayout());
        this.attributesTable.setModel(this.attributesTableModel);
        this.attributesTable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AttributesPanel.this.attributesTablePropertyChange(evt);
            }
        });
        this.attributesScrollPane.setViewportView(this.attributesTable);
        this.add((Component)this.attributesScrollPane, "Center");
    }

    private void attributesTablePropertyChange(PropertyChangeEvent evt) {
        this.attributesTable.repaint();
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new AttributesPanel());
    }

    public void setCatalog(XBACatalog catalog) {
    }

    public void addActions(ActionsProvider actionsProvider) {
        this.toolBarPanel.addActions(actionsProvider);
    }

    public void setPanelPopup(JPopupMenu popupMenu) {
        this.attributesTable.setComponentPopupMenu(popupMenu);
    }

    public void addSelectionListener(EditItemActionsUpdateListener updateListener) {
        this.attributesTable.getSelectionModel().addListSelectionListener(e -> updateListener.stateChanged());
    }

    @Nullable
    public XBAttribute getSelectedRow() {
        int selectedRow = this.attributesTable.getSelectedRow();
        if (selectedRow >= 0) {
            return this.attributesTableModel.getAttribs().get(selectedRow);
        }
        return null;
    }
}

