/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.def;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.bined.EditOperation;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.bined.BinEdFileHandler;
import org.exbin.framework.bined.BinaryStatusApi;
import org.exbin.framework.bined.BinedModule;
import org.exbin.framework.bined.action.GoToPositionAction;
import org.exbin.framework.bined.gui.BinEdComponentPanel;
import org.exbin.framework.bined.gui.BinaryStatusPanel;
import org.exbin.framework.bined.handler.CodeAreaPopupMenuHandler;
import org.exbin.framework.component.api.ActionsProvider;
import org.exbin.framework.editor.text.EncodingsHandler;
import org.exbin.framework.editor.xbup.def.action.ExportDataAction;
import org.exbin.framework.editor.xbup.def.action.ImportDataAction;
import org.exbin.framework.editor.xbup.def.gui.BinaryDataPanel;
import org.exbin.framework.editor.xbup.gui.BinaryToolbarPanel;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.parser_tree.XBTTreeNode;

@ParametersAreNonnullByDefault
public class BinaryDataEditor {
    private BinaryDataPanel editorPanel = new BinaryDataPanel();
    private XBApplication application;
    private XBACatalog catalog;
    private JPopupMenu popupMenu;
    private final ActionsProvider actions;
    private boolean extraBarsAdded = false;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(BinaryDataEditor.class);
    private ImportDataAction importDataAction = new ImportDataAction();
    private ExportDataAction exportDataAction = new ExportDataAction();

    public BinaryDataEditor() {
        this.actions = sideToolBar -> {
            sideToolBar.addAction((Action)this.importDataAction);
            sideToolBar.addAction((Action)this.exportDataAction);
        };
        this.editorPanel.addActions(this.actions);
    }

    @Nonnull
    public BinaryDataPanel getEditorPanel() {
        return this.editorPanel;
    }

    public void setApplication(final XBApplication application) {
        this.application = application;
        this.editorPanel.setApplication(application);
        this.importDataAction.setup(application);
        this.exportDataAction.setup(application);
        final BinedModule binedModule = (BinedModule)application.getModuleRepository().getModuleByInterface(BinedModule.class);
        final CodeAreaPopupMenuHandler codeAreaPopupMenuHandler = binedModule.createCodeAreaPopupMenuHandler(BinedModule.PopupMenuVariant.NORMAL);
        this.popupMenu = new JPopupMenu(){

            @Override
            public void show(Component invoker, int x, int y) {
                int clickedX = x;
                int clickedY = y;
                if (invoker instanceof JViewport) {
                    clickedX += ((JViewport)invoker).getParent().getX();
                    clickedY += ((JViewport)invoker).getParent().getY();
                }
                ExtCodeArea codeArea = BinaryDataEditor.this.editorPanel.getComponentPanel().getCodeArea();
                JPopupMenu popupMenu = codeAreaPopupMenuHandler.createPopupMenu(codeArea, BinedModule.BINARY_POPUP_MENU_ID + ".BinaryDataEditor", clickedX, clickedY);
                popupMenu.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        codeAreaPopupMenuHandler.dropPopupMenu(BinedModule.BINARY_POPUP_MENU_ID + ".BinaryDataEditor");
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent e) {
                    }
                });
                JMenuItem importDataMenuItem = ActionUtils.actionToMenuItem((Action)BinaryDataEditor.this.importDataAction);
                importDataMenuItem.setText(BinaryDataEditor.this.importDataAction.getValue("Name") + "...");
                popupMenu.add(importDataMenuItem);
                JMenuItem exportDataMenuItem = ActionUtils.actionToMenuItem((Action)BinaryDataEditor.this.exportDataAction);
                exportDataMenuItem.setText(BinaryDataEditor.this.exportDataAction.getValue("Name") + "...");
                popupMenu.add(exportDataMenuItem);
                binedModule.updateActionStatus((CodeAreaCore)codeArea);
                popupMenu.show(invoker, x, y);
            }
        };
        this.editorPanel.setDataPopupMenu(this.popupMenu);
        this.editorPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                BinedModule binedModule = (BinedModule)application.getModuleRepository().getModuleByInterface(BinedModule.class);
                binedModule.updateActionStatus((CodeAreaCore)BinaryDataEditor.this.editorPanel.getComponentPanel().getCodeArea());
            }
        });
    }

    public void attachExtraBars() {
        if (this.extraBarsAdded) {
            return;
        }
        final BinedModule binedModule = (BinedModule)this.application.getModuleRepository().getModuleByInterface(BinedModule.class);
        final BinEdComponentPanel binaryPanel = this.editorPanel.getComponentPanel();
        ExtCodeArea codeArea = binaryPanel.getCodeArea();
        BinaryToolbarPanel binaryToolbarPanel = new BinaryToolbarPanel();
        binaryToolbarPanel.setCodeArea(codeArea);
        binaryPanel.add((Component)binaryToolbarPanel, (Object)"North");
        BinaryStatusPanel binaryStatusPanel = new BinaryStatusPanel();
        binaryStatusPanel.setStatusControlHandler(new BinaryStatusPanel.StatusControlHandler(){

            public void changeEditOperation(EditOperation operation) {
                binaryPanel.getCodeArea().setEditOperation(operation);
            }

            public void changeCursorPosition() {
                GoToPositionAction goToPositionAction = binedModule.getGoToPositionAction();
                goToPositionAction.actionPerformed(null);
            }

            public void cycleEncodings() {
                EncodingsHandler encodingsHandler = binedModule.getEncodingsHandler();
                encodingsHandler.cycleEncodings();
            }

            public void encodingsPopupEncodingsMenu(MouseEvent mouseEvent) {
                EncodingsHandler encodingsHandler = binedModule.getEncodingsHandler();
                encodingsHandler.popupEncodingsMenu(mouseEvent);
            }

            public void changeMemoryMode(BinaryStatusApi.MemoryMode memoryMode) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        codeArea.addSelectionChangedListener(() -> binaryStatusPanel.setSelectionRange(codeArea.getSelection()));
        long dataSize = codeArea.getDataSize();
        binaryStatusPanel.setCurrentDocumentSize(dataSize, dataSize);
        codeArea.addCaretMovedListener(caretPosition -> binaryStatusPanel.setCursorPosition(caretPosition));
        codeArea.addEditModeChangedListener((mode, operation) -> binaryStatusPanel.setEditMode(mode, operation));
        binaryPanel.add((Component)binaryStatusPanel, (Object)"South");
        binaryPanel.revalidate();
        binaryPanel.repaint();
        this.extraBarsAdded = true;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    public void setBlock(XBTTreeNode block) {
        try {
            BinEdFileHandler binaryDataFile = new BinEdFileHandler();
            binaryDataFile.loadFromStream(block.getData(), block.getDataSize());
            this.editorPanel.setFileHandler(binaryDataFile);
        }
        catch (IOException ex) {
            Logger.getLogger(BinaryDataEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setContentData(BinaryData binaryData) {
        this.editorPanel.setContentData(binaryData);
    }
}

