/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.action;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.xbup.gui.DocumentPropertiesPanel;
import org.exbin.framework.editor.xbup.viewer.XbupEditorProvider;
import org.exbin.framework.editor.xbup.viewer.XbupFileHandler;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.CloseControlPanel;
import org.exbin.xbup.core.block.XBTEditableDocument;

@ParametersAreNonnullByDefault
public class DocumentPropertiesAction
extends AbstractAction {
    public static final String ACTION_ID = "propertiesAction";
    private XbupEditorProvider editorProvider;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(DocumentPropertiesAction.class);

    public void setup(XbupEditorProvider editorProvider) {
        this.editorProvider = editorProvider;
        ActionUtils.setupAction((Action)this, (ResourceBundle)this.resourceBundle, (String)ACTION_ID);
        this.putValue("dialogMode", true);
        this.setEnabled(false);
        editorProvider.addItemSelectionListener(item -> this.setEnabled(item != null));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        XBApplication application = this.editorProvider.getApplication();
        FrameModuleApi frameModule = (FrameModuleApi)application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        DocumentPropertiesPanel propertiesPanel = new DocumentPropertiesPanel();
        Optional activeFile = this.editorProvider.getActiveFile();
        if (!activeFile.isPresent()) {
            return;
        }
        XbupFileHandler xbupFile = (XbupFileHandler)this.editorProvider.getActiveFile().get();
        propertiesPanel.setDocument((XBTEditableDocument)xbupFile.getDocument());
        propertiesPanel.setDocumentUri(((FileHandler)activeFile.get()).getFileUri().orElse(null));
        CloseControlPanel controlPanel = new CloseControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)propertiesPanel, (JPanel)controlPanel);
        WindowUtils.addHeaderPanel((Window)dialog.getWindow(), propertiesPanel.getClass(), (ResourceBundle)propertiesPanel.getResourceBundle());
        frameModule.setDialogTitle(dialog, propertiesPanel.getResourceBundle());
        controlPanel.setHandler(() -> {
            dialog.close();
            dialog.dispose();
        });
        dialog.showCentered((Component)e.getSource());
    }
}

