/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.type;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.serial.child.XBChildInputSerialHandler;
import org.exbin.xbup.core.serial.child.XBChildOutputSerialHandler;
import org.exbin.xbup.core.serial.child.XBChildSerializable;
import org.exbin.xbup.core.serial.child.XBTChildInputSerialHandler;
import org.exbin.xbup.core.serial.child.XBTChildOutputSerialHandler;
import org.exbin.xbup.core.serial.child.XBTChildSerializable;
import org.exbin.xbup.core.util.StreamUtils;

@ParametersAreNonnullByDefault
public class XBChar
implements XBTChildSerializable {
    private Character value;
    static long[] XBUP_BLOCKREV_CATALOGPATH = new long[]{1L, 3L, 1L, 2L, 2L, 0L};
    static long[] XBUP_FORMATREV_CATALOGPATH = new long[]{1L, 3L, 1L, 2L, 0L, 0L};

    public XBChar() {
        this.value = null;
    }

    public XBChar(Character value) {
        this.value = value;
    }

    public Character getValue() {
        return this.value;
    }

    public void setValue(Character value) {
        this.value = value;
    }

    @Override
    public void serializeFromXB(XBTChildInputSerialHandler serial) throws XBProcessingException, IOException {
        serial.pullBegin();
        serial.pullChild(new DataBlockSerializator());
        serial.pullEnd();
    }

    @Override
    public void serializeToXB(XBTChildOutputSerialHandler serial) throws XBProcessingException, IOException {
        serial.putBegin(XBBlockTerminationMode.SIZE_SPECIFIED);
        serial.putType(new XBDeclBlockType(XBUP_BLOCKREV_CATALOGPATH));
        serial.putChild(new DataBlockSerializator());
        serial.putEnd();
    }

    @ParametersAreNonnullByDefault
    public class DataBlockSerializator
    implements XBTChildSerializable {
        @Override
        public void serializeFromXB(XBTChildInputSerialHandler serial) throws XBProcessingException, IOException {
            serial.pullBegin();
            InputStream source = serial.pullData();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                StreamUtils.copyInputStreamToOutputStream(source, stream);
            }
            catch (IOException ex) {
                Logger.getLogger(XBChar.class.getName()).log(Level.SEVERE, null, ex);
            }
            XBChar.this.setValue(Character.valueOf(new String(stream.toByteArray()).charAt(0)));
            serial.pullEnd();
        }

        @Override
        public void serializeToXB(XBTChildOutputSerialHandler serial) throws XBProcessingException, IOException {
            serial.putBegin(XBBlockTerminationMode.SIZE_SPECIFIED);
            serial.putData(new ByteArrayInputStream(XBChar.this.getValue().toString().getBytes()));
            serial.putEnd();
        }
    }

    @ParametersAreNonnullByDefault
    public class ChildSerializer
    implements XBChildSerializable {
        @Override
        public void serializeFromXB(XBChildInputSerialHandler serial) throws XBProcessingException, IOException {
            InputStream source = serial.nextData();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                StreamUtils.copyInputStreamToOutputStream(source, stream);
            }
            catch (IOException ex) {
                Logger.getLogger(XBChar.class.getName()).log(Level.SEVERE, null, ex);
            }
            XBChar.this.setValue(Character.valueOf(new String(stream.toByteArray()).charAt(0)));
            serial.end();
        }

        @Override
        public void serializeToXB(XBChildOutputSerialHandler serial) throws XBProcessingException, IOException {
            if (XBChar.this.getValue() != null) {
                serial.addData(new ByteArrayInputStream(XBChar.this.getValue().toString().getBytes()));
            } else {
                serial.addData(new ByteArrayInputStream(new byte[0]));
            }
            serial.end();
        }
    }
}

