/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.serial.param;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBTListener;
import org.exbin.xbup.core.parser.basic.XBTProducer;
import org.exbin.xbup.core.parser.basic.convert.XBTConsumerToListener;
import org.exbin.xbup.core.parser.param.XBParamProcessingState;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.parser.token.XBEditableAttribute;
import org.exbin.xbup.core.parser.token.XBTAttributeToken;
import org.exbin.xbup.core.parser.token.XBTBeginToken;
import org.exbin.xbup.core.parser.token.XBTDataToken;
import org.exbin.xbup.core.parser.token.XBTEndToken;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTokenType;
import org.exbin.xbup.core.parser.token.XBTTypeToken;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;
import org.exbin.xbup.core.parser.token.event.convert.XBTCompactingEventFilter;
import org.exbin.xbup.core.parser.token.event.convert.XBTListenerToEventListener;
import org.exbin.xbup.core.parser.token.pull.XBTPullConsumer;
import org.exbin.xbup.core.parser.token.pull.convert.XBTPullConsumerToConsumer;
import org.exbin.xbup.core.serial.XBSerialException;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.basic.XBTBasicOutputSerialHandler;
import org.exbin.xbup.core.serial.basic.XBTBasicSerializable;
import org.exbin.xbup.core.serial.child.XBTChildOutputSerialHandler;
import org.exbin.xbup.core.serial.child.XBTChildSerializable;
import org.exbin.xbup.core.serial.param.XBPListener;
import org.exbin.xbup.core.serial.param.XBPOutputSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.param.XBPSerializable;
import org.exbin.xbup.core.serial.param.XBPTokenWrapper;
import org.exbin.xbup.core.serial.param.XBSerializationMode;
import org.exbin.xbup.core.serial.sequence.XBListConsistSerializable;
import org.exbin.xbup.core.serial.sequence.XBListJoinSerializable;
import org.exbin.xbup.core.serial.sequence.XBSerialSequenceItem;
import org.exbin.xbup.core.serial.sequence.XBSerialSequenceOp;
import org.exbin.xbup.core.serial.token.XBTTokenOutputSerialHandler;
import org.exbin.xbup.core.stream.XBInput;
import org.exbin.xbup.core.ubnumber.UBENatural;
import org.exbin.xbup.core.ubnumber.UBNatural;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

@ParametersAreNonnullByDefault
public class XBPListenerSerialHandler
implements XBPOutputSerialHandler,
XBPSequenceSerialHandler,
XBTTokenOutputSerialHandler {
    private XBTCompactingEventFilter eventListener;
    private XBParamProcessingState processingState = XBParamProcessingState.START;
    private final List<Processing> processings = new ArrayList<Processing>();
    private int subDepth = 0;
    private static final String PULL_NOT_ALLOWED_EXCEPTION = "Pulling data not allowed in pushing mode";

    public XBPListenerSerialHandler() {
        this.processings.add(new Processing());
    }

    public XBPListenerSerialHandler(XBInput input) {
        this();
        this.performAttachXBInput(input);
    }

    private void processItem(XBSerialSequenceOp op, @Nullable XBTTokenType tokenType, @Nullable XBSerialSequenceItem item, @Nullable XBTToken token) throws XBProcessingException, IOException {
        boolean loop;
        do {
            Processing currentState;
            block35: {
                block33: {
                    block34: {
                        if (!(currentState = this.getCurrentState()).isCollecting()) break block33;
                        if (this.subDepth <= 0) break block34;
                        currentState.childSequence.putItem(item != null ? item : new XBSerialSequenceItem(XBSerialSequenceOp.TOKEN, new XBPTokenWrapper(token)));
                        if (op == XBSerialSequenceOp.TOKEN) {
                            switch (tokenType) {
                                case BEGIN: {
                                    ++this.subDepth;
                                    break;
                                }
                                case END: {
                                    --this.subDepth;
                                }
                            }
                        }
                        break block35;
                    }
                    switch (op) {
                        case CONSIST: {
                            currentState.childSequence.putItem(item);
                            break block35;
                        }
                        case JOIN: {
                            XBPSerialSequence seq = new XBPSerialSequence();
                            this.extractSerial(Objects.requireNonNull(item).getItem(), seq);
                            seq.dropLevel();
                            currentState.extractionSequence.insertAtBegining(seq);
                            break block35;
                        }
                        case LIST_CONSIST: {
                            XBPSerialSequence seq = new XBPSerialSequence();
                            XBSerializable list = (XBListConsistSerializable)Objects.requireNonNull(item).getItem();
                            this.extractConsistList((XBListConsistSerializable)list, seq);
                            currentState.extractionSequence.insertAtBegining(seq);
                            break block35;
                        }
                        case LIST_JOIN: {
                            XBPSerialSequence seq = new XBPSerialSequence();
                            XBSerializable list = (XBListJoinSerializable)Objects.requireNonNull(item).getItem();
                            this.extractJoinList((XBListJoinSerializable)list, seq);
                            currentState.extractionSequence.insertAtBegining(seq);
                            break block35;
                        }
                        case TOKEN: {
                            switch (tokenType) {
                                case BEGIN: {
                                    ++this.subDepth;
                                    currentState.childSequence.putItem(item != null ? item : new XBSerialSequenceItem(XBSerialSequenceOp.TOKEN, new XBPTokenWrapper(token)));
                                    break block35;
                                }
                                case TYPE: {
                                    throw new XBProcessingException("Unexpected token order", XBProcessingExceptionType.UNEXPECTED_ORDER);
                                }
                                case ATTRIBUTE: {
                                    this.eventListener.putXBTToken(this.convertToToken(item, token));
                                    break block35;
                                }
                                case DATA: {
                                    throw new XBProcessingException("Unexpected token order", XBProcessingExceptionType.UNEXPECTED_ORDER);
                                }
                                case END: {
                                    currentState.mode = Mode.END;
                                    break block35;
                                }
                                default: {
                                    throw new IllegalStateException("Unexpected token type " + tokenType.name());
                                }
                            }
                        }
                        default: {
                            throw new XBProcessingException("Unexpected operation order", XBProcessingExceptionType.UNEXPECTED_ORDER);
                        }
                    }
                }
                if (currentState.isPassing()) {
                    this.eventListener.putXBTToken(this.convertToToken(item, token));
                } else {
                    switch (op) {
                        case TOKEN: {
                            this.processToken(tokenType, item, token);
                            break;
                        }
                        default: {
                            currentState.mode = Mode.COLLECTING;
                            currentState.childSequence.putItem(Objects.requireNonNull(item));
                        }
                    }
                }
            }
            loop = false;
            if (!currentState.extractionSequence.isEmpty()) {
                item = currentState.extractionSequence.pullItem();
                token = null;
                op = item.getSequenceOp();
                tokenType = item.getSequenceOp() == XBSerialSequenceOp.TOKEN ? ((XBPTokenWrapper)item.getItem()).getToken().getTokenType() : null;
                loop = true;
                continue;
            }
            if (currentState.mode != Mode.END) continue;
            while (currentState.childSequence.isEmpty() && currentState.mode == Mode.END) {
                this.processings.remove(this.processings.size() - 1);
                this.eventListener.putXBTToken(XBTEndToken.create());
                if (this.processings.isEmpty()) {
                    currentState = null;
                    break;
                }
                currentState = this.getCurrentState();
            }
            if (currentState == null || currentState.childSequence.isEmpty()) continue;
            Processing nextState = new Processing();
            this.processings.add(nextState);
            XBSerialSequenceItem nextItem = currentState.childSequence.pullItem();
            XBSerialSequenceOp nextOp = nextItem.getSequenceOp();
            switch (nextOp) {
                case CONSIST: {
                    this.extractSerial(nextItem.getItem(), nextState.extractionSequence);
                    break;
                }
                case TOKEN: {
                    nextState.extractionSequence.putItem(nextItem);
                    break;
                }
                default: {
                    throw new XBProcessingException("Unexpected operation order", XBProcessingExceptionType.UNEXPECTED_ORDER);
                }
            }
            while (!currentState.childSequence.isEmpty() && !nextState.extractionSequence.isClosed()) {
                nextState.extractionSequence.putItem(currentState.childSequence.pullItem());
            }
            this.processingState = XBParamProcessingState.START;
            item = nextState.extractionSequence.pullItem();
            token = null;
            op = item.getSequenceOp();
            tokenType = item.getSequenceOp() == XBSerialSequenceOp.TOKEN ? ((XBPTokenWrapper)item.getItem()).getToken().getTokenType() : null;
            loop = true;
        } while (loop);
    }

    private void processToken(XBTTokenType tokenType, @Nullable XBSerialSequenceItem item, @Nullable XBTToken token) throws XBProcessingException, IOException {
        Processing currentState = this.getCurrentState();
        block0 : switch (tokenType) {
            case BEGIN: {
                switch (this.processingState) {
                    case START: {
                        this.eventListener.putXBTToken(this.convertToToken(item, token));
                        this.processingState = XBParamProcessingState.BEGIN;
                        break block0;
                    }
                    case TYPE: 
                    case ATTRIBUTES: 
                    case CHILDREN: {
                        if (currentState.mode == Mode.BEGIN) {
                            currentState.mode = Mode.COLLECTING;
                            ++this.subDepth;
                            currentState.childSequence.putItem(this.convertToSequenceItem(item, token));
                            break block0;
                        }
                        this.eventListener.putXBTToken(this.convertToToken(item, token));
                        this.processingState = XBParamProcessingState.CHILDREN;
                        break block0;
                    }
                }
                throw new XBProcessingException("Unexpected token order", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
            case TYPE: {
                if (this.processingState == XBParamProcessingState.BEGIN) {
                    this.eventListener.putXBTToken(this.convertToToken(item, token));
                    this.processingState = XBParamProcessingState.TYPE;
                    break;
                }
                throw new XBProcessingException("Unexpected token order", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
            case ATTRIBUTE: {
                if (this.processingState == XBParamProcessingState.BEGIN || this.processingState == XBParamProcessingState.TYPE || this.processingState == XBParamProcessingState.ATTRIBUTES) {
                    this.eventListener.putXBTToken(this.convertToToken(item, token));
                    this.processingState = XBParamProcessingState.ATTRIBUTES;
                    break;
                }
                throw new XBProcessingException("Unexpected token order", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
            case DATA: {
                if (this.processingState == XBParamProcessingState.BEGIN) {
                    this.eventListener.putXBTToken(this.convertToToken(item, token));
                    this.processingState = XBParamProcessingState.DATA;
                    break;
                }
                throw new XBProcessingException("Unexpected token order", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
            case END: {
                if (this.processingState != XBParamProcessingState.BEGIN && this.processingState != XBParamProcessingState.START) {
                    this.processingState = XBParamProcessingState.END;
                    currentState.mode = Mode.END;
                    break;
                }
                throw new XBProcessingException("Unexpected token order", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
            default: {
                throw new IllegalStateException("Unexpected token type " + tokenType.name());
            }
        }
    }

    private void extractSerial(XBSerializable serial, XBPListener listener) throws IOException, XBProcessingException {
        if (serial instanceof XBPSerializable) {
            ((XBPSerializable)serial).serializeToXB(listener instanceof XBPOutputSerialHandler ? (XBPOutputSerialHandler)listener : new SerialHandlerWrapper(listener));
        } else if (serial instanceof XBPSequenceSerializable) {
            ((XBPSequenceSerializable)serial).serializeXB(listener instanceof XBPSequenceSerialHandler ? (XBPSequenceSerialHandler)listener : new SerialHandlerWrapper(listener));
        } else if (serial instanceof XBTChildSerializable) {
            ((XBTChildSerializable)serial).serializeToXB(listener instanceof XBTChildOutputSerialHandler ? (XBTChildOutputSerialHandler)((Object)listener) : new SerialHandlerWrapper(listener));
        } else if (serial instanceof XBTBasicSerializable) {
            ((XBTBasicSerializable)serial).serializeToXB(listener instanceof XBTBasicOutputSerialHandler ? (XBTBasicOutputSerialHandler)((Object)listener) : new SerialHandlerWrapper(listener));
        } else {
            throw new UnsupportedOperationException("Serialization method " + (serial == null ? "null" : serial.getClass().getCanonicalName()) + " not supported.");
        }
    }

    private void extractConsistList(XBListConsistSerializable list, XBPListener listener) throws IOException, XBProcessingException {
        UBENatural count = list.getSize();
        listener.putAttribute(count.convertToNatural());
        list.reset();
        int listSize = count.getInt();
        for (int i = 0; i < listSize; ++i) {
            listener.putConsist(list.next());
        }
    }

    private void extractJoinList(XBListJoinSerializable list, XBPListener listener) throws IOException, XBProcessingException {
        UBNatural count = list.getSize();
        listener.putAttribute(count.convertToNatural());
        list.reset();
        int listSize = count.getInt();
        for (int i = 0; i < listSize; ++i) {
            listener.putJoin(list.next());
        }
    }

    @Nonnull
    private XBTToken convertToToken(@Nullable XBSerialSequenceItem item, @Nullable XBTToken token) {
        return item != null ? ((XBPTokenWrapper)item.getItem()).getToken() : Objects.requireNonNull(token);
    }

    @Nonnull
    private XBSerialSequenceItem convertToSequenceItem(@Nullable XBSerialSequenceItem item, @Nullable XBTToken token) {
        return item != null ? item : new XBSerialSequenceItem(XBSerialSequenceOp.TOKEN, new XBPTokenWrapper(token));
    }

    public void process(XBSerializable serial) throws IOException, XBProcessingException {
        this.extractSerial(serial, this);
    }

    @Override
    public void attachXBTEventListener(XBTEventListener listener) {
        this.attachXBInput(listener);
    }

    public void attachXBInput(XBInput input) {
        this.performAttachXBInput(input);
    }

    private void performAttachXBInput(XBInput input) {
        if (input instanceof XBTEventListener) {
            this.attachListener((XBTEventListener)input);
        } else if (input instanceof XBTListener) {
            this.attachListener(new XBTListenerToEventListener((XBTListener)input));
        } else if (input instanceof XBTPullConsumer) {
            this.attachListener(new XBTListenerToEventListener(new XBTConsumerToListener(new XBTPullConsumerToConsumer((XBTPullConsumer)input))));
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private void attachListener(XBTEventListener eventListener) {
        this.eventListener = eventListener instanceof XBTCompactingEventFilter ? (XBTCompactingEventFilter)eventListener : new XBTCompactingEventFilter(eventListener);
    }

    @Override
    public void putBegin(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
        this.processItem(XBSerialSequenceOp.TOKEN, XBTTokenType.BEGIN, null, XBTBeginToken.create(terminationMode));
    }

    @Override
    public void putType(XBBlockType type) throws XBProcessingException, IOException {
        this.processItem(XBSerialSequenceOp.TOKEN, XBTTokenType.TYPE, null, XBTTypeToken.create(type));
    }

    @Override
    public void putAttribute(XBAttribute attribute) throws XBSerialException, XBProcessingException, IOException {
        this.processItem(XBSerialSequenceOp.TOKEN, XBTTokenType.ATTRIBUTE, null, XBTAttributeToken.create(attribute));
    }

    @Override
    public void putData(InputStream data) throws XBProcessingException, IOException {
        this.processItem(XBSerialSequenceOp.TOKEN, XBTTokenType.DATA, null, XBTDataToken.create(data));
    }

    @Override
    public void putEnd() throws XBProcessingException, IOException {
        this.processItem(XBSerialSequenceOp.TOKEN, XBTTokenType.END, null, XBTEndToken.create());
    }

    @Override
    public void putAttribute(byte attributeValue) throws XBProcessingException, IOException {
        this.putAttribute(new UBNat32(attributeValue));
    }

    @Override
    public void putAttribute(short attributeValue) throws XBProcessingException, IOException {
        this.putAttribute(new UBNat32(attributeValue));
    }

    @Override
    public void putAttribute(int attributeValue) throws XBProcessingException, IOException {
        this.putAttribute(new UBNat32(attributeValue));
    }

    @Override
    public void putAttribute(long attributeValue) throws XBProcessingException, IOException {
        this.putAttribute(new UBNat32(attributeValue));
    }

    @Override
    public void putToken(XBTToken token) throws XBProcessingException, IOException {
        this.processItem(XBSerialSequenceOp.TOKEN, token.getTokenType(), null, token);
    }

    @Override
    public void putConsist(XBSerializable serial) throws XBProcessingException, IOException {
        this.processItem(XBSerialSequenceOp.CONSIST, null, new XBSerialSequenceItem(XBSerialSequenceOp.CONSIST, serial), null);
    }

    @Override
    public void putJoin(XBSerializable serial) throws XBProcessingException, IOException {
        this.processItem(XBSerialSequenceOp.JOIN, null, new XBSerialSequenceItem(XBSerialSequenceOp.JOIN, serial), null);
    }

    @Override
    public void putListConsist(XBSerializable serial) throws XBProcessingException, IOException {
        this.processItem(XBSerialSequenceOp.LIST_CONSIST, null, new XBSerialSequenceItem(XBSerialSequenceOp.LIST_CONSIST, serial), null);
    }

    @Override
    public void putListJoin(XBSerializable serial) throws XBProcessingException, IOException {
        this.processItem(XBSerialSequenceOp.LIST_JOIN, null, new XBSerialSequenceItem(XBSerialSequenceOp.LIST_JOIN, serial), null);
    }

    @Override
    public void putItem(XBSerialSequenceItem item) throws XBProcessingException, IOException {
        this.processItem(item.getSequenceOp(), null, item, null);
    }

    @Nonnull
    private Processing getCurrentState() {
        return this.processings.get(this.processings.size() - 1);
    }

    @Override
    public void putAppend(XBSerializable serial) throws XBProcessingException, IOException {
        this.processItem(XBSerialSequenceOp.JOIN, null, new XBSerialSequenceItem(XBSerialSequenceOp.JOIN, serial), null);
    }

    @Override
    @Nonnull
    public XBSerializationMode getSerializationMode() {
        return XBSerializationMode.PUSH;
    }

    @Override
    public void begin() throws XBProcessingException, IOException {
        this.putBegin(XBBlockTerminationMode.SIZE_SPECIFIED);
    }

    @Override
    public void matchType(XBBlockType blockType) throws XBProcessingException, IOException {
        this.putType(blockType);
    }

    @Override
    public void matchType() throws XBProcessingException, IOException {
        this.matchType(XBFixedBlockType.UNKNOWN_BLOCK_TYPE);
    }

    @Override
    public void end() throws XBProcessingException, IOException {
        this.putEnd();
    }

    @Override
    public void attribute(XBEditableAttribute attributeValue) throws XBProcessingException, IOException {
        this.putAttribute(attributeValue);
    }

    @Override
    public void consist(XBSerializable serial) throws XBProcessingException, IOException {
        this.putConsist(serial);
    }

    @Override
    public void join(XBSerializable serial) throws XBProcessingException, IOException {
        this.putJoin(serial);
    }

    @Override
    public void listConsist(XBSerializable serial) throws XBProcessingException, IOException {
        this.putListConsist(serial);
    }

    @Override
    public void listJoin(XBSerializable serial) throws XBProcessingException, IOException {
        this.putListJoin(serial);
    }

    @Override
    public void append(XBSerializable serial) throws XBProcessingException, IOException {
        this.putAppend(serial);
    }

    @Override
    @Nonnull
    public XBBlockTerminationMode pullBegin() throws XBProcessingException, IOException {
        throw new XBProcessingException(PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    @Nonnull
    public XBBlockType pullType() throws XBProcessingException, IOException {
        throw new XBProcessingException(PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    @Nonnull
    public UBNatural pullAttribute() throws XBProcessingException, IOException {
        throw new XBProcessingException(PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public byte pullByteAttribute() throws XBProcessingException, IOException {
        throw new XBProcessingException(PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public short pullShortAttribute() throws XBProcessingException, IOException {
        throw new XBProcessingException(PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public int pullIntAttribute() throws XBProcessingException, IOException {
        throw new XBProcessingException(PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public long pullLongAttribute() throws XBProcessingException, IOException {
        throw new XBProcessingException(PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    @Nonnull
    public InputStream pullData() throws XBProcessingException, IOException {
        throw new XBProcessingException(PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public boolean pullIfEmptyData() throws XBProcessingException, IOException {
        throw new XBProcessingException(PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public boolean pullIfEmptyBlock() throws XBProcessingException, IOException {
        throw new XBProcessingException(PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public void pullEnd() throws XBProcessingException, IOException {
        throw new XBProcessingException(PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    @Nonnull
    public XBTToken pullToken(XBTTokenType tokenType) throws XBProcessingException, IOException {
        throw new XBProcessingException(PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    @Nonnull
    public XBTToken pullToken() throws XBProcessingException, IOException {
        throw new XBProcessingException(PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public void pullConsist(XBSerializable child) throws XBProcessingException, IOException {
        throw new XBProcessingException(PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public void pullJoin(XBSerializable serial) throws XBProcessingException, IOException {
        throw new XBProcessingException(PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public void pullListConsist(XBSerializable child) throws XBProcessingException, IOException {
        throw new XBProcessingException(PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public void pullListJoin(XBSerializable serial) throws XBProcessingException, IOException {
        throw new XBProcessingException(PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public void pullItem(XBSerialSequenceItem item) throws XBProcessingException, IOException {
        throw new XBProcessingException(PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public void pullAppend(XBSerializable serial) throws XBProcessingException, IOException {
        throw new XBProcessingException(PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public boolean isEndNext() {
        throw new XBProcessingException(PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public XBTTokenType getFutureTokenType() {
        throw new XBProcessingException(PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    private static enum Mode {
        BEGIN,
        COLLECTING,
        PASSING,
        END;

    }

    private static class Processing {
        Mode mode = Mode.BEGIN;
        XBPSerialSequence childSequence = new XBPSerialSequence();
        XBPSerialSequence extractionSequence = new XBPSerialSequence();

        private Processing() {
        }

        private boolean isCollecting() {
            return this.mode == Mode.COLLECTING;
        }

        private boolean isPassing() {
            return this.mode == Mode.PASSING;
        }
    }

    @ParametersAreNonnullByDefault
    private static class SerialHandlerWrapper
    implements XBTBasicOutputSerialHandler,
    XBTChildOutputSerialHandler,
    XBPOutputSerialHandler,
    XBPSequenceSerialHandler {
        private final XBPListener listener;

        public SerialHandlerWrapper(XBPListener listener) {
            this.listener = listener;
        }

        @Override
        public void putBegin(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
            this.listener.putBegin(terminationMode);
        }

        @Override
        public void putType(XBBlockType type) throws XBProcessingException, IOException {
            this.listener.putType(type);
        }

        @Override
        public void putAttribute(UBNatural attribute) throws XBProcessingException, IOException {
            this.listener.putAttribute(attribute);
        }

        @Override
        public void putAttribute(byte attributeValue) throws XBProcessingException, IOException {
            this.listener.putAttribute(attributeValue);
        }

        @Override
        public void putAttribute(short attributeValue) throws XBProcessingException, IOException {
            this.listener.putAttribute(attributeValue);
        }

        @Override
        public void putAttribute(int attributeValue) throws XBProcessingException, IOException {
            this.listener.putAttribute(attributeValue);
        }

        @Override
        public void putAttribute(long attributeValue) throws XBProcessingException, IOException {
            this.listener.putAttribute(attributeValue);
        }

        @Override
        public void putChild(XBSerializable child) throws XBProcessingException, IOException {
            this.listener.putConsist(child);
        }

        @Override
        public void putAppend(XBSerializable serial) throws XBProcessingException, IOException {
            this.listener.putAppend(serial);
        }

        @Override
        public void putData(InputStream data) throws XBProcessingException, IOException {
            this.listener.putData(data);
        }

        @Override
        public void putEnd() throws XBProcessingException, IOException {
            this.listener.putEnd();
        }

        @Override
        public void attachXBTEventListener(XBTEventListener listener) {
            throw new IllegalStateException();
        }

        @Override
        public XBSerializationMode getSerializationMode() {
            return XBSerializationMode.PUSH;
        }

        @Override
        public void begin() throws XBProcessingException, IOException {
            this.listener.putBegin(XBBlockTerminationMode.SIZE_SPECIFIED);
        }

        @Override
        public void matchType(XBBlockType blockType) throws XBProcessingException, IOException {
            this.putType(blockType);
        }

        @Override
        public void matchType() throws XBProcessingException, IOException {
            this.matchType(XBFixedBlockType.UNKNOWN_BLOCK_TYPE);
        }

        @Override
        public void end() throws XBProcessingException, IOException {
            this.listener.putEnd();
        }

        @Override
        public void attribute(XBEditableAttribute attributeValue) throws XBProcessingException, IOException {
            this.listener.putAttribute(attributeValue);
        }

        @Override
        public void consist(XBSerializable serial) throws XBProcessingException, IOException {
            this.listener.putConsist(serial);
        }

        @Override
        public void join(XBSerializable serial) throws XBProcessingException, IOException {
            this.listener.putJoin(serial);
        }

        @Override
        public void listConsist(XBSerializable serial) throws XBProcessingException, IOException {
            this.listener.putListConsist(serial);
        }

        @Override
        public void listJoin(XBSerializable serial) throws XBProcessingException, IOException {
            this.listener.putListJoin(serial);
        }

        @Override
        public void append(XBSerializable serial) throws XBProcessingException, IOException {
            this.listener.putAppend(serial);
        }

        @Override
        public void putAttribute(XBAttribute attribute) throws XBProcessingException, IOException {
            this.listener.putAttribute(attribute);
        }

        @Override
        public void putToken(XBTToken token) throws XBProcessingException, IOException {
            this.listener.putToken(token);
        }

        @Override
        public void putConsist(XBSerializable serial) throws XBProcessingException, IOException {
            this.listener.putConsist(serial);
        }

        @Override
        public void putJoin(XBSerializable serial) throws XBProcessingException, IOException {
            this.listener.putJoin(serial);
        }

        @Override
        public void putListConsist(XBSerializable serial) throws XBProcessingException, IOException {
            this.listener.putListConsist(serial);
        }

        @Override
        public void putListJoin(XBSerializable serial) throws XBProcessingException, IOException {
            this.listener.putListJoin(serial);
        }

        @Override
        public void putItem(XBSerialSequenceItem item) throws XBProcessingException, IOException {
            this.listener.putItem(item);
        }

        @Override
        public XBBlockTerminationMode pullBegin() throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPListenerSerialHandler.PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public XBBlockType pullType() throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPListenerSerialHandler.PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public XBAttribute pullAttribute() throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPListenerSerialHandler.PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public byte pullByteAttribute() throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPListenerSerialHandler.PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public short pullShortAttribute() throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPListenerSerialHandler.PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public int pullIntAttribute() throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPListenerSerialHandler.PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public long pullLongAttribute() throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPListenerSerialHandler.PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public InputStream pullData() throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPListenerSerialHandler.PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public boolean pullIfEmptyData() throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPListenerSerialHandler.PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public boolean pullIfEmptyBlock() throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPListenerSerialHandler.PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public void pullEnd() throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPListenerSerialHandler.PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public XBTToken pullToken(XBTTokenType tokenType) throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPListenerSerialHandler.PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public XBTToken pullToken() throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPListenerSerialHandler.PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public void pullConsist(XBSerializable child) throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPListenerSerialHandler.PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public void pullJoin(XBSerializable serial) throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPListenerSerialHandler.PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public void pullListConsist(XBSerializable child) throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPListenerSerialHandler.PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public void pullListJoin(XBSerializable serial) throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPListenerSerialHandler.PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public void pullItem(XBSerialSequenceItem item) throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPListenerSerialHandler.PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public void pullAppend(XBSerializable serial) throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPListenerSerialHandler.PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public boolean isEndNext() {
            throw new XBProcessingException(XBPListenerSerialHandler.PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public XBTTokenType getFutureTokenType() {
            throw new XBProcessingException(XBPListenerSerialHandler.PULL_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public void process(XBTProducer producer) {
            producer.attachXBTListener(new XBTListener(){

                @Override
                public void beginXBT(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
                    listener.putBegin(terminationMode);
                }

                @Override
                public void typeXBT(XBBlockType blockType) throws XBProcessingException, IOException {
                    listener.putType(blockType);
                }

                @Override
                public void attribXBT(XBAttribute attribute) throws XBProcessingException, IOException {
                    listener.putAttribute(attribute);
                }

                @Override
                public void dataXBT(InputStream data) throws XBProcessingException, IOException {
                    listener.putData(data);
                }

                @Override
                public void endXBT() throws XBProcessingException, IOException {
                    listener.putEnd();
                }
            });
        }
    }

    @ParametersAreNonnullByDefault
    public static class XBPSerialSequence
    implements XBPListener {
        private final List<XBSerialSequenceItem> items = new ArrayList<XBSerialSequenceItem>();
        private int depth = 0;
        private boolean isInOrder = false;
        private boolean childPresent = false;

        @Override
        public void putBegin(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
            ++this.depth;
            this.childPresent = false;
            this.items.add(new XBSerialSequenceItem(XBSerialSequenceOp.TOKEN, new XBPTokenWrapper(XBTBeginToken.create(terminationMode))));
        }

        @Override
        public void putType(XBBlockType type) throws XBProcessingException, IOException {
            this.items.add(new XBSerialSequenceItem(XBSerialSequenceOp.TOKEN, new XBPTokenWrapper(XBTTypeToken.create(type))));
        }

        @Override
        public void putAttribute(XBAttribute attribute) throws XBProcessingException, IOException {
            if (this.childPresent) {
                this.isInOrder = false;
            }
            this.items.add(new XBSerialSequenceItem(XBSerialSequenceOp.TOKEN, new XBPTokenWrapper(XBTAttributeToken.create(attribute))));
        }

        @Override
        public void putAttribute(byte attributeValue) throws XBProcessingException, IOException {
            if (this.childPresent) {
                this.isInOrder = false;
            }
            this.putAttribute(new UBNat32(attributeValue));
        }

        @Override
        public void putAttribute(short attributeValue) throws XBProcessingException, IOException {
            if (this.childPresent) {
                this.isInOrder = false;
            }
            this.putAttribute(new UBNat32(attributeValue));
        }

        @Override
        public void putAttribute(int attributeValue) throws XBProcessingException, IOException {
            if (this.childPresent) {
                this.isInOrder = false;
            }
            this.putAttribute(new UBNat32(attributeValue));
        }

        @Override
        public void putAttribute(long attributeValue) throws XBProcessingException, IOException {
            if (this.childPresent) {
                this.isInOrder = false;
            }
            this.putAttribute(new UBNat32(attributeValue));
        }

        @Override
        public void putData(InputStream data) throws XBProcessingException, IOException {
            this.items.add(new XBSerialSequenceItem(XBSerialSequenceOp.TOKEN, new XBPTokenWrapper(XBTDataToken.create(data))));
        }

        @Override
        public void putEnd() throws XBProcessingException, IOException {
            this.items.add(new XBSerialSequenceItem(XBSerialSequenceOp.TOKEN, new XBPTokenWrapper(XBTEndToken.create())));
            --this.depth;
            this.childPresent = true;
        }

        @Override
        public void putToken(XBTToken token) throws XBProcessingException, IOException {
            this.putItem(new XBSerialSequenceItem(XBSerialSequenceOp.TOKEN, new XBPTokenWrapper(token)));
        }

        @Override
        public void putConsist(XBSerializable serial) throws XBProcessingException, IOException {
            this.childPresent = true;
            this.items.add(new XBSerialSequenceItem(XBSerialSequenceOp.CONSIST, serial));
        }

        @Override
        public void putJoin(XBSerializable serial) throws XBProcessingException, IOException {
            this.childPresent = true;
            this.items.add(new XBSerialSequenceItem(XBSerialSequenceOp.JOIN, serial));
        }

        @Override
        public void putListConsist(XBSerializable serial) throws XBProcessingException, IOException {
            this.childPresent = true;
            this.items.add(new XBSerialSequenceItem(XBSerialSequenceOp.LIST_CONSIST, serial));
        }

        @Override
        public void putListJoin(XBSerializable serial) throws XBProcessingException, IOException {
            this.childPresent = true;
            this.items.add(new XBSerialSequenceItem(XBSerialSequenceOp.LIST_JOIN, serial));
        }

        @Override
        public void putItem(XBSerialSequenceItem item) throws XBProcessingException, IOException {
            if (item.getSequenceOp() == XBSerialSequenceOp.TOKEN) {
                switch (((XBPTokenWrapper)item.getItem()).getToken().getTokenType()) {
                    case BEGIN: {
                        this.childPresent = false;
                        ++this.depth;
                        break;
                    }
                    case END: {
                        --this.depth;
                        this.childPresent = true;
                    }
                }
                this.items.add(item);
            } else {
                this.items.add(item);
            }
        }

        @Override
        public void putAppend(XBSerializable serial) throws XBProcessingException, IOException {
            throw new IllegalStateException("Append is not allowed on sequencing");
        }

        @Nonnull
        public XBSerialSequenceItem pullItem() {
            return this.items.remove(0);
        }

        public void insertAtBegining(XBPSerialSequence sequence) {
            this.items.addAll(0, sequence.items);
        }

        public void insertAtBegining(XBSerialSequenceItem item) {
            this.items.add(0, item);
        }

        public void insertAtEnd(XBPSerialSequence sequence) {
            this.items.addAll(sequence.items);
        }

        public void dropLevel() {
            XBSerialSequenceItem beginItem = this.items.remove(0);
            if (beginItem == null || beginItem.getSequenceOp() != XBSerialSequenceOp.TOKEN || ((XBPTokenWrapper)beginItem.getItem()).getToken().getTokenType() != XBTTokenType.BEGIN) {
                throw new XBProcessingException("Missing begin token");
            }
            XBSerialSequenceItem typeItem = this.items.remove(0);
            if (typeItem == null || typeItem.getSequenceOp() != XBSerialSequenceOp.TOKEN || ((XBPTokenWrapper)typeItem.getItem()).getToken().getTokenType() != XBTTokenType.TYPE) {
                throw new XBProcessingException("Missing type token");
            }
            XBSerialSequenceItem endItem = this.items.remove(this.items.size() - 1);
            if (endItem == null || endItem.getSequenceOp() != XBSerialSequenceOp.TOKEN || ((XBPTokenWrapper)endItem.getItem()).getToken().getTokenType() != XBTTokenType.END) {
                throw new XBProcessingException("Missing end token");
            }
        }

        public boolean isEmpty() {
            return this.items.isEmpty();
        }

        public int getDepth() {
            return this.depth;
        }

        public boolean isClosed() {
            return this.depth == 0;
        }

        public boolean isIsInOrder() {
            return this.isInOrder;
        }
    }
}

