/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.serial.child;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.token.XBTAttributeToken;
import org.exbin.xbup.core.parser.token.XBTBeginToken;
import org.exbin.xbup.core.parser.token.XBTDataToken;
import org.exbin.xbup.core.parser.token.XBTEndToken;
import org.exbin.xbup.core.parser.token.XBTTypeToken;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;
import org.exbin.xbup.core.serial.XBSerialException;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.XBTWriteSerialHandler;
import org.exbin.xbup.core.serial.child.XBChildSerialState;
import org.exbin.xbup.core.serial.child.XBTChildOutputSerialHandler;
import org.exbin.xbup.core.serial.child.XBTChildSerializable;
import org.exbin.xbup.core.serial.token.XBTTokenOutputSerialHandler;
import org.exbin.xbup.core.ubnumber.UBNatural;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

@ParametersAreNonnullByDefault
public class XBTChildListenerSerialHandler
implements XBTChildOutputSerialHandler,
XBTTokenOutputSerialHandler {
    private XBTEventListener eventListener;
    private XBChildSerialState state = XBChildSerialState.BLOCK_BEGIN;
    private XBTWriteSerialHandler childHandler = null;

    public XBTChildListenerSerialHandler() {
    }

    public XBTChildListenerSerialHandler(XBTWriteSerialHandler childHandler) {
        this();
        this.childHandler = childHandler;
    }

    @Override
    public void attachXBTEventListener(XBTEventListener listener) {
        this.eventListener = listener;
    }

    @Override
    public void putBegin(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
        if (this.state == XBChildSerialState.EOF) {
            throw new XBSerialException("Unexpected method after block already finished", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state != XBChildSerialState.BLOCK_BEGIN) {
            throw new XBSerialException("Unable to set block terminated mode", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        this.eventListener.putXBTToken(XBTBeginToken.create(terminationMode));
        this.state = XBChildSerialState.ATTRIBUTE_PART;
    }

    @Override
    public void putType(XBBlockType type) throws XBProcessingException, IOException {
        if (this.state == XBChildSerialState.EOF) {
            throw new XBSerialException("Unexpected method after block already finished", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.BLOCK_BEGIN) {
            this.eventListener.putXBTToken(XBTBeginToken.create(XBBlockTerminationMode.SIZE_SPECIFIED));
        }
        this.eventListener.putXBTToken(XBTTypeToken.create(type));
        this.state = XBChildSerialState.TYPE;
    }

    @Override
    public void putAttribute(UBNatural attribute) throws XBSerialException, XBProcessingException, IOException {
        if (this.state == XBChildSerialState.EOF) {
            throw new XBSerialException("Unexpected method after block already finished", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.BLOCK_END) {
            throw new XBSerialException("Unable to add attributes after data or child blocks", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.BLOCK_BEGIN) {
            throw new XBSerialException("Missing block type event", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        this.eventListener.putXBTToken(XBTAttributeToken.create(attribute));
        this.state = XBChildSerialState.ATTRIBUTES;
    }

    @Override
    public void putChild(XBSerializable child) throws XBProcessingException, IOException {
        if (this.state == XBChildSerialState.EOF) {
            throw new XBSerialException("Unexpected method after block already finished", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.BLOCK_BEGIN) {
            throw new XBSerialException("At least one attribute is needed before child", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.BLOCK_END) {
            throw new XBSerialException("Unable to add child after data", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (child instanceof XBTChildSerializable) {
            XBTChildListenerSerialHandler childOutput = new XBTChildListenerSerialHandler();
            childOutput.attachXBTEventListener(this.eventListener);
            ((XBTChildSerializable)child).serializeToXB(childOutput);
        } else if (this.childHandler != null) {
            this.childHandler.write(child);
        } else {
            throw new XBProcessingException("Unsupported child serialization", XBProcessingExceptionType.UNKNOWN);
        }
        this.state = XBChildSerialState.CHILDREN;
    }

    @Override
    public void putAppend(XBSerializable serial) throws XBProcessingException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void putData(InputStream data) throws XBProcessingException, IOException {
        if (this.state == XBChildSerialState.EOF) {
            throw new XBSerialException("Unexpected method after block already finished", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.ATTRIBUTES) {
            throw new XBSerialException("Data block is not allowed after attributes", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.TYPE) {
            throw new XBSerialException("Data event is not allowed after block type event", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.BLOCK_BEGIN) {
            this.eventListener.putXBTToken(XBTBeginToken.create(XBBlockTerminationMode.SIZE_SPECIFIED));
        }
        this.eventListener.putXBTToken(XBTDataToken.create(data));
        this.state = XBChildSerialState.DATA;
    }

    @Override
    public void putEnd() throws XBProcessingException, IOException {
        if (this.state == XBChildSerialState.EOF) {
            throw new XBSerialException("Unexpected method after block already finished", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.BLOCK_BEGIN || this.state == XBChildSerialState.ATTRIBUTE_PART) {
            throw new XBSerialException("At least one attribute or data required");
        }
        this.eventListener.putXBTToken(XBTEndToken.create());
    }

    @Override
    public void putAttribute(byte attributeValue) throws XBProcessingException, IOException {
        this.putAttribute(new UBNat32(attributeValue));
    }

    @Override
    public void putAttribute(short attributeValue) throws XBProcessingException, IOException {
        this.putAttribute(new UBNat32(attributeValue));
    }

    @Override
    public void putAttribute(int attributeValue) throws XBProcessingException, IOException {
        this.putAttribute(new UBNat32(attributeValue));
    }

    @Override
    public void putAttribute(long attributeValue) throws XBProcessingException, IOException {
        this.putAttribute(new UBNat32(attributeValue));
    }
}

