/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.serial.child;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.parser.token.XBAttributeToken;
import org.exbin.xbup.core.parser.token.XBBeginToken;
import org.exbin.xbup.core.parser.token.XBDataToken;
import org.exbin.xbup.core.parser.token.XBToken;
import org.exbin.xbup.core.parser.token.XBTokenType;
import org.exbin.xbup.core.parser.token.pull.XBPullProvider;
import org.exbin.xbup.core.serial.XBReadSerialHandler;
import org.exbin.xbup.core.serial.XBSerialException;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.child.XBChildInputSerialHandler;
import org.exbin.xbup.core.serial.child.XBChildSerialState;
import org.exbin.xbup.core.serial.child.XBChildSerializable;
import org.exbin.xbup.core.serial.token.XBTokenInputSerialHandler;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

@ParametersAreNonnullByDefault
public class XBChildProviderSerialHandler
implements XBChildInputSerialHandler,
XBTokenInputSerialHandler {
    private XBPullProvider pullProvider;
    private XBChildSerialState state = XBChildSerialState.BLOCK_BEGIN;
    private XBReadSerialHandler childHandler = null;

    public XBChildProviderSerialHandler() {
    }

    public XBChildProviderSerialHandler(XBReadSerialHandler childHandler) {
        this();
        this.childHandler = childHandler;
    }

    @Override
    public void attachXBPullProvider(XBPullProvider pullProvider) {
        this.pullProvider = pullProvider;
    }

    @Override
    @Nonnull
    public XBBlockTerminationMode begin() throws XBProcessingException, IOException {
        if (this.state == XBChildSerialState.EOF) {
            throw new XBSerialException("Unexpected method after block already finished", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        XBToken token = this.pullProvider.pullXBToken();
        if (token.getTokenType() != XBTokenType.BEGIN) {
            throw new XBSerialException("Block must start with block begin", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        this.state = XBChildSerialState.ATTRIBUTE_PART;
        return ((XBBeginToken)token).getTerminationMode();
    }

    @Override
    @Nonnull
    public XBAttribute nextAttribute() throws XBProcessingException, IOException {
        if (this.state == XBChildSerialState.EOF) {
            throw new XBSerialException("Unexpected method after block already finished", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.DATA) {
            throw new XBSerialException("Unable to get attribute after data", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.CHILDREN) {
            throw new XBSerialException("Unable to get attribute after children", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.BLOCK_BEGIN && this.pullProvider.pullXBToken().getTokenType() != XBTokenType.BEGIN) {
            throw new XBSerialException("Block must start with block begin", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        XBToken token = this.pullProvider.pullXBToken();
        switch (token.getTokenType()) {
            case BEGIN: {
                this.state = XBChildSerialState.CHILDREN;
                break;
            }
            case ATTRIBUTE: {
                this.state = XBChildSerialState.ATTRIBUTES;
                return ((XBAttributeToken)token).getAttribute();
            }
            case DATA: {
                if (this.state == XBChildSerialState.ATTRIBUTES) {
                    throw new XBSerialException("Unexpected data after attributes", XBProcessingExceptionType.UNEXPECTED_ORDER);
                }
                throw new XBSerialException("Reading attributes of data block", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
            case END: {
                if (this.state != XBChildSerialState.BLOCK_END) {
                    throw new XBSerialException("Block without data or attributes not allowed", XBProcessingExceptionType.UNEXPECTED_ORDER);
                }
                this.state = XBChildSerialState.EOF;
                break;
            }
            default: {
                throw new XBSerialException("Unexpected token type", XBProcessingExceptionType.UNSUPPORTED);
            }
        }
        this.state = XBChildSerialState.ATTRIBUTES;
        return new UBNat32();
    }

    @Override
    @Nonnull
    public void nextChild(XBSerializable child) throws XBProcessingException, IOException {
        if (this.state == XBChildSerialState.EOF) {
            throw new XBSerialException("Unexpected method after block already finished", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.BLOCK_END) {
            throw new XBSerialException("No more children available", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.DATA) {
            throw new XBSerialException("No children after data allowed", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.BLOCK_BEGIN && this.pullProvider.pullXBToken().getTokenType() != XBTokenType.BEGIN) {
            throw new XBSerialException("Block must start with block begin", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (child instanceof XBChildSerializable) {
            this.state = XBChildSerialState.CHILDREN;
            XBChildProviderSerialHandler childInput = new XBChildProviderSerialHandler();
            childInput.attachXBPullProvider(this.pullProvider);
            ((XBChildSerializable)child).serializeFromXB(childInput);
        } else if (this.childHandler != null) {
            this.childHandler.read(child);
        } else {
            throw new XBProcessingException("Unsupported child serialization", XBProcessingExceptionType.UNKNOWN);
        }
    }

    @Override
    @Nonnull
    public InputStream nextData() throws XBProcessingException, IOException {
        if (this.state == XBChildSerialState.EOF) {
            throw new XBSerialException("Unexpected method after block already finished", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.ATTRIBUTES) {
            throw new XBSerialException("No data block allowed after attributes", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.DATA) {
            throw new XBSerialException("No data block allowed after data", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.BLOCK_BEGIN && this.pullProvider.pullXBToken().getTokenType() != XBTokenType.BEGIN) {
            throw new XBSerialException("Block must start with block begin", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        XBToken token = this.pullProvider.pullXBToken();
        if (token.getTokenType() != XBTokenType.DATA) {
            throw new XBSerialException("Data block missing", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        this.state = XBChildSerialState.DATA;
        return ((XBDataToken)token).getData();
    }

    @Override
    public void end() throws XBProcessingException, IOException {
        if (this.state == XBChildSerialState.EOF) {
            throw new XBSerialException("Unexpected method after block already finished", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        XBToken token = this.pullProvider.pullXBToken();
        if (token.getTokenType() != XBTokenType.END) {
            throw new XBSerialException("End method was expected but not received", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        this.state = XBChildSerialState.EOF;
    }
}

