/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.serial;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.event.XBEventWriter;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;
import org.exbin.xbup.core.parser.token.event.convert.XBTToXBEventConvertor;
import org.exbin.xbup.core.serial.XBPSerialReader;
import org.exbin.xbup.core.serial.XBPWriteSerialHandler;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.param.XBPSerializable;

@ParametersAreNonnullByDefault
public class XBPSerialWriter
implements XBPWriteSerialHandler {
    protected final XBTEventListener eventListener;

    public XBPSerialWriter(XBTEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public XBPSerialWriter(OutputStream outputStream) {
        XBTToXBEventConvertor listener = null;
        try {
            listener = new XBTToXBEventConvertor(new XBEventWriter(outputStream));
        }
        catch (IOException ex) {
            Logger.getLogger(XBPSerialReader.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.eventListener = listener;
    }

    @Override
    public void write(XBSerializable serial) {
        if (serial instanceof XBPSerializable || serial instanceof XBPSequenceSerializable) {
            XBPListenerSerialHandler childOutput = new XBPListenerSerialHandler();
            childOutput.attachXBTEventListener(this.eventListener);
            try {
                childOutput.process(serial);
            }
            catch (IOException | XBProcessingException ex) {
                Logger.getLogger(XBPSerialWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            throw new UnsupportedOperationException("Serialization method " + serial.getClass().getCanonicalName() + " not supported.");
        }
    }

    public static boolean isValidSerializableObject(XBSerializable serial) {
        return serial instanceof XBPSerializable || serial instanceof XBPSequenceSerializable;
    }
}

