/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token.pull.convert;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.XBAttributeToken;
import org.exbin.xbup.core.parser.token.XBBeginToken;
import org.exbin.xbup.core.parser.token.XBDataToken;
import org.exbin.xbup.core.parser.token.XBTAttributeToken;
import org.exbin.xbup.core.parser.token.XBTBeginToken;
import org.exbin.xbup.core.parser.token.XBTDataToken;
import org.exbin.xbup.core.parser.token.XBTEndToken;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTypeToken;
import org.exbin.xbup.core.parser.token.XBToken;
import org.exbin.xbup.core.parser.token.pull.XBPullConsumer;
import org.exbin.xbup.core.parser.token.pull.XBPullProvider;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;

@ParametersAreNonnullByDefault
public class XBTToXBPullWrapper
implements XBTPullProvider,
XBPullConsumer {
    @Nonnull
    private XBPullProvider pullProvider;
    private final XBFixedBlockType unknownBlockType = new XBFixedBlockType();
    private boolean typeSent = false;
    @Nullable
    private XBToken attributeToken = null;

    public XBTToXBPullWrapper(XBPullProvider pullProvider) {
        this.pullProvider = pullProvider;
    }

    @Override
    public void attachXBPullProvider(XBPullProvider pullProvider) {
        this.pullProvider = pullProvider;
    }

    @Override
    @Nonnull
    public XBTToken pullXBTToken() throws XBProcessingException, IOException {
        if (this.attributeToken != null) {
            XBToken token = this.attributeToken;
            this.attributeToken = null;
            return XBTAttributeToken.create(((XBAttributeToken)token).getAttribute());
        }
        XBToken token = this.pullProvider.pullXBToken();
        switch (token.getTokenType()) {
            case BEGIN: {
                this.typeSent = false;
                return XBTBeginToken.create(((XBBeginToken)token).getTerminationMode());
            }
            case ATTRIBUTE: {
                if (!this.typeSent) {
                    this.attributeToken = token;
                    this.typeSent = true;
                    return XBTTypeToken.create(this.unknownBlockType);
                }
                return XBTAttributeToken.create(((XBAttributeToken)token).getAttribute());
            }
            case DATA: {
                return XBTDataToken.create(((XBDataToken)token).getData());
            }
            case END: {
                return XBTEndToken.create();
            }
        }
        throw new IllegalStateException();
    }
}

