/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token.event.convert;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.XBAttributeToken;
import org.exbin.xbup.core.parser.token.XBBeginToken;
import org.exbin.xbup.core.parser.token.XBDataToken;
import org.exbin.xbup.core.parser.token.XBTAttributeToken;
import org.exbin.xbup.core.parser.token.XBTBeginToken;
import org.exbin.xbup.core.parser.token.XBTDataToken;
import org.exbin.xbup.core.parser.token.XBTEndToken;
import org.exbin.xbup.core.parser.token.XBTTypeToken;
import org.exbin.xbup.core.parser.token.XBToken;
import org.exbin.xbup.core.parser.token.event.XBEventListener;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;
import org.exbin.xbup.core.parser.token.event.XBTEventProducer;
import org.exbin.xbup.core.ubnumber.UBNatural;

@ParametersAreNonnullByDefault
public class XBToXBTEventConvertor
implements XBEventListener,
XBTEventProducer {
    @Nonnull
    private XBTEventListener target;
    private boolean expectType;
    @Nullable
    private UBNatural group;

    public XBToXBTEventConvertor(XBTEventListener target) {
        this.target = target;
        this.expectType = true;
    }

    @Override
    public void attachXBTEventListener(XBTEventListener eventListener) {
        this.target = eventListener;
    }

    @Override
    public void putXBToken(XBToken token) throws XBProcessingException, IOException {
        switch (token.getTokenType()) {
            case BEGIN: {
                if (this.expectType && this.group != null) {
                    this.target.putXBTToken(XBTTypeToken.create(new XBFixedBlockType(this.group.getLong(), 0L)));
                }
                this.target.putXBTToken(XBTBeginToken.create(((XBBeginToken)token).getTerminationMode()));
                this.expectType = true;
                this.group = null;
                break;
            }
            case ATTRIBUTE: {
                if (this.expectType) {
                    if (this.group != null) {
                        this.target.putXBTToken(XBTTypeToken.create(new XBFixedBlockType(this.group.getLong(), ((XBAttributeToken)token).getAttribute().getNaturalLong())));
                        this.expectType = false;
                        break;
                    }
                    this.group = ((XBAttributeToken)token).getAttribute().convertToNatural();
                    break;
                }
                this.target.putXBTToken(XBTAttributeToken.create(((XBAttributeToken)token).getAttribute()));
                break;
            }
            case DATA: {
                if (this.expectType && this.group != null) {
                    this.target.putXBTToken(XBTTypeToken.create(new XBFixedBlockType(this.group.getLong(), 0L)));
                }
                this.target.putXBTToken(XBTDataToken.create(((XBDataToken)token).getData()));
                break;
            }
            case END: {
                if (this.expectType && this.group != null) {
                    this.target.putXBTToken(XBTTypeToken.create(new XBFixedBlockType(this.group.getLong(), 0L)));
                }
                this.target.putXBTToken(XBTEndToken.create());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected token type " + token.getTokenType().toString());
            }
        }
    }
}

